/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.util;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public record NumberRange<T extends Number>(T min, T max) {
    public NumberRange {
        if (((Comparable)min).compareTo(max) > 0) {
            throw new IllegalArgumentException("Min cannot be greater than max");
        }
    }

    public boolean contains(@NotNull T value) {
        return ((Comparable)value).compareTo(this.min) >= 0 && ((Comparable)value).compareTo(this.max) <= 0;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public String toString() {
        return "Range[" + this.min + ", " + this.max + "]";
    }
}

