/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.resources.data.vision.codec;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import net.lixir.vminus.resources.data.vision.codec.VisionCodec;
import net.lixir.vminus.vision.values.VisionValue;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.SoundType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisionSoundTypeCodec
extends VisionCodec<SoundType> {
    @Override
    public Class<SoundType> getClassType() {
        return SoundType.class;
    }

    @Override
    @Nullable
    public List<VisionValue<SoundType>> decode(@NotNull JsonObject jsonObject, String key) throws JsonParseException {
        ArrayList<VisionValue<SoundType>> visionProperties = new ArrayList<VisionValue<SoundType>>();
        JsonArray jsonArray = jsonObject.getAsJsonArray(key);
        for (JsonElement jsonArrayElement : jsonArray) {
            float level;
            float pitch;
            JsonObject arrayObject = jsonArrayElement.getAsJsonObject();
            SoundEvent fallSound = VisionSoundTypeCodec.parseSoundInObject(arrayObject, "fall", SoundEvents.f_12445_);
            SoundEvent stepSound = VisionSoundTypeCodec.parseSoundInObject(arrayObject, "step", SoundEvents.f_12450_);
            SoundEvent breakSound = VisionSoundTypeCodec.parseSoundInObject(arrayObject, "break", SoundEvents.f_12442_);
            SoundEvent placeSound = VisionSoundTypeCodec.parseSoundInObject(arrayObject, "place", SoundEvents.f_12447_);
            SoundEvent hitSound = VisionSoundTypeCodec.parseSoundInObject(arrayObject, "hit", SoundEvents.f_12446_);
            float f = pitch = arrayObject.has("pitch") ? arrayObject.getAsJsonPrimitive("pitch").getAsFloat() : 1.0f;
            if (pitch < 0.0f) {
                throw new JsonParseException(pitch + " is not an accepted pitch value for " + key + ". Must be greater than 0");
            }
            float f2 = level = arrayObject.has("level") ? arrayObject.getAsJsonPrimitive("level").getAsFloat() : 1.0f;
            if (level < 0.0f) {
                throw new JsonParseException(level + " is not an accepted level value for " + key + ". Must be greater than 0");
            }
            SoundType soundType = new SoundType(level, pitch, breakSound, stepSound, placeSound, hitSound, fallSound);
            visionProperties.add(VisionValue.create(soundType, arrayObject, jsonObject, key));
        }
        return visionProperties;
    }

    @Override
    @Nullable
    public JsonObject encode(@NotNull SoundType value) {
        JsonObject jsonObject = new JsonObject();
        if (value.m_56774_() != 1.0f) {
            jsonObject.addProperty("pitch", (Number)Float.valueOf(value.m_56774_()));
        }
        if (value.m_56773_() != 1.0f) {
            jsonObject.addProperty("level", (Number)Float.valueOf(value.m_56773_()));
        }
        jsonObject.addProperty("break", this.getSoundId(value.m_56775_()));
        jsonObject.addProperty("step", this.getSoundId(value.m_56776_()));
        jsonObject.addProperty("place", this.getSoundId(value.m_56777_()));
        jsonObject.addProperty("hit", this.getSoundId(value.m_56778_()));
        jsonObject.addProperty("fall", this.getSoundId(value.m_56779_()));
        return jsonObject;
    }

    @NotNull
    private String getSoundId(@NotNull SoundEvent soundEvent) {
        return soundEvent.m_11660_().toString();
    }
}

