/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.resources.data.vision.codec;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import net.lixir.vminus.resources.data.vision.codec.VisionCodec;
import net.lixir.vminus.vision.util.ItemStackWrapper;
import net.lixir.vminus.vision.values.VisionValue;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisionItemStackCodec
extends VisionCodec<ItemStackWrapper> {
    @Override
    public Class<ItemStackWrapper> getClassType() {
        return ItemStackWrapper.class;
    }

    @Override
    @Nullable
    public List<VisionValue<ItemStackWrapper>> decode(@NotNull JsonObject jsonObject, String key) throws JsonParseException {
        ArrayList<VisionValue<ItemStackWrapper>> visionProperties = new ArrayList<VisionValue<ItemStackWrapper>>();
        JsonArray jsonArray = jsonObject.getAsJsonArray(key);
        for (JsonElement jsonArrayElement : jsonArray) {
            JsonObject arrayObject = jsonArrayElement.getAsJsonObject();
            ResourceLocation resourceLocation = VisionItemStackCodec.parseResourceLocation(key, arrayObject);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
            if (item == null) {
                throw new JsonParseException(resourceLocation + " is not a valid item.");
            }
            ItemStack itemStack = item.m_7968_();
            ItemStackWrapper itemStackWrapper = new ItemStackWrapper(itemStack);
            visionProperties.add(VisionValue.create(itemStackWrapper, arrayObject, jsonObject, key));
        }
        return visionProperties;
    }

    @Override
    @Nullable
    public JsonObject encode(@NotNull ItemStackWrapper value) {
        JsonObject jsonObject = new JsonObject();
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)value.itemStack().m_41720_());
        if (id == null) {
            throw new JsonParseException("Cannot encode ItemStack with unregistered item: " + value);
        }
        JsonPrimitive idPrimitive = new JsonPrimitive(id.toString());
        jsonObject.add("value", (JsonElement)idPrimitive);
        return jsonObject;
    }
}

