/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.resources.data.vision.codec;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.lixir.vminus.resources.data.vision.codec.VisionCodec;
import net.lixir.vminus.vision.util.VisionFoodProperties;
import net.lixir.vminus.vision.values.VisionValue;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisionFoodPropertiesCodec
extends VisionCodec<VisionFoodProperties> {
    @Override
    public Class<VisionFoodProperties> getClassType() {
        return VisionFoodProperties.class;
    }

    @Override
    @Nullable
    public List<VisionValue<VisionFoodProperties>> decode(JsonObject jsonObject, String key) throws JsonParseException {
        ArrayList<VisionValue<VisionFoodProperties>> visionProperties = new ArrayList<VisionValue<VisionFoodProperties>>();
        JsonArray jsonArray = jsonObject.getAsJsonArray(key);
        for (JsonElement jsonArrayElement : jsonArray) {
            JsonObject arrayObject = jsonArrayElement.getAsJsonObject();
            Integer nutrition = null;
            if (arrayObject.has("nutrition") && ((nutrition = Integer.valueOf(arrayObject.getAsJsonPrimitive("nutrition").getAsInt())) > 20 || nutrition < 0)) {
                throw new JsonParseException(nutrition + " is not an accepted nutrition for " + key + ". Must be within 0 to 20");
            }
            Float saturation = null;
            if (arrayObject.has("saturation") && (saturation = Float.valueOf(arrayObject.getAsJsonPrimitive("saturation").getAsFloat())).floatValue() < 0.0f) {
                throw new JsonParseException(saturation + " is not an accepted saturation for " + key + ". Must be greater than 0");
            }
            Boolean alwaysEdible = null;
            if (arrayObject.has("always_edible")) {
                alwaysEdible = arrayObject.getAsJsonPrimitive("always_edible").getAsBoolean();
            }
            Boolean isMeat = null;
            if (arrayObject.has("meat")) {
                isMeat = arrayObject.getAsJsonPrimitive("meat").getAsBoolean();
            }
            SoundEvent eatSound = VisionFoodPropertiesCodec.parseSoundInObject(arrayObject, "eat_sound", SoundEvents.f_11912_);
            SoundEvent burpSound = VisionFoodPropertiesCodec.parseSoundInObject(arrayObject, "burp_sound", SoundEvents.f_12321_);
            List<Pair<MobEffectInstance, Float>> effects = VisionFoodPropertiesCodec.parseFoodEffects(arrayObject);
            VisionFoodProperties visionFoodProperties = new VisionFoodProperties(nutrition, saturation, alwaysEdible, isMeat, eatSound, burpSound, effects);
            visionProperties.add(VisionValue.create(visionFoodProperties, arrayObject, jsonObject, key));
        }
        return visionProperties;
    }

    @Override
    @Nullable
    public JsonObject encode(@NotNull VisionFoodProperties value) {
        JsonObject object = new JsonObject();
        if (value.nutrition() != null) {
            object.addProperty("nutrition", (Number)value.nutrition());
        }
        if (value.saturation() != null) {
            object.addProperty("saturation", (Number)value.saturation());
        }
        if (value.alwaysEdible() != null) {
            object.addProperty("always_edible", value.alwaysEdible());
        }
        if (value.isMeat() != null) {
            object.addProperty("meat", value.isMeat());
        }
        if (value.eatSound() != null && ForgeRegistries.SOUND_EVENTS.getKey((Object)value.eatSound()) != null) {
            object.addProperty("eat_sound", ForgeRegistries.SOUND_EVENTS.getKey((Object)value.eatSound()).toString());
        }
        if (value.burpSound() != null && ForgeRegistries.SOUND_EVENTS.getKey((Object)value.burpSound()) != null) {
            object.addProperty("burp_sound", ForgeRegistries.SOUND_EVENTS.getKey((Object)value.burpSound()).toString());
        }
        if (!value.effects().isEmpty()) {
            JsonArray effectsArray = new JsonArray();
            for (Pair<MobEffectInstance, Float> pair : value.effects()) {
                MobEffectInstance instance = (MobEffectInstance)pair.getFirst();
                Float chance = (Float)pair.getSecond();
                MobEffect effect = instance.m_19544_();
                JsonObject effectObj = new JsonObject();
                ResourceLocation id = ForgeRegistries.MOB_EFFECTS.getKey((Object)effect);
                if (id != null) {
                    effectObj.addProperty("id", id.toString());
                }
                if (instance.m_19564_() != 0) {
                    effectObj.addProperty("amplifier", (Number)instance.m_19564_());
                }
                if (instance.m_19557_() != 600) {
                    effectObj.addProperty("duration", (Number)instance.m_19557_());
                }
                if (chance.floatValue() != 1.0f) {
                    effectObj.addProperty("chance", (Number)chance);
                }
                effectsArray.add((JsonElement)effectObj);
            }
            object.add("effects", (JsonElement)effectsArray);
        }
        return object;
    }

    private static List<Pair<MobEffectInstance, Float>> parseFoodEffects(JsonObject jsonObject) throws JsonParseException {
        ArrayList<Pair<MobEffectInstance, Float>> effects = new ArrayList<Pair<MobEffectInstance, Float>>();
        if (jsonObject.has("effects")) {
            JsonArray effectsArray = jsonObject.getAsJsonArray("effects");
            for (JsonElement effectElement : effectsArray) {
                float chance;
                ResourceLocation effectLocation;
                JsonObject effectObject = effectElement.getAsJsonObject();
                String effectId = effectObject.getAsJsonPrimitive("id").getAsString();
                try {
                    effectLocation = new ResourceLocation(effectId);
                }
                catch (Exception e) {
                    throw new JsonParseException(effectId + " is an invalid effect ID");
                }
                MobEffect mobEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectLocation);
                if (mobEffect == null) {
                    throw new JsonParseException(effectId + " is not a registered effect");
                }
                int amplifier = effectObject.has("amplifier") ? effectObject.getAsJsonPrimitive("amplifier").getAsInt() : 0;
                int duration = effectObject.has("duration") ? effectObject.getAsJsonPrimitive("duration").getAsInt() : 600;
                float f = chance = effectObject.has("chance") ? effectObject.getAsJsonPrimitive("chance").getAsFloat() : 1.0f;
                if (amplifier < 0) {
                    throw new JsonParseException("Amplifier cannot be negative for effect: " + effectId);
                }
                if (duration <= 0) {
                    throw new JsonParseException("Duration must be greater than 0 for effect: " + effectId);
                }
                if (chance < 0.0f || chance > 1.0f) {
                    throw new JsonParseException("Chance must be between 0 and 1 for effect: " + effectId);
                }
                effects.add((Pair<MobEffectInstance, Float>)new Pair((Object)new MobEffectInstance(mobEffect, duration, amplifier), (Object)Float.valueOf(chance)));
            }
        }
        return effects;
    }
}

