/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.resources.data.vision;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.lixir.vminus.VMinus;
import net.lixir.vminus.mixins.server.SimpleJsonResourceReloadListenerAccessor;
import net.lixir.vminus.resources.data.vision.VisionDeserializer;
import net.lixir.vminus.resources.data.vision.VisionFormatter;
import net.lixir.vminus.vision.Vision;
import net.lixir.vminus.vision.VisionDuck;
import net.lixir.vminus.vision.VisionEntry;
import net.lixir.vminus.vision.VisionType;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;

public class VisionManager<T>
extends SimpleJsonResourceReloadListener {
    private static final Set<VisionManager<?>> VISION_MANAGERS = new HashSet();
    private final ICondition.IContext context;
    private final String directory;
    private final String singleListName;
    private final String multiListName;
    private final Gson gson;
    private final VisionType<T> visionType;
    private final Registry<T> registry;
    protected final Map<ResourceLocation, Vision> idToVisionMap = new HashMap<ResourceLocation, Vision>();

    public VisionManager(@NotNull VisionType<T> visionType, Registry<T> registry, ICondition.IContext context) {
        super(new GsonBuilder().registerTypeAdapter(VisionEntry.class, new VisionDeserializer<T>(visionType.getMultiList(), visionType)).setPrettyPrinting().disableHtmlEscaping().create(), visionType.getDirectory());
        this.context = context;
        this.directory = visionType.getDirectory();
        this.singleListName = visionType.getId();
        this.multiListName = visionType.getMultiList();
        this.visionType = visionType;
        this.registry = registry;
        this.gson = ((SimpleJsonResourceReloadListenerAccessor)((Object)this)).getGson();
        VISION_MANAGERS.add(this);
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> resourceLocationJsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        int configSize;
        File[] files;
        File configDir;
        ArrayList<VisionEntry<T>> visionEntries = new ArrayList<VisionEntry<T>>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : resourceLocationJsonElementMap.entrySet()) {
            this.loadVisionEntry(entry.getKey().toString(), entry.getValue(), visionEntries);
        }
        int datapackSize = visionEntries.size();
        if (datapackSize > 0) {
            VMinus.LOGGER.info("Loaded {} {} visions from data", (Object)datapackSize, (Object)this.visionType.getId());
        }
        if ((configDir = new File(FMLPaths.CONFIGDIR.get().toFile(), this.directory)).exists() && configDir.isDirectory() && (files = configDir.listFiles((dir, name) -> name.endsWith(".json"))) != null) {
            for (File file : files) {
                try (FileReader reader = new FileReader(file);){
                    JsonElement element = JsonParser.parseReader((Reader)reader);
                    this.loadVisionEntry(file.getName(), element, visionEntries);
                }
                catch (Exception e) {
                    VMinus.LOGGER.error("Error reading config file '{}':", (Object)file.getName(), (Object)e);
                }
            }
        }
        if ((configSize = visionEntries.size() - datapackSize) > 0) {
            VMinus.LOGGER.info("Loaded {} {} visions from config", (Object)configSize, (Object)this.visionType.getId());
        }
        for (Object value : this.registry) {
            ResourceLocation id = this.registry.m_7981_(value);
            if (id == null) continue;
            ((VisionDuck)value).vMinus$setVisionId(id);
            VisionEntry mergedEntry = this.buildMergedEntry(value, id.toString(), visionEntries);
            if (mergedEntry.isEmpty()) continue;
            Vision vision = Vision.fromEntry(id, mergedEntry, this.visionType);
            this.idToVisionMap.put(id, vision);
            this.visionType.putVision(id, vision);
            this.visionType.applyVision(value, id);
        }
    }

    @NotNull
    private VisionEntry<T> buildMergedEntry(T value, String id, @NotNull List<VisionEntry<T>> visionEntries) {
        VisionEntry<T> mergedEntry = new VisionEntry<T>();
        for (VisionEntry<T> visionEntry : visionEntries) {
            if (!VisionEntry.visionApplies(value, id, visionEntry.getEntries(), this.context)) continue;
            mergedEntry.merge(visionEntry);
        }
        return mergedEntry;
    }

    private void loadVisionEntry(String source, JsonElement element, List<VisionEntry<T>> outputList) {
        try {
            JsonObject processed = VisionFormatter.processJson(this.singleListName, this.multiListName, element);
            VisionEntry entry = (VisionEntry)this.gson.fromJson((JsonElement)processed, new TypeToken<VisionEntry<T>>(){}.getType());
            outputList.add(entry);
        }
        catch (Exception e) {
            VMinus.LOGGER.error("Failed to load VisionEntry from '{}': {}", (Object)source, (Object)e.getMessage());
        }
    }

    public static void clearVisionManagers() {
        VISION_MANAGERS.clear();
    }

    @NotNull
    public static @UnmodifiableView Set<VisionManager<?>> getVisionManagers() {
        return VISION_MANAGERS;
    }

    public Set<Map.Entry<ResourceLocation, Vision>> getVisionEntries() {
        return this.idToVisionMap.entrySet();
    }

    public VisionType<T> getVisionType() {
        return this.visionType;
    }

    public int hashCode() {
        return this.visionType.hashCode();
    }

    public String toString() {
        return "VisionManager[" + this.singleListName + "]";
    }
}

