/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.registry.entry;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.lixir.vminus.datagen.BlockModel;
import net.lixir.vminus.datagen.ItemModel;
import net.lixir.vminus.registry.TintType;
import net.lixir.vminus.registry.VRegistry;
import net.lixir.vminus.registry.entry.BlockEntry;
import net.lixir.vminus.registry.entry.RegistryEntry;
import net.lixir.vminus.registry.entry.accessor.ItemEntryAccessor;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ItemEntry
extends RegistryEntry<ItemEntry, Item> {
    public static final ItemEntry EMPTY = ItemEntry.of();
    @NotNull
    protected final Set<TagKey<Item>> tags = new HashSet<TagKey<Item>>();
    @NotNull
    protected ItemModel model = ItemModel.UNSET;
    @NotNull
    protected TintType tint = TintType.UNSET;
    private boolean fromBlock = false;

    private ItemEntry() {
    }

    @NotNull
    public static ItemEntry of(Item item) {
        ItemEntry accessed = ((ItemEntryAccessor)item).vminus$getEntry();
        if (accessed != null) {
            ItemEntry itemEntry;
            BlockItem blockItem;
            BlockEntry blockEntry;
            if (item instanceof BlockItem && !(blockEntry = BlockEntry.of(blockItem = (BlockItem)item)).isEmpty() && !(itemEntry = blockEntry.getItemEntry()).isEmpty()) {
                return accessed.merge(itemEntry);
            }
            return accessed;
        }
        return ItemEntry.of();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static ItemEntry of() {
        return new ItemEntry();
    }

    @NotNull
    public static ItemEntry from(@Nullable BlockEntry blockEntry) {
        ItemEntry itemEntry = ItemEntry.of();
        if (blockEntry != null) {
            itemEntry.lang = null;
            itemEntry.tint = blockEntry.tintType;
            BlockModel blockModel = blockEntry.getModel();
            if (!blockModel.equals(BlockModel.NONE) && !blockModel.equals(BlockModel.UNSET)) {
                itemEntry.model = blockModel.getItemModel();
            }
            itemEntry.fromBlock = true;
            itemEntry.merge(blockEntry.itemEntry);
        }
        return itemEntry;
    }

    @NotNull
    public static ItemEntry from(Block block) {
        return ItemEntry.from(BlockEntry.of(block));
    }

    public boolean isEmpty() {
        return this.equals(EMPTY);
    }

    @NotNull
    public static ItemEntry defaults() {
        ItemEntry itemEntry = new ItemEntry();
        itemEntry.isDefaulted = true;
        return itemEntry;
    }

    @Override
    public ItemEntry setDefault(@NotNull Item item) {
        ItemEntry itemEntry = VRegistry.getItemEntry(item);
        this.merge(itemEntry);
        return this;
    }

    @NotNull
    public TintType getTint() {
        return this.tint;
    }

    public ItemEntry model(@NotNull ItemModel model) {
        if (ItemEntry.isDatagen()) {
            this.model = model;
        }
        return this;
    }

    @NotNull
    public ItemModel getModel() {
        return this.model;
    }

    public ItemEntry tint(@NotNull TintType tintType) {
        this.tint = tintType;
        return this;
    }

    @SafeVarargs
    public final ItemEntry tags(TagKey<Item> ... tags) {
        if (ItemEntry.isDatagen()) {
            this.tags.addAll(Arrays.asList(tags));
        }
        return this;
    }

    @NotNull
    public Set<TagKey<Item>> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    public ItemEntry isFromBlock(boolean isFromBlock) {
        this.fromBlock = isFromBlock;
        return this;
    }

    @Override
    public ItemEntry lang(String langValue) {
        if (ItemEntry.isDatagen()) {
            this.lang = langValue;
        }
        return this;
    }

    @Override
    @NotNull
    public ItemEntry merge(@Nullable ItemEntry other) {
        if (other == null) {
            return this;
        }
        this.tags.addAll(other.getTags());
        if (this.model == ItemModel.UNSET) {
            this.model = other.model;
        }
        if (this.tint == TintType.UNSET) {
            this.tint = other.tint;
        }
        return this;
    }

    public boolean isFromBlock() {
        return this.fromBlock;
    }

    public String toString() {
        return "ItemEntry{tags=" + this.tags + ", model=" + this.model + ", tint=" + this.tint + ", fromBlock=" + this.fromBlock + ", isDefaulted=" + this.isDefaulted + ", langValue='" + this.lang + "'}";
    }
}

