/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.registry.entry;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.lixir.vminus.registry.entry.RegistryEntry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class EntityEntry
extends RegistryEntry<EntityEntry, EntityType<?>> {
    protected final Set<TagKey<EntityType<?>>> tags = new HashSet();

    private EntityEntry() {
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static EntityEntry of() {
        return new EntityEntry();
    }

    @SafeVarargs
    public final EntityEntry tag(TagKey<EntityType<?>> ... tags) {
        this.tags.addAll(Arrays.asList(tags));
        return this;
    }

    @NotNull
    public Set<TagKey<EntityType<?>>> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    @Override
    public EntityEntry lang(String lang) {
        this.lang = lang;
        return this;
    }

    @Override
    @NotNull
    public EntityEntry merge(EntityEntry other) {
        return this;
    }
}

