/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.lixir.vminus.cape.Cape;
import net.lixir.vminus.command.VMinusCommandSuggestionProviders;
import net.lixir.vminus.network.SyncCapePacket;
import net.lixir.vminus.network.VMinusSavedData;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
public class VMinusCommands {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    @SubscribeEvent
    public static void registerCommand(@NotNull RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        CommandBuildContext context = event.getBuildContext();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dimension").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"dimension", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(VMinusCommandSuggestionProviders.DIMENSIONS).executes(VMinusCommands::teleportToDimension)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"fire").requires(s -> s.m_6761_(3))).then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"seconds", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(arguments -> {
            for (Entity entity : EntityArgument.m_91461_((CommandContext)arguments, (String)"entities")) {
                entity.m_20254_((int)DoubleArgumentType.getDouble((CommandContext)arguments, (String)"seconds"));
            }
            return 0;
        }))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"heal").requires(s -> s.m_6761_(3))).then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"health", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(arguments -> {
            Level world = ((CommandSourceStack)arguments.getSource()).getUnsidedLevel();
            Entity entity = ((CommandSourceStack)arguments.getSource()).m_81373_();
            if (entity == null && world instanceof ServerLevel) {
                ServerLevel _servLevel = (ServerLevel)world;
                entity = FakePlayerFactory.getMinecraft((ServerLevel)_servLevel);
            }
            String currentDimension = "";
            currentDimension = entity.m_9236_().m_46472_().m_135782_().toString();
            try {
                for (Entity entityiterator : EntityArgument.m_91461_((CommandContext)arguments, (String)"entities")) {
                    float f;
                    ServerLevel _origLevel;
                    if (!(world instanceof ServerLevel) || (world = (_origLevel = (ServerLevel)world).m_7654_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(currentDimension)))) == null || !(entityiterator instanceof LivingEntity)) continue;
                    LivingEntity _entity = (LivingEntity)entityiterator;
                    if (entity instanceof LivingEntity) {
                        LivingEntity _livEnt = (LivingEntity)entity;
                        f = _livEnt.m_21223_();
                    } else {
                        f = -1.0f;
                    }
                    _entity.m_21153_((float)((double)f + DoubleArgumentType.getDouble((CommandContext)arguments, (String)"health")));
                }
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
            return 0;
        }))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"freeze").requires(s -> s.m_6761_(3))).then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"ticks", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(arguments -> {
            Level world = ((CommandSourceStack)arguments.getSource()).getUnsidedLevel();
            Entity entity = ((CommandSourceStack)arguments.getSource()).m_81373_();
            if (entity == null && world instanceof ServerLevel) {
                ServerLevel _servLevel = (ServerLevel)world;
                entity = FakePlayerFactory.getMinecraft((ServerLevel)_servLevel);
            }
            entity.m_146917_((int)DoubleArgumentType.getDouble((CommandContext)arguments, (String)"ticks"));
            return 0;
        }))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"cape").requires(s -> s.m_6761_(1))).then(Commands.m_82129_((String)"capeId", (ArgumentType)StringArgumentType.string()).suggests(VMinusCommands::getCapeSuggestions).executes(arguments -> {
            Player player = (Player)((CommandSourceStack)arguments.getSource()).m_81373_();
            String capeId = StringArgumentType.getString((CommandContext)arguments, (String)"capeId");
            if (player != null) {
                if (Cape.ownsCape((Entity)player, capeId) || capeId.equals("default")) {
                    player.getCapability(VMinusSavedData.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                        capability.cape_id = capeId;
                        capability.syncPlayerVariables((Entity)player);
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            SyncCapePacket.sendToAll(serverPlayer, capeId);
                        }
                    });
                    player.m_213846_((Component)Component.m_237113_((String)("Cape set to " + capeId)).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
                } else {
                    player.m_213846_((Component)Component.m_237113_((String)"You do not own this cape or it does not exist.").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
                }
            }
            return 0;
        })));
    }

    public static int teleportToDimension(CommandContext<CommandSourceStack> context) {
        ResourceKey dimensionKey;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_230896_();
        ResourceLocation dimensionId = ResourceLocationArgument.m_107011_(context, (String)"dimension");
        MinecraftServer server = source.m_81377_();
        ServerLevel targetLevel = server.m_129880_(dimensionKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimensionId));
        if (targetLevel == null) {
            source.m_81352_((Component)Component.m_237113_((String)("Dimension not found: " + dimensionId)));
            return 0;
        }
        if (player == null) {
            return 0;
        }
        if (player.m_9236_() == targetLevel) {
            source.m_81352_((Component)Component.m_237113_((String)"You are already in that dimension."));
            return 0;
        }
        player.m_8999_(targetLevel, player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_146908_(), player.m_146909_());
        source.m_288197_(() -> Component.m_237113_((String)("Teleported to " + dimensionId)), false);
        return 1;
    }

    public static CompletableFuture<Suggestions> getCapeSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        Player entity = null;
        if (((CommandSourceStack)context.getSource()).m_81373_() instanceof Player) {
            entity = (Player)((CommandSourceStack)context.getSource()).m_81373_();
        }
        if (entity != null) {
            String input = builder.getRemaining().toLowerCase();
            List<Cape> availableCapes = Cape.getAvailableCapes(entity);
            for (Cape cape : availableCapes) {
                if (!cape.getId().toLowerCase().contains(input)) continue;
                builder.suggest(cape.getId());
            }
        }
        builder.suggest("default");
        return builder.buildFuture();
    }
}

