/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.events.entity.living;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.lixir.vminus.item.IEquipmentItem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
public class LivingTickEventHandler {
    @SubscribeEvent
    public static void onEntityTick(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        Level level = entity.m_9236_();
        if (entity.m_5833_()) {
            return;
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            Item item;
            ItemStack itemStack;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || (itemStack = entity.m_6844_(slot)).m_41619_() || !((item = itemStack.m_41720_()) instanceof IEquipmentItem)) continue;
            IEquipmentItem IEquipmentItem2 = (IEquipmentItem)item;
            IEquipmentItem2.onEquipmentTick(level, entity, itemStack);
        }
        if (level instanceof ServerLevel) {
            Collection activeEffects;
            List<String> visibleEffects;
            ServerLevel serverlevel = (ServerLevel)level;
            if (level.m_6106_().m_6793_() % 4L == 0L && !entity.m_5833_() && !(visibleEffects = LivingTickEventHandler.getVisibleEffects(activeEffects = entity.m_21220_())).isEmpty()) {
                String currentEffect = LivingTickEventHandler.getRandomEffect(visibleEffects);
                double[] spawnCoordinates = LivingTickEventHandler.getSpawnCoordinates((Entity)entity);
                LivingTickEventHandler.spawnParticleForEffect(currentEffect, serverlevel, spawnCoordinates, (Entity)entity);
            }
        }
    }

    @NotNull
    private static List<String> getVisibleEffects(Collection<MobEffectInstance> activeEffects) {
        ArrayList<String> effects = new ArrayList<String>();
        for (MobEffectInstance effectInstance : activeEffects) {
            if (!effectInstance.m_19572_()) continue;
            ResourceLocation effectId = ForgeRegistries.MOB_EFFECTS.getKey((Object)effectInstance.m_19544_());
            effects.add(effectId.toString());
        }
        return effects;
    }

    private static String getRandomEffect(@NotNull List<String> effects) {
        return effects.get(Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)0, (int)(effects.size() - 1)));
    }

    private static double @NotNull [] getSpawnCoordinates(@NotNull Entity entity) {
        double spawnX = entity.m_20185_() + Mth.m_216263_((RandomSource)RandomSource.m_216327_(), (double)((double)(entity.m_20205_() / 2.0f * -1.0f) - 0.3), (double)((double)(entity.m_20205_() / 2.0f) + 0.3));
        double spawnY = entity.m_20186_() + Mth.m_216263_((RandomSource)RandomSource.m_216327_(), (double)0.0, (double)entity.m_20206_());
        double spawnZ = entity.m_20189_() + Mth.m_216263_((RandomSource)RandomSource.m_216327_(), (double)((double)(entity.m_20205_() / 2.0f * -1.0f) - 0.3), (double)((double)(entity.m_20205_() / 2.0f) + 0.3));
        return new double[]{spawnX, spawnY, spawnZ};
    }

    private static void spawnParticleForEffect(String effect, ServerLevel level, double[] spawnCoords, Entity entity) {
    }
}

