/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.datagen;

import java.util.List;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoundDefinitionInfo {
    private final List<String> paths;
    private SoundEvent soundEvent = null;
    private final String path;
    private final String subtitle;
    private final int count;
    private Weight[] weights = new Weight[0];
    private int defaultWeight = 1;

    private SoundDefinitionInfo(@Nullable String subtitle, @Nullable String path, int count, @Nullable List<String> paths) {
        this.path = path;
        this.subtitle = subtitle;
        this.count = count;
        this.paths = paths;
    }

    @NotNull
    public static SoundDefinitionInfo of(List<String> paths) {
        return SoundDefinitionInfo.of("default", null, 1, paths);
    }

    @NotNull
    public static SoundDefinitionInfo of(@Nullable String subtitle, List<String> paths) {
        return SoundDefinitionInfo.of(subtitle, null, 1, paths);
    }

    @NotNull
    public static SoundDefinitionInfo of(String path) {
        return SoundDefinitionInfo.of("default", path, 1, null);
    }

    @NotNull
    public static SoundDefinitionInfo of(@Nullable String subtitle, String path) {
        return SoundDefinitionInfo.of(subtitle, path, 1, null);
    }

    @NotNull
    public static SoundDefinitionInfo of(@Nullable String subtitle, String path, int count) {
        return SoundDefinitionInfo.of(subtitle, path, count, null);
    }

    @NotNull
    public static SoundDefinitionInfo of(String path, int count) {
        return SoundDefinitionInfo.of("default", path, count, null);
    }

    @NotNull
    public static SoundDefinitionInfo of(@Nullable String subtitle, @Nullable String path, int count, @Nullable List<String> paths) {
        if (count <= 0) {
            throw new IllegalArgumentException("Variant count must be at least 1 for sound event: " + path);
        }
        return new SoundDefinitionInfo(subtitle, path, count, paths);
    }

    public SoundDefinitionInfo defaultWeight(int weight) {
        if (weight < 1) {
            throw new IllegalArgumentException("Weight cannot be below 1");
        }
        this.defaultWeight = weight;
        return this;
    }

    public SoundDefinitionInfo weights(Weight ... weights) {
        for (Weight weight : weights) {
            if (weight.weight >= 1) continue;
            throw new IllegalArgumentException("Weight cannot be below 1");
        }
        this.weights = weights;
        return this;
    }

    public int getDefaultWeight() {
        return this.defaultWeight;
    }

    @Nullable
    public String getSubtitle() {
        return this.subtitle;
    }

    public String getPath() {
        return this.path;
    }

    public int getCount() {
        return this.count;
    }

    public SoundEvent getSoundEvent() {
        return this.soundEvent;
    }

    public SoundDefinitionInfo setSoundEvent(SoundEvent soundEvent) {
        this.soundEvent = soundEvent;
        return this;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public Weight[] getWeights() {
        return this.weights;
    }

    public record Weight(String path, int weight) {
    }
}

