/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.dataanchor.forge.network;

import dev.corgitaco.dataanchor.network.Packet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public abstract class ForgeNetworkHandler {
    private static final String PROTOCOL_VERSION = "1";
    protected final Map<Class<? extends Packet>, SimpleChannel> channels = new ConcurrentHashMap<Class<? extends Packet>, SimpleChannel>();
    protected final Map<Class<? extends Packet>, ResourceLocation> channelNames = new ConcurrentHashMap<Class<? extends Packet>, ResourceLocation>();

    public <T extends Packet> void registerMessage(ResourceLocation location, Packet.Handler<T> handler) {
        SimpleChannel simpleChannel = this.channels.computeIfAbsent(handler.clazz(), aClass -> NetworkRegistry.newSimpleChannel((ResourceLocation)location, () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals));
        this.channelNames.put(handler.clazz(), location);
        simpleChannel.registerMessage(0, handler.clazz(), handler.write(), handler.read(), (t, contextSupplier) -> this.handle((Packet)t, (Supplier<NetworkEvent.Context>)contextSupplier, handler.handle()));
    }

    public <T extends Packet> void handle(T packet, Supplier<NetworkEvent.Context> ctx, Packet.Handle<T> handle) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> Client.clientHandle(packet, handle));
        } else {
            ServerPlayer sender = context.getSender();
            handle.handle(packet, sender != null ? sender.m_9236_() : null, (Player)sender);
        }
        context.setPacketHandled(true);
    }

    private static class Client {
        private Client() {
        }

        private static <T extends Packet> void clientHandle(T packet, Packet.Handle<T> handle) {
            handle.handle(packet, (Level)Minecraft.m_91087_().f_91073_, (Player)Minecraft.m_91087_().f_91074_);
        }
    }
}

