/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;

public class SubBackpacksHandler {
    private final Map<Integer, IStorageWrapper> subBackpacks = new LinkedHashMap<Integer, IStorageWrapper>();
    private final InventoryHandler inventoryHandler;
    private final Set<Consumer<Collection<IStorageWrapper>>> refreshListeners = new HashSet<Consumer<Collection<IStorageWrapper>>>();
    private final Set<Consumer<Collection<IStorageWrapper>>> beforeRefreshListeners = new HashSet<Consumer<Collection<IStorageWrapper>>>();

    public SubBackpacksHandler(InventoryHandler inventoryHandler) {
        this.inventoryHandler = inventoryHandler;
        this.inventoryHandler.addListener(this::onContentsChanged);
        this.refreshSubBackpacks();
    }

    public void addRefreshListener(Consumer<Collection<IStorageWrapper>> listener) {
        this.refreshListeners.add(listener);
    }

    public Collection<IStorageWrapper> getSubBackpacks() {
        return this.subBackpacks.values();
    }

    private void onContentsChanged(int slot) {
        ItemStack stackInSlot = this.inventoryHandler.getStackInSlot(slot);
        boolean backpackIsInTheSlot = stackInSlot.m_41720_() instanceof BackpackItem;
        boolean backpackWasInTheSlot = this.subBackpacks.containsKey(slot);
        if (!backpackWasInTheSlot && !backpackIsInTheSlot) {
            return;
        }
        if (backpackWasInTheSlot != backpackIsInTheSlot) {
            this.notifyAndRefreshSubbackpacks();
        } else {
            LazyOptional backpackWrapper = stackInSlot.getCapability(CapabilityBackpackWrapper.getCapabilityInstance());
            if (backpackWrapper.isPresent() && backpackWrapper.map(w -> w != this.subBackpacks.get(slot)).orElse(false).booleanValue()) {
                this.notifyAndRefreshSubbackpacks();
            }
        }
    }

    private void notifyAndRefreshSubbackpacks() {
        this.notifyBeforeRefresh();
        this.refreshSubBackpacks();
        this.notifyAfterRefresh();
    }

    private void notifyAfterRefresh() {
        this.runRefreshListeners(this.refreshListeners);
    }

    private void runRefreshListeners(Set<Consumer<Collection<IStorageWrapper>>> refreshListeners) {
        for (Consumer<Collection<IStorageWrapper>> refreshListener : refreshListeners) {
            refreshListener.accept(this.subBackpacks.values());
        }
    }

    private void notifyBeforeRefresh() {
        this.runRefreshListeners(this.beforeRefreshListeners);
    }

    private void refreshSubBackpacks() {
        this.subBackpacks.clear();
        for (int slot = 0; slot < this.inventoryHandler.getSlots(); ++slot) {
            int finalSlot = slot;
            this.inventoryHandler.getStackInSlot(slot).getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> this.subBackpacks.put(finalSlot, (IStorageWrapper)wrapper));
        }
    }

    public void addBeforeRefreshListener(Consumer<Collection<IStorageWrapper>> listener) {
        this.beforeRefreshListeners.add(listener);
    }
}

