/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.blocks;

import earth.terrarium.handcrafted.common.blocks.DiningBenchBlock;
import earth.terrarium.handcrafted.common.blocks.base.properties.ColorProperty;
import earth.terrarium.handcrafted.common.blocks.base.properties.DirectionalBlockProperty;
import earth.terrarium.handcrafted.common.constants.ConstantComponents;
import earth.terrarium.handcrafted.common.utils.InteractionUtils;
import earth.terrarium.handcrafted.common.utils.TooltipUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FancyBedBlock
extends BedBlock {
    public static final EnumProperty<BedPart> PART = BlockStateProperties.f_61391_;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.f_61445_;
    public static final EnumProperty<DirectionalBlockProperty> SHAPE = EnumProperty.m_61587_((String)"shape", DirectionalBlockProperty.class);
    public static final EnumProperty<ColorProperty> COLOR = EnumProperty.m_61587_((String)"color", ColorProperty.class);
    public static final VoxelShape VOXEL_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);

    public FancyBedBlock(BlockBehaviour.Properties properties) {
        super(DyeColor.WHITE, properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_(PART, (Comparable)BedPart.FOOT)).m_61124_((Property)OCCUPIED, (Comparable)Boolean.valueOf(false))).m_61124_(SHAPE, (Comparable)((Object)DirectionalBlockProperty.SINGLE))).m_61124_(COLOR, (Comparable)((Object)ColorProperty.WHITE)));
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (!level.m_5776_() && state.m_60734_() != newState.m_60734_() && state.m_61143_(COLOR) != ColorProperty.WHITE) {
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)(state.m_61143_(PART) == BedPart.FOOT ? ((ColorProperty)((Object)state.m_61143_(COLOR))).toSheet() : ((ColorProperty)((Object)state.m_61143_(COLOR))).toCushion()));
        }
        super.m_6810_(state, level, pos, newState, moved);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, PART, OCCUPIED, SHAPE, COLOR});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return null;
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return VOXEL_SHAPE;
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (direction == this.getNeighbourDirection((BedPart)state.m_61143_(PART), (Direction)state.m_61143_((Property)f_54117_))) {
            return neighborState.m_60713_((Block)this) && neighborState.m_61143_(PART) != state.m_61143_(PART) ? (BlockState)((BlockState)state.m_61124_((Property)OCCUPIED, (Comparable)((Boolean)neighborState.m_61143_((Property)OCCUPIED)))).m_61124_(SHAPE, (Comparable)((Object)FancyBedBlock.getShape((Block)this, (Direction)state.m_61143_((Property)f_54117_), (BlockGetter)level, pos))) : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_((BlockState)state.m_61124_(SHAPE, (Comparable)((Object)FancyBedBlock.getShape((Block)this, (Direction)state.m_61143_((Property)f_54117_), (BlockGetter)level, pos))), direction, neighborState, level, pos, neighborPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_();
        BlockPos pos = context.m_8083_();
        BlockPos relativePos = pos.m_121945_(direction);
        Level level = context.m_43725_();
        return level.m_8055_(relativePos).m_60629_(context) && level.m_6857_().m_61937_(relativePos) ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction)).m_61124_(SHAPE, (Comparable)((Object)FancyBedBlock.getShape((Block)this, direction, (BlockGetter)level, pos))) : null;
    }

    private Direction getNeighbourDirection(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.m_122424_();
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult result = state.m_61143_(PART) == BedPart.HEAD ? InteractionUtils.interactCushion(state, level, pos, player, hand, COLOR) : InteractionUtils.interactSheet(state, level, pos, player, hand, COLOR);
        if (result != InteractionResult.PASS) {
            return result;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public static DirectionalBlockProperty getShape(Block block, Direction direction, BlockGetter level, BlockPos pos) {
        boolean check2;
        BlockState state1 = level.m_8055_(pos.m_121945_(direction.m_122427_()));
        BlockState state2 = level.m_8055_(pos.m_121945_(direction.m_122427_().m_122424_()));
        boolean check1 = state1.m_60713_(block) && state1.m_61143_((Property)DiningBenchBlock.f_54117_) != direction;
        boolean bl = check2 = state2.m_60713_(block) && state2.m_61143_((Property)DiningBenchBlock.f_54117_) != direction;
        if (!state1.m_60713_(block) && !state2.m_60713_(block)) {
            return DirectionalBlockProperty.SINGLE;
        }
        if (check1 && state2.m_60713_(block)) {
            return DirectionalBlockProperty.RIGHT;
        }
        if (check2 && state1.m_60713_(block)) {
            return DirectionalBlockProperty.LEFT;
        }
        if (check1) {
            return DirectionalBlockProperty.SINGLE;
        }
        if (check2) {
            return DirectionalBlockProperty.SINGLE;
        }
        if (!state1.m_60713_(block)) {
            return DirectionalBlockProperty.RIGHT;
        }
        if (!state2.m_60713_(block)) {
            return DirectionalBlockProperty.LEFT;
        }
        return DirectionalBlockProperty.MIDDLE;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        TooltipUtils.addDescriptionComponent(tooltip, ConstantComponents.BED_PILLOW, ConstantComponents.BED_SHEET);
    }
}

