/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.packets;

import com.jesz.createdieselgenerators.content.entity_filter.EntityAttribute;
import com.jesz.createdieselgenerators.content.entity_filter.EntityFilterMenu;
import com.simibubi.create.content.logistics.filter.AttributeFilterMenu;
import com.simibubi.create.content.logistics.filter.FilterScreenPacket;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class EntityFilterScreenPacket
extends SimplePacketBase {
    private final FilterScreenPacket.Option option;
    private final CompoundTag data;

    public EntityFilterScreenPacket(FilterScreenPacket.Option option) {
        this(option, new CompoundTag());
    }

    public EntityFilterScreenPacket(FilterScreenPacket.Option option, CompoundTag data) {
        this.option = option;
        this.data = data;
    }

    public EntityFilterScreenPacket(FriendlyByteBuf buffer) {
        this.option = FilterScreenPacket.Option.values()[buffer.readInt()];
        this.data = buffer.m_130260_();
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.option.ordinal());
        buffer.m_130079_(this.data);
    }

    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            AbstractContainerMenu patt1641$temp = player.f_36096_;
            if (patt1641$temp instanceof EntityFilterMenu) {
                EntityFilterMenu c = (EntityFilterMenu)patt1641$temp;
                if (this.option == FilterScreenPacket.Option.WHITELIST) {
                    c.whitelist = AttributeFilterMenu.WhitelistMode.WHITELIST_DISJ;
                }
                if (this.option == FilterScreenPacket.Option.WHITELIST2) {
                    c.whitelist = AttributeFilterMenu.WhitelistMode.WHITELIST_CONJ;
                }
                if (this.option == FilterScreenPacket.Option.BLACKLIST) {
                    c.whitelist = AttributeFilterMenu.WhitelistMode.BLACKLIST;
                }
                if (this.option == FilterScreenPacket.Option.ADD_TAG) {
                    c.appendSelectedAttribute(EntityAttribute.fromNBT(this.data), false);
                }
                if (this.option == FilterScreenPacket.Option.ADD_INVERTED_TAG) {
                    c.appendSelectedAttribute(EntityAttribute.fromNBT(this.data), true);
                }
            }
        });
        return true;
    }
}

