/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.message;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexthe666.citadel.server.message.PacketBufferUtils;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class UpdateCaveBiomeMapTagMessage {
    private UUID userUUID;
    private UUID caveBiomeMapUUID;
    private CompoundTag tag;

    public UpdateCaveBiomeMapTagMessage(UUID userUUID, UUID caveBiomeMapUUID, CompoundTag tag) {
        this.userUUID = userUUID;
        this.caveBiomeMapUUID = caveBiomeMapUUID;
        this.tag = tag;
    }

    public static UpdateCaveBiomeMapTagMessage read(FriendlyByteBuf buf) {
        return new UpdateCaveBiomeMapTagMessage(buf.m_130259_(), buf.m_130259_(), PacketBufferUtils.readTag((ByteBuf)buf));
    }

    public static void write(UpdateCaveBiomeMapTagMessage message, FriendlyByteBuf buf) {
        buf.m_130077_(message.userUUID);
        buf.m_130077_(message.caveBiomeMapUUID);
        PacketBufferUtils.writeTag((ByteBuf)buf, (CompoundTag)message.tag);
    }

    public static void handle(UpdateCaveBiomeMapTagMessage message, Supplier<NetworkEvent.Context> context) {
        Player player;
        context.get().setPacketHandled(true);
        ServerPlayer playerSided = context.get().getSender();
        if (context.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            playerSided = AlexsCaves.PROXY.getClientSidePlayer();
        }
        if (playerSided != null && (player = playerSided.m_9236_().m_46003_(message.userUUID)) != null) {
            ItemStack set = null;
            for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                CompoundTag tag;
                ItemStack itemStack = (ItemStack)player.m_150109_().f_35974_.get(i);
                if (!itemStack.m_150930_((Item)ACItemRegistry.CAVE_MAP.get()) || itemStack.m_41783_() == null || !(tag = itemStack.m_41784_()).m_128441_("MapUUID") || !message.caveBiomeMapUUID.equals(tag.m_128342_("MapUUID"))) continue;
                set = itemStack;
                break;
            }
            if (set != null) {
                set.m_41751_(message.tag);
            }
        }
    }
}

