/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.structure.processor;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.processor.ACStructureProcessorRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class LollipopProcessor
extends StructureProcessor {
    private static Block[][] BLOCK_COLOR_PALETTES = new Block[][]{{(Block)ACBlockRegistry.LIGHT_BLUE_ROCK_CANDY.get(), (Block)ACBlockRegistry.GREEN_ROCK_CANDY.get(), (Block)ACBlockRegistry.ORANGE_ROCK_CANDY.get(), (Block)ACBlockRegistry.RED_ROCK_CANDY.get()}, {(Block)ACBlockRegistry.YELLOW_ROCK_CANDY.get(), (Block)ACBlockRegistry.PINK_ROCK_CANDY.get(), (Block)ACBlockRegistry.BLUE_ROCK_CANDY.get(), (Block)ACBlockRegistry.RED_ROCK_CANDY.get()}, {(Block)ACBlockRegistry.WHITE_ROCK_CANDY.get(), (Block)ACBlockRegistry.CYAN_ROCK_CANDY.get(), (Block)ACBlockRegistry.GREEN_ROCK_CANDY.get(), (Block)ACBlockRegistry.YELLOW_ROCK_CANDY.get()}, {(Block)ACBlockRegistry.WHITE_ROCK_CANDY.get(), (Block)ACBlockRegistry.CYAN_ROCK_CANDY.get(), (Block)ACBlockRegistry.GREEN_ROCK_CANDY.get(), (Block)ACBlockRegistry.YELLOW_ROCK_CANDY.get()}, {(Block)ACBlockRegistry.PINK_ROCK_CANDY.get(), (Block)ACBlockRegistry.MAGENTA_ROCK_CANDY.get(), (Block)ACBlockRegistry.LIGHT_BLUE_ROCK_CANDY.get(), (Block)ACBlockRegistry.BLUE_ROCK_CANDY.get()}, {(Block)ACBlockRegistry.RED_ROCK_CANDY.get(), (Block)ACBlockRegistry.PINK_ROCK_CANDY.get(), (Block)ACBlockRegistry.MAGENTA_ROCK_CANDY.get(), (Block)ACBlockRegistry.PURPLE_ROCK_CANDY.get()}, {(Block)ACBlockRegistry.WHITE_ROCK_CANDY.get(), (Block)ACBlockRegistry.PINK_ROCK_CANDY.get(), (Block)ACBlockRegistry.MAGENTA_ROCK_CANDY.get(), (Block)ACBlockRegistry.PURPLE_ROCK_CANDY.get()}, {(Block)ACBlockRegistry.WHITE_ROCK_CANDY.get(), (Block)ACBlockRegistry.PINK_ROCK_CANDY.get(), (Block)ACBlockRegistry.MAGENTA_ROCK_CANDY.get(), (Block)ACBlockRegistry.PURPLE_ROCK_CANDY.get()}, {(Block)ACBlockRegistry.WHITE_ROCK_CANDY.get(), (Block)ACBlockRegistry.YELLOW_ROCK_CANDY.get(), (Block)ACBlockRegistry.ORANGE_ROCK_CANDY.get(), (Block)ACBlockRegistry.RED_ROCK_CANDY.get()}, {(Block)ACBlockRegistry.WHITE_ROCK_CANDY.get(), (Block)ACBlockRegistry.CYAN_ROCK_CANDY.get(), (Block)ACBlockRegistry.LIGHT_BLUE_ROCK_CANDY.get(), (Block)ACBlockRegistry.BLUE_ROCK_CANDY.get()}, {(Block)ACBlockRegistry.WHITE_ROCK_CANDY.get(), (Block)ACBlockRegistry.CYAN_ROCK_CANDY.get(), (Block)ACBlockRegistry.LIME_ROCK_CANDY.get(), (Block)ACBlockRegistry.GREEN_ROCK_CANDY.get()}, {(Block)ACBlockRegistry.YELLOW_ROCK_CANDY.get(), (Block)ACBlockRegistry.CYAN_ROCK_CANDY.get(), (Block)ACBlockRegistry.PINK_ROCK_CANDY.get(), (Block)ACBlockRegistry.PURPLE_ROCK_CANDY.get()}, {(Block)ACBlockRegistry.PINK_ROCK_CANDY.get(), (Block)ACBlockRegistry.BLUE_ROCK_CANDY.get(), (Block)ACBlockRegistry.PURPLE_ROCK_CANDY.get(), (Block)ACBlockRegistry.BLACK_ROCK_CANDY.get()}};
    public static final Codec<LollipopProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("palette_index").forGetter(p_230289_ -> p_230289_.paletteIndex)).apply((Applicative)instance, LollipopProcessor::new));
    private final int paletteIndex;

    public LollipopProcessor(int paletteIndex) {
        this.paletteIndex = paletteIndex;
    }

    public LollipopProcessor(RandomSource randomSource) {
        this(randomSource.m_188503_(BLOCK_COLOR_PALETTES.length - 1));
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos blockPosUnused, BlockPos pos, StructureTemplate.StructureBlockInfo relativeInfo, StructureTemplate.StructureBlockInfo info, StructurePlaceSettings settings) {
        BlockState in = info.f_74676_();
        int clampedPaletteIndex = Mth.m_14045_((int)this.paletteIndex, (int)0, (int)BLOCK_COLOR_PALETTES.length);
        if (in.m_60713_((Block)ACBlockRegistry.BLACK_ROCK_CANDY.get())) {
            return new StructureTemplate.StructureBlockInfo(info.f_74675_(), BLOCK_COLOR_PALETTES[clampedPaletteIndex][0].m_49966_(), info.f_74677_());
        }
        if (in.m_60713_((Block)ACBlockRegistry.GRAY_ROCK_CANDY.get())) {
            return new StructureTemplate.StructureBlockInfo(info.f_74675_(), BLOCK_COLOR_PALETTES[clampedPaletteIndex][1].m_49966_(), info.f_74677_());
        }
        if (in.m_60713_((Block)ACBlockRegistry.LIGHT_GRAY_ROCK_CANDY.get())) {
            return new StructureTemplate.StructureBlockInfo(info.f_74675_(), BLOCK_COLOR_PALETTES[clampedPaletteIndex][2].m_49966_(), info.f_74677_());
        }
        if (in.m_60713_((Block)ACBlockRegistry.WHITE_ROCK_CANDY.get())) {
            return new StructureTemplate.StructureBlockInfo(info.f_74675_(), BLOCK_COLOR_PALETTES[clampedPaletteIndex][3].m_49966_(), info.f_74677_());
        }
        return info;
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)ACStructureProcessorRegistry.LOLLIPOP.get();
    }
}

