/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.structure.piece;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.ACStructurePieceRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.VoronoiGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public class DonutArchStructurePiece
extends StructurePiece {
    protected final BlockPos centerPos;
    protected final BlockPos chunkCorner;
    protected final Direction direction;
    private double width;
    private int frostingType;
    private static Block[] SPRINKLES_BLOCKS = new Block[]{(Block)ACBlockRegistry.RED_ROCK_CANDY.get(), (Block)ACBlockRegistry.PURPLE_ROCK_CANDY.get(), (Block)ACBlockRegistry.YELLOW_ROCK_CANDY.get(), (Block)ACBlockRegistry.LIGHT_BLUE_ROCK_CANDY.get(), (Block)ACBlockRegistry.ORANGE_ROCK_CANDY.get(), (Block)ACBlockRegistry.LIME_ROCK_CANDY.get(), (Block)ACBlockRegistry.GREEN_ROCK_CANDY.get(), (Block)ACBlockRegistry.BLUE_ROCK_CANDY.get(), (Block)ACBlockRegistry.MAGENTA_ROCK_CANDY.get(), (Block)ACBlockRegistry.PINK_ROCK_CANDY.get()};
    private VoronoiGenerator voronoiGenerator;

    public DonutArchStructurePiece(BlockPos centerPos, BlockPos chunkCorner, Direction direction, double width, int frostingType) {
        super((StructurePieceType)ACStructurePieceRegistry.DONUT_ARCH.get(), 0, DonutArchStructurePiece.createBoundingBox(chunkCorner, direction));
        this.centerPos = centerPos;
        this.chunkCorner = chunkCorner;
        this.direction = direction;
        this.width = width;
        this.frostingType = frostingType;
    }

    public DonutArchStructurePiece(CompoundTag tag) {
        super((StructurePieceType)ACStructurePieceRegistry.DONUT_ARCH.get(), tag);
        this.centerPos = new BlockPos(tag.m_128451_("CX"), tag.m_128451_("CY"), tag.m_128451_("CZ"));
        this.chunkCorner = new BlockPos(tag.m_128451_("TPX"), tag.m_128451_("TPY"), tag.m_128451_("TPZ"));
        this.direction = Direction.m_122407_((int)tag.m_128451_("Direction"));
        this.width = tag.m_128459_("Width");
        this.frostingType = tag.m_128451_("FrostingType");
    }

    public DonutArchStructurePiece(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag tag) {
        this(tag);
    }

    private static BoundingBox createBoundingBox(BlockPos origin, Direction direction) {
        ChunkPos chunkPos = new ChunkPos(origin);
        return new BoundingBox(chunkPos.m_45604_(), origin.m_123342_() - 2, chunkPos.m_45605_(), chunkPos.m_45608_(), origin.m_123342_() + 16, chunkPos.m_45609_());
    }

    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
        tag.m_128405_("CX", this.centerPos.m_123341_());
        tag.m_128405_("CY", this.centerPos.m_123342_());
        tag.m_128405_("CZ", this.centerPos.m_123343_());
        tag.m_128405_("TPX", this.chunkCorner.m_123341_());
        tag.m_128405_("TPY", this.chunkCorner.m_123342_());
        tag.m_128405_("TPZ", this.chunkCorner.m_123343_());
        tag.m_128405_("Direction", this.direction.m_122416_());
        tag.m_128347_("Width", this.width);
        tag.m_128405_("FrostingType", this.frostingType);
    }

    public void m_213694_(WorldGenLevel level, StructureManager featureManager, ChunkGenerator chunkGen, RandomSource random, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
        if (this.voronoiGenerator == null) {
            this.voronoiGenerator = new VoronoiGenerator(level.m_7328_());
            this.voronoiGenerator.setOffsetAmount(1.0);
            this.voronoiGenerator.setDistanceType(VoronoiGenerator.DistanceType.euclidean);
        }
        BlockState frosting = ((Block)ACBlockRegistry.BLOCK_OF_FROSTING.get()).m_49966_();
        if (this.frostingType == 1) {
            frosting = ((Block)ACBlockRegistry.BLOCK_OF_VANILLA_FROSTING.get()).m_49966_();
        } else if (this.frostingType == 2) {
            frosting = ((Block)ACBlockRegistry.BLOCK_OF_CHOCOLATE_FROSTING.get()).m_49966_();
        }
        int cornerX = this.chunkCorner.m_123341_();
        int cornerY = this.chunkCorner.m_123342_();
        int cornerZ = this.chunkCorner.m_123343_();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockPos centeredCenter = this.centerPos.m_7918_(8, 0, 8);
        double outerWidth = Math.pow(this.width, 2.0);
        double innerWidth = Math.pow(this.width * 0.6, 2.0);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 15; y >= 0; --y) {
                    pos.m_122178_(cornerX + x, Mth.m_14045_((int)(cornerY + y), (int)level.m_141937_(), (int)level.m_151558_()), cornerZ + z);
                    double forwardsNoise1 = ((double)ACMath.sampleNoise2D(this.direction.m_122434_() == Direction.Axis.X ? pos.m_123343_() : pos.m_123341_(), pos.m_123342_(), 20.0f) + 1.0) * 0.5;
                    double length = 15.0 - 4.0 * forwardsNoise1;
                    double frostingNoise = ((double)ACMath.sampleNoise2D(this.direction.m_122434_() == Direction.Axis.X ? pos.m_123343_() : pos.m_123341_(), pos.m_123342_(), 10.0f) + 1.0) * 0.5;
                    double distSides = pos.m_203198_(this.direction.m_122434_() == Direction.Axis.X ? (double)centeredCenter.m_123341_() : (double)pos.m_123341_(), (double)centeredCenter.m_123342_(), this.direction.m_122434_() == Direction.Axis.Z ? (double)centeredCenter.m_123343_() : (double)pos.m_123343_());
                    double distForwards = this.direction.m_122434_() == Direction.Axis.X ? (double)(centeredCenter.m_123343_() - pos.m_123343_()) : (double)(centeredCenter.m_123341_() - pos.m_123341_());
                    double distForwardsAbs = Math.abs(distForwards);
                    if (!(distForwardsAbs < length)) continue;
                    boolean frosted = (double)this.calculateFrostingDepth(this.direction, (Vec3i)centeredCenter, (Vec3i)pos) >= 2.0 + frostingNoise * 4.0;
                    double widthShrink = frosted ? 0.0 : 25.0;
                    double distForwardsClamped = distForwardsAbs / length;
                    float distForwardsSmin = ACMath.smin((float)(distForwardsClamped * distForwardsClamped), 1.0f, 0.3f);
                    float outerForwardsSmooth = 1.0f - distForwardsSmin;
                    float innerForwardsSmooth = distForwardsSmin + 0.5f;
                    if (!(distSides < (outerWidth - widthShrink) * (double)outerForwardsSmooth) || !(distSides > (innerWidth + widthShrink) * (double)innerForwardsSmooth) || level.m_8055_((BlockPos)pos).m_60713_(Blocks.f_50752_)) continue;
                    if (frosted) {
                        if (this.placeSprinklesAt(level, pos)) continue;
                        this.checkedSetBlock(level, (BlockPos)pos, frosting);
                        continue;
                    }
                    this.checkedSetBlock(level, (BlockPos)pos, ((Block)ACBlockRegistry.DOUGH_BLOCK.get()).m_49966_());
                }
            }
        }
    }

    private boolean placeSprinklesAt(WorldGenLevel level, BlockPos.MutableBlockPos pos) {
        float sprinkleNoise;
        float voronoiSampleSize = 0.3f;
        VoronoiGenerator.VoronoiInfo info = this.voronoiGenerator.get3((float)pos.m_123341_() * voronoiSampleSize, (float)pos.m_123342_() * voronoiSampleSize, (float)pos.m_123343_() * voronoiSampleSize);
        if (info.distance() < 0.5 && (double)Math.abs(sprinkleNoise = Math.abs(ACMath.sampleNoise3D(pos.m_123341_() + 3334, pos.m_123342_() - 200, pos.m_123343_() + 22223, 1.0f))) < 0.1) {
            int index = (int)Mth.m_14008_((double)((info.hash() + 1.0) * 0.5 * (double)SPRINKLES_BLOCKS.length), (double)0.0, (double)(SPRINKLES_BLOCKS.length - 1));
            BlockState block = SPRINKLES_BLOCKS[index].m_49966_();
            this.checkedSetBlock(level, (BlockPos)pos, block);
            return true;
        }
        return false;
    }

    private float calculateFrostingDepth(Direction direction, Vec3i centeredCenter, Vec3i pos) {
        switch (direction) {
            case NORTH: {
                return centeredCenter.m_123341_() - pos.m_123341_();
            }
            case EAST: {
                return pos.m_123343_() - centeredCenter.m_123343_();
            }
            case SOUTH: {
                return pos.m_123341_() - centeredCenter.m_123341_();
            }
            case WEST: {
                return centeredCenter.m_123343_() - pos.m_123343_();
            }
        }
        return 0.0f;
    }

    public void checkedSetBlock(WorldGenLevel level, BlockPos position, BlockState state) {
        if (this.m_73547_().m_71051_((Vec3i)position)) {
            level.m_7731_(position, state, 128);
        }
    }

    public BlockState checkedGetBlock(WorldGenLevel level, BlockPos position) {
        if (this.m_73547_().m_71051_((Vec3i)position)) {
            return level.m_8055_(position);
        }
        return Blocks.f_50626_.m_49966_();
    }
}

