/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.feature;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.IceCreamBlock;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class CeilingIceCreamConeFeature
extends Feature<NoneFeatureConfiguration> {
    public CeilingIceCreamConeFeature(Codec<NoneFeatureConfiguration> config) {
        super(config);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel worldgenlevel = context.m_159774_();
        RandomSource randomsource = context.m_225041_();
        int iceCreamType = randomsource.m_188503_(3);
        Block iceCreamBlock = iceCreamType == 1 ? (Block)ACBlockRegistry.CHOCOLATE_ICE_CREAM.get() : (iceCreamType == 2 ? (Block)ACBlockRegistry.SWEETBERRY_ICE_CREAM.get() : (Block)ACBlockRegistry.VANILLA_ICE_CREAM.get());
        BlockPos blockpos = context.m_159777_();
        while (blockpos.m_123342_() >= worldgenlevel.m_151558_() - 3 && worldgenlevel.m_46859_(blockpos.m_7494_())) {
            blockpos = blockpos.m_7494_();
        }
        if (blockpos.m_123342_() >= worldgenlevel.m_151558_() - 3) {
            return false;
        }
        BlockState stateAbove = worldgenlevel.m_8055_(blockpos.m_7494_());
        if (!stateAbove.m_60713_((Block)ACBlockRegistry.CAKE_LAYER.get()) && !stateAbove.m_60713_((Block)ACBlockRegistry.BLOCK_OF_CHOCOLATE.get())) {
            return false;
        }
        int coneWidthRadius = 3 + randomsource.m_188503_(3);
        int coneLength = coneWidthRadius + 8 + randomsource.m_188503_(8);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int y = 5; y > -coneLength; --y) {
            int shrinkIncrement;
            boolean stairFlag = false;
            int n = shrinkIncrement = coneWidthRadius <= 1 ? 2 : coneLength / 3;
            if (((y - 1) % shrinkIncrement == 0 || coneLength - y < 2) && y < 0 || y == -1) {
                stairFlag = true;
            }
            if (y == -1) {
                --coneWidthRadius;
            }
            for (int x = -coneWidthRadius; x <= coneWidthRadius; ++x) {
                for (int z = -coneWidthRadius; z <= coneWidthRadius; ++z) {
                    pos.m_122178_(blockpos.m_123341_() + x, blockpos.m_123342_() + y, blockpos.m_123343_() + z);
                    double distXZ = pos.m_203202_((double)blockpos.m_123341_(), y > 1 ? (double)blockpos.m_123342_() : (double)pos.m_123342_(), (double)blockpos.m_123343_());
                    double circleFat = coneWidthRadius * coneWidthRadius;
                    if (!(distXZ < circleFat) || !CeilingIceCreamConeFeature.canReplace(worldgenlevel.m_8055_((BlockPos)pos))) continue;
                    boolean placeFlag = false;
                    if (y >= 0) {
                        if (y != 5 || randomsource.m_188499_()) {
                            worldgenlevel.m_7731_((BlockPos)pos, (BlockState)iceCreamBlock.m_49966_().m_61124_((Property)IceCreamBlock.TYPE, (Comparable)Integer.valueOf(2)), 3);
                        }
                        placeFlag = true;
                    } else if (Math.sqrt(distXZ) >= (double)coneWidthRadius - 1.0) {
                        placeFlag = true;
                        if (stairFlag && coneWidthRadius > 1) {
                            StairsShape shape = StairsShape.STRAIGHT;
                            float angle = 180.0f - (float)(Mth.m_14136_((double)(pos.m_123341_() - blockpos.m_123341_()), (double)(pos.m_123343_() - blockpos.m_123343_())) * 57.2957763671875);
                            Direction facing = Direction.m_122364_((double)angle);
                            if (Mth.m_14145_((float)(angle % 90.0f), (float)45.0f) < 10.0f) {
                                shape = StairsShape.OUTER_LEFT;
                            }
                            worldgenlevel.m_7731_((BlockPos)pos, (BlockState)((BlockState)((BlockState)((Block)ACBlockRegistry.WAFER_COOKIE_STAIRS.get()).m_49966_().m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.TOP)).m_61124_((Property)StairBlock.f_56843_, (Comparable)shape)).m_61124_((Property)StairBlock.f_56841_, (Comparable)facing), 3);
                        } else {
                            worldgenlevel.m_7731_((BlockPos)pos, ((Block)ACBlockRegistry.WAFER_COOKIE_BLOCK.get()).m_49966_(), 3);
                        }
                    }
                    BlockPos above = pos.m_7494_();
                    if (!placeFlag || !worldgenlevel.m_8055_(above).m_60713_(iceCreamBlock)) continue;
                    worldgenlevel.m_7731_(above, (BlockState)iceCreamBlock.m_49966_().m_61124_((Property)IceCreamBlock.TYPE, (Comparable)Integer.valueOf(y >= 0 ? 0 : 1)), 3);
                }
            }
            if (!stairFlag) continue;
            --coneWidthRadius;
        }
        return true;
    }

    private static boolean canReplace(BlockState state) {
        return state.m_60795_() || state.m_247087_();
    }
}

