/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.item;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.item.CustomArmorPostRender;
import com.github.alexmodguy.alexscaves.server.item.KeybindUsingArmor;
import com.github.alexmodguy.alexscaves.server.item.UpdatesStackTags;
import com.github.alexmodguy.alexscaves.server.message.ArmorKeyMessage;
import com.github.alexmodguy.alexscaves.server.message.UpdateItemTagMessage;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import com.github.alexmodguy.alexscaves.server.potion.DarknessIncarnateEffect;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class DarknessArmorItem
extends ArmorItem
implements CustomArmorPostRender,
KeybindUsingArmor,
UpdatesStackTags {
    public DarknessArmorItem(ArmorMaterial armorMaterial, ArmorItem.Type slot) {
        super(armorMaterial, slot, new Item.Properties().m_41497_(ACItemRegistry.RARITY_DEMONIC));
    }

    private static boolean canChargeUp(LivingEntity entity, boolean creative) {
        Player player;
        return (!DarknessIncarnateEffect.isInLight(entity, 11) || creative && entity instanceof Player && (player = (Player)entity).m_7500_()) && entity.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ACItemRegistry.HOOD_OF_DARKNESS.get()) && !entity.m_21023_((MobEffect)ACEffectRegistry.DARKNESS_INCARNATE.get());
    }

    public static boolean canChargeUp(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41783_();
        return tag == null || tag.m_128471_("CanCharge");
    }

    public static boolean hasMeter(Player player) {
        return player.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)ACItemRegistry.CLOAK_OF_DARKNESS.get()) && player.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ACItemRegistry.HOOD_OF_DARKNESS.get()) && !player.m_21023_((MobEffect)ACEffectRegistry.DARKNESS_INCARNATE.get());
    }

    public static float getMeterProgress(ItemStack cloak) {
        CompoundTag tag = cloak.m_41783_();
        if (tag == null) {
            return 0.0f;
        }
        return (float)tag.m_128451_("CloakCharge") / (float)((Integer)AlexsCaves.COMMON_CONFIG.darknessCloakChargeTime.get()).intValue();
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)AlexsCaves.PROXY.getArmorProperties());
    }

    public SoundEvent m_150681_() {
        return SoundEvents.f_271165_;
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        if (stack.m_150930_((Item)ACItemRegistry.CLOAK_OF_DARKNESS.get()) && !level.f_46443_) {
            CompoundTag tag = stack.m_41784_();
            int charge = tag.m_128451_("CloakCharge");
            boolean flag = false;
            if (charge < (Integer)AlexsCaves.COMMON_CONFIG.darknessCloakChargeTime.get() && DarknessArmorItem.canChargeUp(stack)) {
                tag.m_128405_("CloakCharge", ++charge);
                flag = true;
            }
            if (flag) {
                AlexsCaves.sendNonLocal(new UpdateItemTagMessage(player.m_19879_(), stack), (ServerPlayer)player);
            }
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int i, boolean held) {
        LivingEntity living;
        super.m_6883_(stack, level, entity, i, held);
        if (stack.m_150930_((Item)ACItemRegistry.CLOAK_OF_DARKNESS.get()) && entity instanceof LivingEntity && (living = (LivingEntity)entity).m_6844_(EquipmentSlot.CHEST) == stack) {
            CompoundTag tag = stack.m_41784_();
            if (!level.f_46443_) {
                long lastLightTimestamp = tag.m_128454_("LastLightTimestamp");
                long lastEquipMessageTime = tag.m_128454_("LastEquipMessageTime");
                if (lastLightTimestamp <= 0L || level.m_46467_() - lastLightTimestamp > 10L) {
                    tag.m_128356_("LastLightTimestamp", level.m_46467_());
                    tag.m_128379_("CanCharge", DarknessArmorItem.canChargeUp(living, true));
                }
                if (lastEquipMessageTime <= 0L && entity instanceof Player) {
                    Player player = (Player)entity;
                    if (!level.f_46443_) {
                        tag.m_128356_("LastEquipMessageTime", level.m_46467_());
                        player.m_5661_((Component)Component.m_237115_((String)"item.alexscaves.cloak_of_darkness.equip"), true);
                    }
                }
            } else if (AlexsCaves.PROXY.getClientSidePlayer() == entity && DarknessArmorItem.getMeterProgress(stack) >= 1.0f && AlexsCaves.PROXY.isKeyDown(2)) {
                AlexsCaves.sendMSGToServer(new ArmorKeyMessage(EquipmentSlot.CHEST.ordinal(), living.m_19879_(), 2));
                this.onKeyPacket((Entity)living, stack, 2);
            }
        }
    }

    @Override
    public void onKeyPacket(Entity wearer, ItemStack itemStack, int key) {
        LivingEntity living;
        if (wearer instanceof LivingEntity && DarknessArmorItem.canChargeUp(living = (LivingEntity)wearer, false)) {
            itemStack.m_41784_().m_128405_("CloakCharge", 0);
            living.m_7292_(new MobEffectInstance((MobEffect)ACEffectRegistry.DARKNESS_INCARNATE.get(), ((Integer)AlexsCaves.COMMON_CONFIG.darknessCloakFlightTime.get()).intValue(), 0, false, false, false));
        } else if (wearer instanceof Player) {
            Player player = (Player)wearer;
            if (!wearer.m_9236_().f_46443_) {
                player.m_5661_((Component)Component.m_237115_((String)"item.alexscaves.cloak_of_darkness.requires_darkness"), true);
            }
        }
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "alexscaves:textures/armor/darkness_armor.png";
    }
}

