/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.item;

import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class BurrowingArrowEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Integer> DUG_BLOCK_COUNT = SynchedEntityData.m_135353_(BurrowingArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DIGGING = SynchedEntityData.m_135353_(BurrowingArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float prevDiggingProgress;
    private float diggingProgress;
    private int miningTime = 0;
    private int lastMineBlockBreakProgress = -1;
    private int soundTime = 0;
    private BlockPos hitPos;

    public BurrowingArrowEntity(EntityType entityType, Level level) {
        super(entityType, level);
        this.m_36781_(3.5);
        this.m_36767_((byte)(this.m_36796_() + 1));
    }

    public BurrowingArrowEntity(Level level, LivingEntity shooter) {
        super((EntityType)ACEntityRegistry.BURROWING_ARROW.get(), shooter, level);
        this.m_36781_(3.5);
        this.m_36767_((byte)(this.m_36796_() + 1));
    }

    public BurrowingArrowEntity(Level level, double x, double y, double z) {
        super((EntityType)ACEntityRegistry.BURROWING_ARROW.get(), x, y, z, level);
        this.m_36781_(3.5);
    }

    public BurrowingArrowEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType)ACEntityRegistry.BURROWING_ARROW.get(), level);
        this.m_20011_(this.m_142242_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DUG_BLOCK_COUNT, (Object)0);
        this.f_19804_.m_135372_(DIGGING, (Object)false);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevDiggingProgress = this.diggingProgress;
        if (this.isDigging() && this.diggingProgress < 5.0f) {
            this.diggingProgress += 1.0f;
        }
        if (!this.isDigging() && this.diggingProgress > 0.0f) {
            this.diggingProgress -= 1.0f;
        }
        if (this.f_36703_ && this.hitPos != null && this.canMine(this.hitPos)) {
            this.setDigging(true);
            BlockState state = this.m_9236_().m_8055_(this.hitPos);
            int hardness = (int)(Math.max(state.m_60800_((BlockGetter)this.m_9236_(), this.hitPos), 0.2f) * 15.0f);
            int i = (int)((float)this.miningTime / (float)hardness * 10.0f);
            if (i != this.lastMineBlockBreakProgress) {
                this.m_9236_().m_6801_(this.m_19879_(), this.hitPos, i);
                this.lastMineBlockBreakProgress = i;
            }
            if (this.miningTime % 8 == 0) {
                this.m_216990_(state.m_60827_().m_56778_());
            }
            Vec3 centerOf = this.hitPos.m_252807_().m_82546_(this.m_20182_());
            if (this.miningTime++ > hardness) {
                this.m_9236_().m_46961_(this.hitPos, true);
                this.setDugBlockCount(this.getDugBlockCount() + 1);
                this.miningTime = 0;
                this.lastMineBlockBreakProgress = -1;
                this.m_20256_(centerOf.m_82541_().m_82490_((double)0.3f));
            } else {
                this.m_20256_(centerOf.m_82490_((double)0.2f));
            }
        } else {
            if (this.hitPos != null) {
                this.m_9236_().m_6801_(this.m_19879_(), this.hitPos, -1);
                this.hitPos = null;
            }
            this.setDigging(false);
        }
        if (this.isDigging() && this.soundTime-- <= 0) {
            this.soundTime = 38;
            this.m_216990_((SoundEvent)ACSoundRegistry.CORRODENT_TEETH.get());
        }
    }

    protected void m_6901_() {
        if (!this.isDigging()) {
            super.m_6901_();
        }
    }

    public void m_36799_() {
        this.f_36703_ = false;
    }

    public void m_142687_(Entity.RemovalReason removalReason) {
        if (this.hitPos != null) {
            this.m_9236_().m_6801_(this.m_19879_(), this.hitPos, -1);
            this.hitPos = null;
        }
        super.m_142687_(removalReason);
    }

    private boolean canMine(BlockPos hitPos) {
        Entity owner = this.m_19749_();
        if (owner != null && !(owner instanceof Player)) {
            return false;
        }
        BlockState state = this.m_9236_().m_8055_(hitPos);
        return !state.m_204336_(ACTagRegistry.UNMOVEABLE) && state.m_60819_().m_76178_() && state.m_60800_((BlockGetter)this.m_9236_(), hitPos) != -1.0f && this.getDugBlockCount() < 5;
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        this.hitPos = blockHitResult.m_82425_();
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)ACItemRegistry.BURROWING_ARROW.get());
    }

    private int getDugBlockCount() {
        return (Integer)this.f_19804_.m_135370_(DUG_BLOCK_COUNT);
    }

    private void setDugBlockCount(int count) {
        this.f_19804_.m_135381_(DUG_BLOCK_COUNT, (Object)count);
    }

    private boolean isDigging() {
        return (Boolean)this.f_19804_.m_135370_(DIGGING);
    }

    private void setDigging(boolean digging) {
        this.f_19804_.m_135381_(DIGGING, (Object)digging);
    }

    public float getDiggingAmount(float partialTicks) {
        return (this.prevDiggingProgress + (this.diggingProgress - this.prevDiggingProgress) * partialTicks) * 0.2f;
    }
}

