/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.sound;

import com.github.alexmodguy.alexscaves.client.sound.ItemTickableSound;
import com.github.alexmodguy.alexscaves.server.item.ResistorShieldItem;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class ResistorShieldSound
extends ItemTickableSound {
    private boolean azure;

    public ResistorShieldSound(LivingEntity user, boolean azure) {
        super(user, azure ? (SoundEvent)ACSoundRegistry.RESITOR_SHIELD_AZURE_LOOP.get() : (SoundEvent)ACSoundRegistry.RESITOR_SHIELD_SCARLET_LOOP.get());
        this.azure = azure;
    }

    @Override
    public void tickVolume(ItemStack itemStack) {
        float useAmount;
        this.f_119573_ = useAmount = ResistorShieldItem.getLerpedUseTime(itemStack, 1.0f) / 5.0f;
        this.f_119574_ = 0.2f + 0.8f * useAmount;
    }

    @Override
    public boolean isValidItem(ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof ResistorShieldItem) {
            return ResistorShieldItem.isScarlet(itemStack) == !this.azure;
        }
        return false;
    }

    public boolean isAzure() {
        return this.azure;
    }
}

