/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.model.LuxtructosaurusModel;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.client.render.entity.CustomBookEntityRenderer;
import com.github.alexmodguy.alexscaves.server.entity.living.LuxtructosaurusEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;

public class LuxtructosaurusRenderer
extends MobRenderer<LuxtructosaurusEntity, LuxtructosaurusModel>
implements CustomBookEntityRenderer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves:textures/entity/luxtructosaurus.png");
    private static final ResourceLocation TEXTURE_ENRAGED = new ResourceLocation("alexscaves:textures/entity/luxtructosaurus_enraged.png");
    private static final ResourceLocation TEXTURE_ENRAGED_GLOW = new ResourceLocation("alexscaves:textures/entity/luxtructosaurus_enraged_glow.png");
    private static final HashMap<Integer, Vec3> mouthParticlePositions = new HashMap();
    private boolean sepia = false;

    public LuxtructosaurusRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new LuxtructosaurusModel(), 4.0f);
        this.m_115326_(new LayerGlow());
    }

    protected void scale(LuxtructosaurusEntity mob, PoseStack matrixStackIn, float partialTicks) {
    }

    public ResourceLocation getTextureLocation(LuxtructosaurusEntity entity) {
        return entity.isEnraged() ? TEXTURE_ENRAGED : TEXTURE;
    }

    @Nullable
    protected RenderType getRenderType(LuxtructosaurusEntity mob, boolean normal, boolean translucent, boolean outline) {
        ResourceLocation resourcelocation = this.getTextureLocation(mob);
        if (translucent) {
            return RenderType.m_110467_((ResourceLocation)resourcelocation);
        }
        if (normal) {
            return this.sepia ? ACRenderTypes.getBookWidget(resourcelocation, true) : RenderType.m_110458_((ResourceLocation)resourcelocation);
        }
        return outline ? RenderType.m_110491_((ResourceLocation)resourcelocation) : null;
    }

    public void render(LuxtructosaurusEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource source, int packedLight) {
        if (this.sepia) {
            ((LuxtructosaurusModel)this.f_115290_).straighten = true;
        }
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, source, packedLight);
        if (this.sepia) {
            ((LuxtructosaurusModel)this.f_115290_).straighten = false;
        }
        mouthParticlePositions.put(entity.m_19879_(), ((LuxtructosaurusModel)this.f_115290_).getMouthPosition(Vec3.f_82478_));
    }

    public static Vec3 getMouthPositionFor(int entityId) {
        return mouthParticlePositions.get(entityId);
    }

    public boolean shouldRender(LuxtructosaurusEntity entity, Frustum camera, double x, double y, double z) {
        if (super.m_5523_((Mob)entity, camera, x, y, z)) {
            return true;
        }
        for (PartEntity<?> part : entity.getParts()) {
            if (!camera.m_113029_(part.m_6921_())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setSepiaFlag(boolean sepiaFlag) {
        this.sepia = sepiaFlag;
    }

    protected float getFlipDegrees(LuxtructosaurusEntity luxtructosaurus) {
        return 0.0f;
    }

    class LayerGlow
    extends RenderLayer<LuxtructosaurusEntity, LuxtructosaurusModel> {
        public LayerGlow() {
            super((RenderLayerParent)LuxtructosaurusRenderer.this);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, LuxtructosaurusEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            float enragedAlpha = ((float)Math.sin(ageInTicks * 0.2f) * 0.15f + 0.85f) * entitylivingbaseIn.getEnragedProgress(partialTicks);
            VertexConsumer ivertexbuilder1 = bufferIn.m_6299_(ACRenderTypes.getEyesAlphaEnabled(TEXTURE_ENRAGED_GLOW));
            ((LuxtructosaurusModel)this.m_117386_()).m_7695_(matrixStackIn, ivertexbuilder1, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, enragedAlpha);
        }
    }
}

