/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexmodguy.alexscaves.server.entity.item.WaveEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;

public class WaveModel
extends AdvancedEntityModel<WaveEntity> {
    private final AdvancedModelBox main;
    private final AdvancedModelBox top;

    public WaveModel() {
        this.texWidth = 128;
        this.texHeight = 128;
        this.main = new AdvancedModelBox((AdvancedEntityModel)this);
        this.main.setRotationPoint(0.0f, 24.0f, 0.0f);
        this.main.setTextureOffset(0, 28).addBox(-13.0f, -7.2919f, 0.9497f, 26.0f, 6.0f, 12.0f, -0.01f, false);
        this.top = new AdvancedModelBox((AdvancedEntityModel)this);
        this.top.setRotationPoint(0.0f, -2.0f, -4.0f);
        this.main.addChild((BasicModelPart)this.top);
        this.setRotateAngle(this.top, 0.7854f, 0.0f, 0.0f);
        this.top.setTextureOffset(0, 0).addBox(-13.0f, -7.0f, 3.0f, 26.0f, 11.0f, 17.0f, 0.0f, false);
        this.updateDefaultPose();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.main);
    }

    public void setupAnim(WaveEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        float f = (float)((Math.sin(ageInTicks * 0.1f) + 1.0) * (double)0.2f);
        float waveScale = entity.getWaveScale();
        float stretch = Math.min(40.0f, ageInTicks) / 40.0f;
        float slam = entity.getSlamAmount(ageInTicks - (float)entity.activeWaveTicks) * 1.4f;
        this.progressRotationPrev(this.top, slam, (float)Math.toRadians(100.0), 0.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.top, slam, 0.0f, -1.0f, 13.0f, 1.0f);
        this.top.rotateAngleX += f;
        this.top.rotationPointY += f * 8.0f;
        this.top.rotationPointZ += f * 2.0f;
        this.main.setScale(waveScale, waveScale, waveScale + stretch * 4.0f);
        this.top.setScale(waveScale, waveScale, waveScale + stretch * 1.0f);
        this.top.rotationPointY += stretch * 2.0f;
        this.top.rotationPointZ += stretch * 2.0f;
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.main, (Object)this.top);
    }
}

