/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexmodguy.alexscaves.server.entity.living.GumWormEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;

public class GumWormModel
extends AdvancedEntityModel<GumWormEntity> {
    private final AdvancedModelBox main;
    private final AdvancedModelBox head;
    private final AdvancedModelBox bottom_Eye;
    private final AdvancedModelBox left_Eye;
    private final AdvancedModelBox right_Eye;
    private final AdvancedModelBox top_Eye;
    private final AdvancedModelBox gum_Strand1;
    private final AdvancedModelBox gum_Strand2;
    private final AdvancedModelBox gum_Strand3;
    private final AdvancedModelBox bottom_Jaw;
    private final AdvancedModelBox top_Jaw;
    private final AdvancedModelBox cube_r1;
    private final AdvancedModelBox cube_r2;

    public GumWormModel() {
        this.texWidth = 256;
        this.texHeight = 256;
        float hatLayer = 1.0f;
        this.main = new AdvancedModelBox((AdvancedEntityModel)this);
        this.main.setRotationPoint(0.0f, 24.0f, -6.0f);
        this.head = new AdvancedModelBox((AdvancedEntityModel)this);
        this.head.setRotationPoint(0.0f, -16.5f, 35.25f);
        this.main.addChild((BasicModelPart)this.head);
        this.head.setTextureOffset(116, 67).addBox(-16.5f, -16.5f, -22.25f, 33.0f, 33.0f, 22.0f, 0.0f, false);
        this.head.setTextureOffset(17, 220).addBox(-16.5f, -16.5f, -22.25f, 33.0f, 33.0f, 3.0f, hatLayer, false);
        this.bottom_Eye = new AdvancedModelBox((AdvancedEntityModel)this);
        this.bottom_Eye.setRotationPoint(0.0f, 18.0f, -11.75f);
        this.head.addChild((BasicModelPart)this.bottom_Eye);
        this.cube_r1 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.cube_r1.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.bottom_Eye.addChild((BasicModelPart)this.cube_r1);
        this.setRotateAngle(this.cube_r1, 0.0f, 0.0f, -1.5708f);
        this.cube_r1.setTextureOffset(0, 0).addBox(-1.5f, -6.0f, -6.0f, 3.0f, 12.0f, 12.0f, 0.0f, true);
        this.left_Eye = new AdvancedModelBox((AdvancedEntityModel)this);
        this.left_Eye.setRotationPoint(18.0f, 0.0f, -10.75f);
        this.head.addChild((BasicModelPart)this.left_Eye);
        this.left_Eye.setTextureOffset(0, 0).addBox(-1.5f, -6.0f, -6.0f, 3.0f, 12.0f, 12.0f, 0.0f, false);
        this.right_Eye = new AdvancedModelBox((AdvancedEntityModel)this);
        this.right_Eye.setRotationPoint(-18.0f, 0.0f, -10.75f);
        this.head.addChild((BasicModelPart)this.right_Eye);
        this.right_Eye.setTextureOffset(0, 0).addBox(-1.5f, -6.0f, -6.0f, 3.0f, 12.0f, 12.0f, 0.0f, true);
        this.top_Eye = new AdvancedModelBox((AdvancedEntityModel)this);
        this.top_Eye.setRotationPoint(0.0f, -18.0f, -11.75f);
        this.head.addChild((BasicModelPart)this.top_Eye);
        this.cube_r2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.cube_r2.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.top_Eye.addChild((BasicModelPart)this.cube_r2);
        this.setRotateAngle(this.cube_r2, 0.0f, 0.0f, 1.5708f);
        this.cube_r2.setTextureOffset(0, 0).addBox(-1.5f, -6.0f, -6.0f, 3.0f, 12.0f, 12.0f, 0.0f, true);
        this.gum_Strand1 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.gum_Strand1.setRotationPoint(9.0f, 1.0f, -35.75f);
        this.head.addChild((BasicModelPart)this.gum_Strand1);
        this.gum_Strand1.setTextureOffset(218, 103).addBox(0.0f, -18.5f, -9.5f, 0.0f, 37.0f, 19.0f, 0.0f, false);
        this.gum_Strand2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.gum_Strand2.setRotationPoint(-9.0f, 1.0f, -35.75f);
        this.head.addChild((BasicModelPart)this.gum_Strand2);
        this.gum_Strand2.setTextureOffset(218, 103).addBox(0.0f, -18.5f, -9.5f, 0.0f, 37.0f, 19.0f, 0.0f, false);
        this.gum_Strand3 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.gum_Strand3.setRotationPoint(0.0f, 1.0f, -35.75f);
        this.head.addChild((BasicModelPart)this.gum_Strand3);
        this.setRotateAngle(this.gum_Strand3, 0.0f, 0.7854f, 0.0f);
        this.gum_Strand3.setTextureOffset(218, 103).addBox(0.0f, -18.5f, -9.5f, 0.0f, 37.0f, 19.0f, 0.0f, true);
        this.bottom_Jaw = new AdvancedModelBox((AdvancedEntityModel)this);
        this.bottom_Jaw.setRotationPoint(0.0f, 6.5f, -22.0f);
        this.head.addChild((BasicModelPart)this.bottom_Jaw);
        this.bottom_Jaw.setTextureOffset(102, 9).addBox(-16.5f, 0.0f, -36.25f, 33.0f, 10.0f, 36.0f, 0.0f, false);
        this.bottom_Jaw.setTextureOffset(0, 43).addBox(-16.5f, -10.0f, -36.25f, 33.0f, 10.0f, 36.0f, 0.0f, false);
        this.bottom_Jaw.setTextureOffset(118, 210).addBox(-16.5f, 0.0f, -36.25f, 33.0f, 10.0f, 36.0f, hatLayer + 0.01f, false);
        this.top_Jaw = new AdvancedModelBox((AdvancedEntityModel)this);
        this.top_Jaw.setRotationPoint(0.0f, -6.5f, -22.25f);
        this.head.addChild((BasicModelPart)this.top_Jaw);
        this.top_Jaw.setTextureOffset(118, 165).addBox(-16.5f, -10.0f, -36.0f, 33.0f, 10.0f, 36.0f, hatLayer + 0.01f, false);
        this.top_Jaw.setTextureOffset(0, 144).addBox(-16.5f, 0.0f, -36.0f, 33.0f, 10.0f, 36.0f, 0.0f, false);
        this.top_Jaw.setTextureOffset(0, 89).addBox(-16.5f, -10.0f, -36.0f, 33.0f, 10.0f, 36.0f, 0.0f, false);
        this.updateDefaultPose();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.main);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.main, (Object)this.head, (Object)this.bottom_Eye, (Object)this.top_Eye, (Object)this.left_Eye, (Object)this.right_Eye, (Object)this.top_Jaw, (Object)this.bottom_Jaw, (Object)this.gum_Strand1, (Object)this.gum_Strand2, (Object)this.gum_Strand3, (Object)this.cube_r1, (Object[])new AdvancedModelBox[]{this.cube_r2});
    }

    public void setupAnim(GumWormEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        float partialTicks = ageInTicks - (float)entity.f_19797_;
        float mouthOpenProgress = entity.getMouthOpenProgress(partialTicks);
        this.walk(this.bottom_Jaw, 0.2f, 0.1f, true, 1.0f, -0.8f, ageInTicks, mouthOpenProgress);
        this.walk(this.top_Jaw, 0.2f, 0.1f, false, 1.0f, -0.8f, ageInTicks, mouthOpenProgress);
        float gumStretchVertical = Math.max(ACMath.walkValue(ageInTicks, mouthOpenProgress, 0.2f, 1.0f, 0.15f, true) + mouthOpenProgress, 0.0f) + 0.45f;
        this.gum_Strand1.setScale(1.0f, gumStretchVertical, 1.0f - gumStretchVertical * 0.2f);
        this.gum_Strand2.setScale(1.0f, gumStretchVertical, 1.0f - gumStretchVertical * 0.2f);
        this.gum_Strand3.setScale(1.0f, gumStretchVertical, 1.0f - gumStretchVertical * 0.2f);
        this.head.rotateAngleZ += (float)Math.toRadians(entity.getBodyZRot(partialTicks));
    }
}

