/*
 * Decompiled with CFR 0.152.
 */
package artifacts.loot;

import artifacts.Artifacts;
import artifacts.registry.ModLootConditions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class ConfigValueChance
implements LootItemCondition {
    private final ChanceConfig chanceConfig;

    private ConfigValueChance(ChanceConfig chanceConfig) {
        this.chanceConfig = chanceConfig;
    }

    public LootItemConditionType m_7940_() {
        return ModLootConditions.CONFIG_VALUE_CHANCE.get();
    }

    public boolean test(LootContext context) {
        return context.m_230907_().m_188500_() < this.chanceConfig.value.get();
    }

    public static LootItemCondition.Builder archaeologyChance() {
        return () -> new ConfigValueChance(ChanceConfig.ARCHAEOLOGY);
    }

    public static LootItemCondition.Builder entityEquipmentChance() {
        return () -> new ConfigValueChance(ChanceConfig.ENTITY_EQUIPMENT);
    }

    public static LootItemCondition.Builder everlastingBeefChance() {
        return () -> new ConfigValueChance(ChanceConfig.EVERLASTING_BEEF);
    }

    private static enum ChanceConfig {
        ARCHAEOLOGY("archaeology", () -> Artifacts.CONFIG.common.archaeologyChance),
        ENTITY_EQUIPMENT("entity_equipment", () -> Artifacts.CONFIG.common.entityEquipmentChance),
        EVERLASTING_BEEF("everlasting_beef", () -> Artifacts.CONFIG.common.everlastingBeefChance);

        final String name;
        final Supplier<Double> value;

        private ChanceConfig(String name, Supplier<Double> value) {
            this.name = name;
            this.value = value;
        }

        static ChanceConfig byName(String name) {
            return ChanceConfig.valueOf(name.toUpperCase(Locale.ROOT));
        }
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<ConfigValueChance> {
        public void serialize(JsonObject object, ConfigValueChance condition, JsonSerializationContext context) {
            object.addProperty("config", condition.chanceConfig.name);
        }

        public ConfigValueChance deserialize(JsonObject object, JsonDeserializationContext context) {
            ChanceConfig config = ChanceConfig.byName(GsonHelper.m_13906_((JsonObject)object, (String)"config"));
            return new ConfigValueChance(config);
        }
    }
}

