/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.spells_gone_wrong.common.spell;

import com.kekecreations.spells_gone_wrong.core.config.SpellsGoneWrongCommonConfig;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.entity.spells.creeper_head.CreeperHeadProjectile;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class NucreeperStrikeSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("spells_gone_wrong", "nucreeper_strike");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(SchoolRegistry.EVOCATION_RESOURCE).setMaxLevel(10).setCooldownSeconds(2.0).build();

    public NucreeperStrikeSpell() {
        this.manaCostPerLevel = 12;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 0;
        this.castTime = 18;
        this.baseManaCost = 75;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel), (int)1)}), Component.m_237110_((String)"ui.irons_spellbooks.projectile_count", (Object[])new Object[]{this.getCount(spellLevel)}));
    }

    private int getCount(float spellLevel) {
        if (spellLevel < 6.0f) {
            return 7;
        }
        if (spellLevel >= 6.0f && spellLevel < 8.0f) {
            return 11;
        }
        return 17;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    private float getDamage(int spellLevel) {
        if (spellLevel <= 3) {
            return 1.0f + (float)spellLevel / 2.0f;
        }
        return 0.8f + (float)spellLevel / 2.0f;
    }

    public boolean isEnabled() {
        return (Boolean)SpellsGoneWrongCommonConfig.NUCREEPER_STRIKE_SPELL.get();
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        float speed = 0.8f;
        float speed2 = 0.8f;
        float damage = this.getDamage(spellLevel);
        Vec3 spawn = entity.m_146892_().m_82549_(entity.m_20156_());
        RandomSource random = entity.m_217043_();
        CreeperHeadProjectile head = new CreeperHeadProjectile(entity, level, speed + random.m_188501_(), damage);
        CreeperHeadProjectile head2 = new CreeperHeadProjectile(entity, level, speed2 + random.m_188501_(), damage);
        CreeperHeadProjectile head3 = new CreeperHeadProjectile(entity, level, speed2 + random.m_188501_(), damage);
        CreeperHeadProjectile head4 = new CreeperHeadProjectile(entity, level, speed2 + random.m_188501_(), damage);
        CreeperHeadProjectile head5 = new CreeperHeadProjectile(entity, level, speed2 + random.m_188501_(), damage);
        CreeperHeadProjectile head6 = new CreeperHeadProjectile(entity, level, speed2 + random.m_188501_(), damage);
        CreeperHeadProjectile head7 = new CreeperHeadProjectile(entity, level, speed2 + random.m_188501_(), damage);
        head.m_7678_(spawn.f_82479_, spawn.f_82480_ - head.m_20191_().m_82376_() / 2.0, spawn.f_82481_, entity.m_146908_() + 180.0f, entity.m_146909_());
        head2.m_7678_(spawn.f_82479_ + 0.8, spawn.f_82480_ - head.m_20191_().m_82376_() / 2.0, spawn.f_82481_, entity.m_146908_() + 180.0f, entity.m_146909_());
        head3.m_7678_(spawn.f_82479_ - 0.8, spawn.f_82480_ - head.m_20191_().m_82376_() / 2.0, spawn.f_82481_, entity.m_146908_() + 180.0f, entity.m_146909_());
        head4.m_7678_(spawn.f_82479_, spawn.f_82480_ - head.m_20191_().m_82376_() / 2.0, spawn.f_82481_ + 0.8, entity.m_146908_() + 180.0f, entity.m_146909_());
        head5.m_7678_(spawn.f_82479_, spawn.f_82480_ - head.m_20191_().m_82376_() / 2.0, spawn.f_82481_ - 0.8, entity.m_146908_() + 180.0f, entity.m_146909_());
        head6.m_7678_(spawn.f_82479_ - 0.8, spawn.f_82480_ - head.m_20191_().m_82376_() / 2.0, spawn.f_82481_ - 0.8, entity.m_146908_() + 180.0f, entity.m_146909_());
        head7.m_7678_(spawn.f_82479_ + 0.8, spawn.f_82480_ - head.m_20191_().m_82376_() / 2.0, spawn.f_82481_ + 0.8, entity.m_146908_() + 180.0f, entity.m_146909_());
        level.m_7967_((Entity)head);
        level.m_7967_((Entity)head2);
        level.m_7967_((Entity)head3);
        level.m_7967_((Entity)head4);
        level.m_7967_((Entity)head5);
        level.m_7967_((Entity)head6);
        level.m_7967_((Entity)head7);
        if (spellLevel >= 6) {
            CreeperHeadProjectile head8 = new CreeperHeadProjectile(entity, level, speed2 + random.m_188501_(), damage);
            CreeperHeadProjectile head9 = new CreeperHeadProjectile(entity, level, speed2 + random.m_188501_(), damage);
            CreeperHeadProjectile head10 = new CreeperHeadProjectile(entity, level, speed2 + random.m_188501_(), damage);
            CreeperHeadProjectile head11 = new CreeperHeadProjectile(entity, level, speed2 + random.m_188501_(), damage);
            head8.m_7678_(spawn.f_82479_ + 1.5, spawn.f_82480_ - head.m_20191_().m_82376_() / 2.0, spawn.f_82481_, entity.m_146908_() + 180.0f, entity.m_146909_());
            head9.m_7678_(spawn.f_82479_ - 1.5, spawn.f_82480_ - head.m_20191_().m_82376_() / 2.0, spawn.f_82481_, entity.m_146908_() + 180.0f, entity.m_146909_());
            head10.m_7678_(spawn.f_82479_, spawn.f_82480_ - head.m_20191_().m_82376_() / 2.0, spawn.f_82481_ + 1.5, entity.m_146908_() + 180.0f, entity.m_146909_());
            head11.m_7678_(spawn.f_82479_, spawn.f_82480_ - head.m_20191_().m_82376_() / 2.0, spawn.f_82481_ - 1.5, entity.m_146908_() + 180.0f, entity.m_146909_());
            level.m_7967_((Entity)head8);
            level.m_7967_((Entity)head9);
            level.m_7967_((Entity)head10);
            level.m_7967_((Entity)head11);
        }
        if (spellLevel >= 8) {
            CreeperHeadProjectile head12 = new CreeperHeadProjectile(entity, level, speed2 + random.m_188501_(), damage);
            CreeperHeadProjectile head13 = new CreeperHeadProjectile(entity, level, speed2 + random.m_188501_(), damage);
            CreeperHeadProjectile head14 = new CreeperHeadProjectile(entity, level, speed2 + random.m_188501_(), damage);
            CreeperHeadProjectile head15 = new CreeperHeadProjectile(entity, level, speed2 + random.m_188501_(), damage);
            CreeperHeadProjectile head16 = new CreeperHeadProjectile(entity, level, speed2 + random.m_188501_(), damage);
            CreeperHeadProjectile head17 = new CreeperHeadProjectile(entity, level, speed2 + random.m_188501_(), damage);
            head12.m_7678_(spawn.f_82479_ + 2.3, spawn.f_82480_ - head.m_20191_().m_82376_() / 2.0, spawn.f_82481_, entity.m_146908_() + 180.0f, entity.m_146909_());
            head13.m_7678_(spawn.f_82479_ - 2.3, spawn.f_82480_ - head.m_20191_().m_82376_() / 2.0, spawn.f_82481_, entity.m_146908_() + 180.0f, entity.m_146909_());
            head14.m_7678_(spawn.f_82479_, spawn.f_82480_ - head.m_20191_().m_82376_() / 2.0, spawn.f_82481_ + 2.3, entity.m_146908_() + 180.0f, entity.m_146909_());
            head15.m_7678_(spawn.f_82479_, spawn.f_82480_ - head.m_20191_().m_82376_() / 2.0, spawn.f_82481_ - 2.3, entity.m_146908_() + 180.0f, entity.m_146909_());
            head16.m_7678_(spawn.f_82479_ + 1.5, spawn.f_82480_ - head.m_20191_().m_82376_() / 2.0, spawn.f_82481_ + 1.5, entity.m_146908_() + 180.0f, entity.m_146909_());
            head17.m_7678_(spawn.f_82479_ - 1.5, spawn.f_82480_ - head.m_20191_().m_82376_() / 2.0, spawn.f_82481_ + 1.5, entity.m_146908_() + 180.0f, entity.m_146909_());
            level.m_7967_((Entity)head12);
            level.m_7967_((Entity)head13);
            level.m_7967_((Entity)head14);
            level.m_7967_((Entity)head15);
            level.m_7967_((Entity)head16);
            level.m_7967_((Entity)head17);
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }
}

