/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannons.autocannon.breech;

import com.mojang.math.Axis;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.Instancer;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.OrientedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import rbasamoyai.createbigcannons.cannons.autocannon.AutocannonBlock;
import rbasamoyai.createbigcannons.cannons.autocannon.breech.AbstractAutocannonBreechBlockEntity;
import rbasamoyai.createbigcannons.cannons.autocannon.breech.AutocannonBreechBlock;
import rbasamoyai.createbigcannons.index.CBCBlockPartials;
import rbasamoyai.createbigcannons.munitions.autocannon.ammo_container.AutocannonAmmoContainerBlock;
import rbasamoyai.createbigcannons.munitions.autocannon.ammo_container.AutocannonAmmoContainerItem;

public class AutocannonBreechVisual
extends AbstractBlockEntityVisual<AbstractAutocannonBreechBlockEntity>
implements SimpleDynamicVisual {
    private final OrientedInstance ejector;
    private final OrientedInstance seat;
    private final OrientedInstance ammoContainer;
    private DyeColor seatColor;
    private final Direction facing = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61372_);
    private boolean isFilled = false;
    private Item magazineItem = null;

    public AutocannonBreechVisual(VisualizationContext ctx, AbstractAutocannonBreechBlockEntity blockEntity, float partialTick) {
        super(ctx, (BlockEntity)blockEntity, partialTick);
        Quaternionf q1;
        Quaternionf q = Axis.f_252436_.m_252977_(this.facing.m_122434_().m_122478_() ? 180.0f : 0.0f);
        this.ejector = ((OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)this.getPartialModelForState(), (Direction)this.facing)).createInstance()).rotation((Quaternionfc)q);
        this.seatColor = ((AbstractAutocannonBreechBlockEntity)this.blockEntity).getSeatColor();
        this.seat = ((OrientedInstance)this.seatInstancer().createInstance()).rotation((Quaternionfc)q).position((Vec3i)this.getVisualPosition());
        this.ammoContainer = (OrientedInstance)this.containerInstancer().createInstance();
        boolean flag = this.facing.m_122434_().m_122478_();
        if (flag) {
            float f = this.facing == Direction.UP ? 90.0f : -90.0f;
            q1 = Axis.f_252403_.m_252977_(f);
            q1.mul((Quaternionfc)Axis.f_252529_.m_252977_(f));
        } else {
            q1 = Axis.f_252436_.m_252977_(-90.0f - this.facing.m_122435_());
        }
        Direction offset = flag ? this.facing.m_175364_(Direction.Axis.Z) : this.facing.m_175362_(Direction.Axis.Y);
        Vector3f normal = this.facing == Direction.UP ? offset.m_122424_().m_253071_() : offset.m_253071_();
        normal.mul(0.625f);
        this.ammoContainer.rotation((Quaternionfc)q1).position((Vec3i)this.getVisualPosition()).translatePosition(normal.x(), normal.y(), normal.z());
        this.isFilled = this.isFilled();
        this.magazineItem = this.getMagazineItem();
        this.updateTransforms(partialTick);
    }

    protected void refreshSeat() {
        this.seatColor = ((AbstractAutocannonBreechBlockEntity)this.blockEntity).getSeatColor();
        this.seatInstancer().stealInstance((Instance)this.seat);
    }

    protected Instancer<OrientedInstance> seatInstancer() {
        return this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)CBCBlockPartials.autocannonSeatFor(this.seatColor), (Direction)this.facing));
    }

    protected void refreshContainer() {
        this.isFilled = this.isFilled();
        this.magazineItem = this.getMagazineItem();
        this.containerInstancer().stealInstance((Instance)this.ammoContainer);
    }

    protected Instancer<OrientedInstance> containerInstancer() {
        return this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.block((BlockState)this.getAmmoContainerModel()));
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        this.updateTransforms(ctx.partialTick());
    }

    private void updateTransforms(float partialTick) {
        if (((Boolean)this.blockState.m_61143_((Property)AutocannonBreechBlock.HANDLE)).booleanValue()) {
            this.ejector.setVisible(false);
            this.seat.setVisible(this.seatColor != null);
        } else {
            this.ejector.setVisible(true);
            this.seat.setVisible(false);
            float offset = ((AbstractAutocannonBreechBlockEntity)this.blockEntity).getAnimateOffset(partialTick) * 0.5f;
            Vector3f normal = this.facing.m_122424_().m_253071_();
            normal.mul(offset);
            this.ejector.position((Vec3i)this.getVisualPosition()).translatePosition(normal.x(), normal.y(), normal.z()).color((byte)-1, (byte)-1, (byte)-1, (byte)-1);
        }
        this.ammoContainer.setVisible(this.getMagazineItem() instanceof AutocannonAmmoContainerItem);
        if (this.seatColor != ((AbstractAutocannonBreechBlockEntity)this.blockEntity).getSeatColor()) {
            this.refreshSeat();
        }
        if (this.isFilled != this.isFilled() || this.magazineItem != this.getMagazineItem()) {
            this.refreshContainer();
        }
        this.seat.setChanged();
        this.ejector.setChanged();
        this.ammoContainer.setChanged();
    }

    public void updateLight(float partialTick) {
        this.relight(this.pos, new FlatLit[]{this.ejector});
        this.relight(this.pos, new FlatLit[]{this.seat});
        this.relight(this.pos, new FlatLit[]{this.ammoContainer});
    }

    protected void _delete() {
        this.ejector.delete();
        this.seat.delete();
        this.ammoContainer.delete();
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        consumer.accept((Instance)this.ejector);
        consumer.accept((Instance)this.seat);
        consumer.accept((Instance)this.ammoContainer);
    }

    private PartialModel getPartialModelForState() {
        PartialModel partialModel;
        Block block = this.blockState.m_60734_();
        if (block instanceof AutocannonBlock) {
            AutocannonBlock cBlock = (AutocannonBlock)block;
            partialModel = CBCBlockPartials.autocannonEjectorFor(cBlock.getAutocannonMaterial());
        } else {
            partialModel = CBCBlockPartials.CAST_IRON_AUTOCANNON_EJECTOR;
        }
        return partialModel;
    }

    private BlockState getAmmoContainerModel() {
        Item item;
        ItemStack item2 = ((AbstractAutocannonBreechBlockEntity)this.blockEntity).getMagazine();
        if (item2 == null || item2.m_41619_() || !((item = item2.m_41720_()) instanceof AutocannonAmmoContainerItem)) {
            return Blocks.f_50016_.m_49966_();
        }
        AutocannonAmmoContainerItem blockItem = (AutocannonAmmoContainerItem)item;
        BlockState state = blockItem.m_40614_().m_49966_();
        if (state.m_61138_(AutocannonAmmoContainerBlock.CONTAINER_STATE)) {
            state = (BlockState)state.m_61124_(AutocannonAmmoContainerBlock.CONTAINER_STATE, (Comparable)((Object)AutocannonAmmoContainerBlock.State.getFromFilled(AutocannonAmmoContainerItem.getTotalAmmoCount(item2) > 0)));
        }
        return state;
    }

    private boolean isFilled() {
        return AutocannonAmmoContainerItem.getTotalAmmoCount(((AbstractAutocannonBreechBlockEntity)this.blockEntity).getMagazine()) > 0;
    }

    private Item getMagazineItem() {
        ItemStack stack = ((AbstractAutocannonBreechBlockEntity)this.blockEntity).getMagazine();
        return stack == null || stack.m_41619_() ? null : stack.m_41720_();
    }
}

