/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.origins.common.network;

import com.google.common.collect.Sets;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.api.registry.ApoliDynamicRegistries;
import io.github.edwinmindcraft.origins.api.origin.IOriginCallbackPower;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public record C2SFinalizeNowReadyPowers(Set<ResourceKey<ConfiguredPower<?, ?>>> keys, boolean wasOrb) {
    public static C2SFinalizeNowReadyPowers decode(FriendlyByteBuf buf) {
        int keySize = buf.readInt();
        HashSet keys = Sets.newHashSet();
        for (int i = 0; i < keySize; ++i) {
            keys.add(buf.m_236801_(ApoliDynamicRegistries.CONFIGURED_POWER_KEY));
        }
        boolean wasOrb = buf.readBoolean();
        return new C2SFinalizeNowReadyPowers(keys, wasOrb);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.keys().size());
        for (ResourceKey<ConfiguredPower<?, ?>> key : this.keys()) {
            buf.m_236858_(key);
        }
        buf.writeBoolean(this.wasOrb());
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            if (sender == null) {
                return;
            }
            for (ResourceKey<ConfiguredPower<?, ?>> key : this.keys()) {
                PowerFactory patt2113$temp;
                Holder configuredPower = ApoliAPI.getPowerContainer((Entity)sender).getPower(key);
                if (configuredPower == null || !configuredPower.m_203633_() || !((patt2113$temp = ((ConfiguredPower)configuredPower.m_203334_()).getFactory()) instanceof IOriginCallbackPower)) continue;
                IOriginCallbackPower callbackPower = (IOriginCallbackPower)patt2113$temp;
                callbackPower.onChosen((ConfiguredPower)configuredPower.m_203334_(), (Entity)sender, this.wasOrb());
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

