/*
 * Decompiled with CFR 0.152.
 */
package upgrades.drink;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import toughasnails.api.thirst.IThirst;
import toughasnails.api.thirst.ThirstHelper;
import upgrades.drink.DrinkUpgradeItem;

public class DrinkUpgradeWrapper
extends UpgradeWrapperBase<DrinkUpgradeWrapper, DrinkUpgradeItem>
implements ITickableUpgrade,
IFilteredUpgrade {
    private static final String TAN_MODID = "toughasnails";
    private static final long DRINK_COOLDOWN_TICKS = 100L;
    private final FilterLogic filterLogic;
    private boolean isCleaning = false;
    private final Map<Item, Integer> thirstCache = new HashMap<Item, Integer>();
    private static final TagKey<Item> DRINKS_TAG = ItemTags.create((ResourceLocation)new ResourceLocation("drinkupgrade", "thirst_drinks"));

    public DrinkUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        int slots = 9;
        Item item = upgrade.m_41720_();
        if (item instanceof DrinkUpgradeItem) {
            DrinkUpgradeItem item2 = (DrinkUpgradeItem)item;
            slots = item2.getFilterSlotCount();
        }
        Consumer<ItemStack> finalHandler = slots <= 9 ? stack -> {
            if (!this.isCleaning) {
                this.isCleaning = true;
                try {
                    this.cleanFilterDurability();
                }
                finally {
                    this.isCleaning = false;
                }
            }
            upgradeSaveHandler.accept((ItemStack)stack);
        } : upgradeSaveHandler;
        this.filterLogic = new FilterLogic(upgrade, finalHandler, slots, this::isBaseDrink);
    }

    private void cleanFilterDurability() {
        FilterLogic.ObservableFilterItemStackHandler filterHandler = this.filterLogic.getFilterHandler();
        for (int i = 0; i < filterHandler.getSlots(); ++i) {
            ItemStack stack = filterHandler.getStackInSlot(i);
            if (stack.m_41619_() || !stack.m_41782_() || !stack.m_41783_().m_128441_("Damage")) continue;
            ItemStack clean = stack.m_41777_();
            clean.m_41783_().m_128473_("Damage");
            if (clean.m_41783_().m_128456_()) {
                clean.m_41751_(null);
            }
            filterHandler.setStackInSlot(i, clean);
        }
    }

    public void tick(@Nullable Entity entity, Level level, BlockPos pos) {
        if (level.f_46443_ || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        long nextDrinkTime = NBTHelper.getLong((ItemStack)this.upgrade, (String)"nextDrinkTime").orElse(0L);
        if (level.m_46467_() < nextDrinkTime) {
            return;
        }
        InventoryHandler handler = this.storageWrapper.getInventoryHandler();
        if (handler == null) {
            return;
        }
        if (this.autoDrinkFromBackpack((IItemHandler)handler, player, level)) {
            NBTHelper.setLong((ItemStack)this.upgrade, (String)"nextDrinkTime", (long)(level.m_46467_() + 100L));
            this.save();
        }
    }

    private boolean autoDrinkFromBackpack(IItemHandler handler, Player player, Level level) {
        int missingThirst = 0;
        if (ModList.get().isLoaded(TAN_MODID) && ThirstHelper.isThirstEnabled()) {
            IThirst thirst = ThirstHelper.getThirst((Player)player);
            if (thirst != null) {
                missingThirst = 20 - thirst.getThirst();
            }
        } else {
            missingThirst = 20 - player.m_36324_().m_38702_();
        }
        if (missingThirst <= 0) {
            return false;
        }
        int drinkSlot = this.findDrinkSlot(handler, player, missingThirst, level);
        if (drinkSlot == -1) {
            return false;
        }
        ItemStack toDrink = handler.extractItem(drinkSlot, 1, false);
        if (toDrink.m_41619_()) {
            return false;
        }
        ItemStack result = toDrink.m_41671_(level, (LivingEntity)player);
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11911_, SoundSource.PLAYERS, 0.8f, 1.0f);
        if (!result.m_41619_()) {
            CompoundTag nbt;
            ItemStack leftover = result.m_41777_();
            if (leftover.m_41720_() == Items.f_42590_ && leftover.m_41782_() && (nbt = leftover.m_41783_()) != null) {
                nbt.m_128473_("Potion");
                nbt.m_128473_("CustomPotionEffects");
                if (nbt.m_128456_()) {
                    leftover.m_41751_(null);
                }
            }
            if (handler.getStackInSlot(drinkSlot).m_41619_()) {
                if (handler instanceof IItemHandlerModifiable) {
                    IItemHandlerModifiable m = (IItemHandlerModifiable)handler;
                    m.setStackInSlot(drinkSlot, leftover);
                } else {
                    handler.insertItem(drinkSlot, leftover, false);
                }
            } else {
                ItemStack remaining = handler.insertItem(drinkSlot, leftover, false);
                if (!remaining.m_41619_()) {
                    for (int i = 0; i < handler.getSlots() && !remaining.m_41619_(); ++i) {
                        remaining = handler.insertItem(i, remaining, false);
                    }
                }
                if (!remaining.m_41619_()) {
                    player.m_36176_(remaining, false);
                }
            }
        }
        return true;
    }

    private int findDrinkSlot(IItemHandler handler, Player player, int missingThirst, Level level) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            boolean isHurt;
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.m_41619_() || !stack.m_204117_(DRINKS_TAG) || !this.filterLogic.matchesFilter(stack)) continue;
            boolean bl = isHurt = player.m_21223_() < player.m_21233_() - 0.1f;
            if (!this.isThirstyEnoughForDrink(missingThirst, stack, level) && (!this.shouldDrinkImmediatelyWhenHurt() || missingThirst <= 0 || !isHurt)) continue;
            return i;
        }
        return -1;
    }

    private boolean isThirstyEnoughForDrink(int missingThirst, ItemStack stack, Level level) {
        ThirstLevel drinkAtThirstLevel = this.getDrinkAtThirstLevel();
        if (drinkAtThirstLevel == ThirstLevel.ANY) {
            return missingThirst > 0;
        }
        int restorationValue = this.getSimulatedRestorationValue(stack, level);
        if (drinkAtThirstLevel == ThirstLevel.HALF) {
            return missingThirst >= restorationValue / 2;
        }
        return missingThirst >= restorationValue;
    }

    private int getSimulatedRestorationValue(ItemStack stack, Level level) {
        if (this.thirstCache.containsKey(stack.m_41720_())) {
            return this.thirstCache.get(stack.m_41720_());
        }
        if (!(level instanceof ServerLevel)) {
            return 4;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        try {
            FakePlayer fake = FakePlayerFactory.getMinecraft((ServerLevel)serverLevel);
            IThirst thirst = ThirstHelper.getThirst((Player)fake);
            if (thirst != null) {
                thirst.setThirst(0);
                stack.m_41777_().m_41671_(level, (LivingEntity)fake);
                int restored = thirst.getThirst();
                if (restored > 0) {
                    this.thirstCache.put(stack.m_41720_(), restored);
                    return restored;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 4;
    }

    private boolean isBaseDrink(ItemStack stack) {
        return stack.m_204117_(DRINKS_TAG);
    }

    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public boolean canBeDisabled() {
        return false;
    }

    public ThirstLevel getDrinkAtThirstLevel() {
        return NBTHelper.getEnumConstant((ItemStack)this.upgrade, (String)"drinkAtThirstLevel", ThirstLevel::fromName).orElse(ThirstLevel.HALF);
    }

    public void setDrinkAtThirstLevel(ThirstLevel thirstLevel) {
        NBTHelper.setEnumConstant((ItemStack)this.upgrade, (String)"drinkAtThirstLevel", (Enum)thirstLevel);
        this.save();
    }

    public boolean shouldDrinkImmediatelyWhenHurt() {
        return NBTHelper.getBoolean((ItemStack)this.upgrade, (String)"drinkImmediatelyWhenHurt").orElse(true);
    }

    public void setDrinkImmediatelyWhenHurt(boolean value) {
        NBTHelper.setBoolean((ItemStack)this.upgrade, (String)"drinkImmediatelyWhenHurt", (boolean)value);
        this.save();
    }

    public static enum ThirstLevel implements StringRepresentable
    {
        ANY("any"),
        HALF("half"),
        FULL("full");

        private final String name;

        private ThirstLevel(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public static ThirstLevel fromName(String name) {
            for (ThirstLevel l : ThirstLevel.values()) {
                if (!l.name.equals(name)) continue;
                return l;
            }
            return HALF;
        }

        public ThirstLevel next() {
            return ThirstLevel.values()[(this.ordinal() + 1) % ThirstLevel.values().length];
        }
    }
}

