/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.custom;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.advancement.criterion.ModCriteria;
import net.dawson.adorablehamsterpets.block.ModBlocks;
import net.dawson.adorablehamsterpets.block.custom.HamsterBedBlock;
import net.dawson.adorablehamsterpets.block.custom.WoodVariant;
import net.dawson.adorablehamsterpets.component.HamsterShoulderData;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.ConfigDataCache;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.WanderDistance;
import net.dawson.adorablehamsterpets.entity.AI.HamsterFleeGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterFollowOwnerGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterGoToBedAndSleepGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterLookAroundGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterLookAtEntityGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterMateGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterMeleeAttackGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterSeekDiamondGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterSitGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterSleepGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterStealDiamondGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterTemptGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterWanderAroundFarGoal;
import net.dawson.adorablehamsterpets.entity.AI.navigation.HamsterNavigation;
import net.dawson.adorablehamsterpets.entity.ImplementedInventory;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.entity.ShoulderLocation;
import net.dawson.adorablehamsterpets.entity.client.feature.ShoulderAnimationState;
import net.dawson.adorablehamsterpets.entity.control.HamsterBodyControl;
import net.dawson.adorablehamsterpets.entity.custom.HamsterVariant;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.item.custom.HamsterBedItem;
import net.dawson.adorablehamsterpets.mixin.accessor.LandPathNodeMakerInvoker;
import net.dawson.adorablehamsterpets.networking.ModPackets;
import net.dawson.adorablehamsterpets.particles.ModParticles;
import net.dawson.adorablehamsterpets.screen.HamsterScreenHandlerFactory;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.HamsterRenderTracker;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Unique;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HamsterEntity
extends TamableAnimal
implements GeoEntity,
ImplementedInventory {
    private static final double WALK_TO_RUN_THRESHOLD_SQUARED = 0.002;
    private static final double RUN_TO_SPRINT_THRESHOLD_SQUARED = 0.008;
    public static final float FAST_YAW_CHANGE = 25.0f;
    public static final float FAST_PITCH_CHANGE = 25.0f;
    private static final int INVENTORY_SIZE = 6;
    private static final int REFUSE_FOOD_TIMER_TICKS = 40;
    private static final int CUSTOM_LOVE_TICKS = 600;
    private static final float THROW_DAMAGE = 20.0f;
    private static final double THROWN_GRAVITY = -0.05;
    private static final double HAMSTER_ATTACK_BOX_EXPANSION = 0.7;
    public static final int CELEBRATION_PARTICLE_DURATION_TICKS = 600;
    private static final float DEFAULT_FOOTSTEP_VOLUME = 0.1f;
    private static final float GRAVEL_VOLUME_MODIFIER = 0.6f;
    private static final Set<BlockPathTypes> HAZARDOUS_FLOOR_TYPES = EnumSet.of(BlockPathTypes.LAVA, new BlockPathTypes[]{BlockPathTypes.DAMAGE_FIRE, BlockPathTypes.DANGER_FIRE, BlockPathTypes.POWDER_SNOW, BlockPathTypes.DAMAGE_OTHER, BlockPathTypes.DANGER_OTHER, BlockPathTypes.DAMAGE_CAUTIOUS, BlockPathTypes.WATER});
    private static final List<HamsterVariant> ORANGE_VARIANTS = List.of(HamsterVariant.ORANGE, HamsterVariant.ORANGE_OVERLAY1, HamsterVariant.ORANGE_OVERLAY2, HamsterVariant.ORANGE_OVERLAY3, HamsterVariant.ORANGE_OVERLAY4, HamsterVariant.ORANGE_OVERLAY5, HamsterVariant.ORANGE_OVERLAY6, HamsterVariant.ORANGE_OVERLAY7, HamsterVariant.ORANGE_OVERLAY8);
    private static final List<HamsterVariant> BLUE_VARIANTS = List.of(HamsterVariant.BLUE, HamsterVariant.BLUE_OVERLAY1, HamsterVariant.BLUE_OVERLAY2, HamsterVariant.BLUE_OVERLAY3, HamsterVariant.BLUE_OVERLAY4, HamsterVariant.BLUE_OVERLAY5, HamsterVariant.BLUE_OVERLAY6, HamsterVariant.BLUE_OVERLAY7, HamsterVariant.BLUE_OVERLAY8);
    private static final List<HamsterVariant> CHOCOLATE_VARIANTS = List.of(HamsterVariant.CHOCOLATE, HamsterVariant.CHOCOLATE_OVERLAY1, HamsterVariant.CHOCOLATE_OVERLAY2, HamsterVariant.CHOCOLATE_OVERLAY3, HamsterVariant.CHOCOLATE_OVERLAY4, HamsterVariant.CHOCOLATE_OVERLAY5, HamsterVariant.CHOCOLATE_OVERLAY6, HamsterVariant.CHOCOLATE_OVERLAY7, HamsterVariant.CHOCOLATE_OVERLAY8);
    private static final List<HamsterVariant> CREAM_VARIANTS = List.of(HamsterVariant.CREAM, HamsterVariant.CREAM_OVERLAY1, HamsterVariant.CREAM_OVERLAY2, HamsterVariant.CREAM_OVERLAY3, HamsterVariant.CREAM_OVERLAY4, HamsterVariant.CREAM_OVERLAY5, HamsterVariant.CREAM_OVERLAY6, HamsterVariant.CREAM_OVERLAY7, HamsterVariant.CREAM_OVERLAY8);
    private static final List<HamsterVariant> DARK_GRAY_VARIANTS = List.of(HamsterVariant.DARK_GRAY, HamsterVariant.DARK_GRAY_OVERLAY1, HamsterVariant.DARK_GRAY_OVERLAY2, HamsterVariant.DARK_GRAY_OVERLAY3, HamsterVariant.DARK_GRAY_OVERLAY4, HamsterVariant.DARK_GRAY_OVERLAY5, HamsterVariant.DARK_GRAY_OVERLAY6, HamsterVariant.DARK_GRAY_OVERLAY7, HamsterVariant.DARK_GRAY_OVERLAY8);
    private static final List<HamsterVariant> LAVENDER_VARIANTS = List.of(HamsterVariant.LAVENDER, HamsterVariant.LAVENDER_OVERLAY1, HamsterVariant.LAVENDER_OVERLAY2, HamsterVariant.LAVENDER_OVERLAY3, HamsterVariant.LAVENDER_OVERLAY4, HamsterVariant.LAVENDER_OVERLAY5, HamsterVariant.LAVENDER_OVERLAY6, HamsterVariant.LAVENDER_OVERLAY7, HamsterVariant.LAVENDER_OVERLAY8);
    private static final List<HamsterVariant> LIGHT_GRAY_VARIANTS = List.of(HamsterVariant.LIGHT_GRAY, HamsterVariant.LIGHT_GRAY_OVERLAY1, HamsterVariant.LIGHT_GRAY_OVERLAY2, HamsterVariant.LIGHT_GRAY_OVERLAY3, HamsterVariant.LIGHT_GRAY_OVERLAY4, HamsterVariant.LIGHT_GRAY_OVERLAY5, HamsterVariant.LIGHT_GRAY_OVERLAY6, HamsterVariant.LIGHT_GRAY_OVERLAY7, HamsterVariant.LIGHT_GRAY_OVERLAY8);
    public static final int SLEEPING_FLAG = 1;
    public static final int SITTING_FLAG = 2;
    public static final int BEGGING_FLAG = 4;
    public static final int IN_LOVE_FLAG = 8;
    public static final int REFUSING_FOOD_FLAG = 16;
    public static final int THROWN_FLAG = 32;
    public static final int LEFT_CHEEK_FULL_FLAG = 64;
    public static final int RIGHT_CHEEK_FULL_FLAG = 128;
    public static final int KNOCKED_OUT_FLAG = 256;
    public static final int CHEEK_POUCH_UNLOCKED_FLAG = 512;
    public static final int CONSIDERING_AUTO_EAT_FLAG = 1024;
    public static final int SULKING_FLAG = 2048;
    public static final int CELEBRATING_DIAMOND_FLAG = 4096;
    public static final int CLEANING_FLAG = 8192;
    public static final int STEALING_DIAMOND_FLAG = 16384;
    public static final int TAUNTING_FLAG = 32768;
    public static final int CELEBRATING_CHASE_FLAG = 65536;
    public static final int IS_SHOULDER_PET_FLAG = 131072;
    public static final int IS_WANDER_MODE_ACTIVE_FLAG = 262144;
    public static final int ON_THE_WAY_TO_BED_FLAG = 524288;
    private static final EntityDataAccessor<Integer> HAMSTER_FLAGS = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> ANIMATION_PERSONALITY_ID = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> PINK_PETAL_TYPE = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DOZING_PHASE = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<String> CURRENT_DEEP_SLEEP_ANIM_ID = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> ACTIVE_CUSTOM_GOAL_NAME_DEBUG = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> STEAL_DURATION_TIMER = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<ItemStack> STOLEN_ITEM_STACK = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public static final EntityDataAccessor<Long> GREEN_BEAN_BUFF_DURATION = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);
    public static final EntityDataAccessor<Integer> CURRENT_LOOK_UP_ANIM_ID = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> SHOULDER_ANIMATION_STATE = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final RawAnimation CRASH_ANIM = RawAnimation.begin().thenPlay("anim_hamster_crash");
    private static final RawAnimation KNOCKED_OUT_ANIM = RawAnimation.begin().thenPlay("anim_hamster_ko");
    private static final RawAnimation WAKE_UP_FROM_KO_ANIM = RawAnimation.begin().thenPlay("anim_hamster_wakeup_from_ko");
    private static final RawAnimation FLYING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_flying");
    private static final RawAnimation STATIONARY_HEADSHAKE_ANIM = RawAnimation.begin().thenPlay("anim_hamster_stationary_headshake");
    private static final RawAnimation MOVING_HEADSHAKE_ANIM = RawAnimation.begin().thenPlay("anim_hamster_moving_headshake");
    private static final RawAnimation SLEEP_POSE1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sleep_pose1");
    private static final RawAnimation SLEEP_POSE2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sleep_pose2");
    private static final RawAnimation SLEEP_POSE3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sleep_pose3");
    private static final RawAnimation SIT_SETTLE_SLEEP1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sit_settle_sleep1");
    private static final RawAnimation SIT_SETTLE_SLEEP2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sit_settle_sleep2");
    private static final RawAnimation SIT_SETTLE_SLEEP3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sit_settle_sleep3");
    private static final RawAnimation STAND_SETTLE_SLEEP1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_stand_settle_sleep1");
    private static final RawAnimation STAND_SETTLE_SLEEP2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_stand_settle_sleep2");
    private static final RawAnimation STAND_SETTLE_SLEEP3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_stand_settle_sleep3");
    private static final RawAnimation SIT1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sit1");
    private static final RawAnimation SIT2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sit2");
    private static final RawAnimation SIT3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sit3");
    private static final RawAnimation STANDUP1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_standup1");
    private static final RawAnimation STANDUP2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_standup2");
    private static final RawAnimation STANDUP3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_standup3");
    private static final RawAnimation WAKE_UP_1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_wakeup1");
    private static final RawAnimation WAKE_UP_2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_wakeup2");
    private static final RawAnimation WAKE_UP_3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_wakeup3");
    private static final RawAnimation SITTING_POSE1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sitting_pose1");
    private static final RawAnimation SITTING_POSE2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sitting_pose2");
    private static final RawAnimation SITTING_POSE3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sitting_pose3");
    private static final RawAnimation DRIFTING_OFF_POSE1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_drifting_off_pose1");
    private static final RawAnimation DRIFTING_OFF_POSE2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_drifting_off_pose2");
    private static final RawAnimation DRIFTING_OFF_POSE3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_drifting_off_pose3");
    private static final RawAnimation CLEANING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_cleaning");
    private static final RawAnimation RUNNING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_running");
    private static final RawAnimation WALKING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_walking");
    private static final RawAnimation SPRINTING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sprinting");
    private static final RawAnimation BEGGING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_begging");
    private static final RawAnimation IDLE1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_idle1");
    private static final RawAnimation IDLE2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_idle2");
    private static final RawAnimation IDLE_LOOKING_UP1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_idle_looking_up1");
    private static final RawAnimation IDLE_LOOKING_UP2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_idle_looking_up2");
    private static final RawAnimation IDLE_LOOKING_UP3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_idle_looking_up3");
    private static final RawAnimation ATTACK_ANIM = RawAnimation.begin().thenPlay("anim_hamster_attack");
    private static final RawAnimation SULK_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sulk");
    private static final RawAnimation SULKING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sulking");
    private static final RawAnimation SEEKING_DIAMOND_ANIM = RawAnimation.begin().thenPlay("anim_hamster_seeking_diamond");
    private static final RawAnimation WANTS_TO_SEEK_DIAMOND_ANIM = RawAnimation.begin().thenPlay("anim_hamster_wants_to_seek_diamond");
    private static final RawAnimation DIAMOND_POUNCE_ANIM = RawAnimation.begin().thenPlay("anim_hamster_diamond_pounce");
    private static final RawAnimation DIAMOND_TAUNT_ANIM = RawAnimation.begin().thenPlay("anim_hamster_diamond_taunt");
    private static final RawAnimation CELEBRATE_CHASE_ANIM = RawAnimation.begin().thenPlay("anim_hamster_celebrate_chase");
    private static final RawAnimation LAYING_DOWN_HEAD_ANIM = RawAnimation.begin().thenPlay("anim_hamster_shoulder_laying_down_head");
    private static final RawAnimation LAYING_DOWN_RIGHT_SHOULDER_ANIM = RawAnimation.begin().thenPlay("anim_hamster_shoulder_laying_down_right_shoulder");
    private static final RawAnimation LAYING_DOWN_LEFT_SHOULDER_ANIM = RawAnimation.begin().thenPlay("anim_hamster_shoulder_laying_down_left_shoulder");
    @Unique
    public int interactionCooldown = 0;
    @Unique
    public int throwTicks = 0;
    @Unique
    public int wakingUpTicks = 0;
    @Unique
    private int ejectionCheckCooldown = 20;
    @Unique
    private int preAutoEatDelayTicks = 0;
    @Unique
    private int quiescentSitDurationTimer = 0;
    @Unique
    private int driftingOffTimer = 0;
    @Unique
    private int settleSleepAnimationCooldown = 0;
    @Unique
    private String activeCustomGoalDebugName = "None";
    @Unique
    public boolean isPrimedToSeekDiamonds = false;
    @Unique
    public long foundOreCooldownEndTick = 0L;
    @Unique
    public BlockPos currentOreTarget = null;
    @Unique
    private int celebrationParticleTicks = 0;
    @Unique
    private int diamondCelebrationSoundTicks = 0;
    @Unique
    private int sulkOrchestraHitDelayTicks = 0;
    @Unique
    private int sulkFailParticleTicks = 0;
    @Unique
    private int sulkEntityEffectTicks = 0;
    @Unique
    private int sulkShockedSoundDelayTicks = 0;
    @Unique
    private int diamondSparkleSoundDelayTicks = 0;
    @Unique
    public transient String particleEffectId = null;
    @Unique
    public transient String soundEffectId = null;
    @Unique
    public long stealCooldownEndTick = 0L;
    @Unique
    private int celebrationChaseTicks = 0;
    @Unique
    private boolean zoomiesIsClockwise = false;
    @Unique
    private double lastZoomiesAngle = 0.0;
    @Unique
    private int zoomiesRadiusModifier = 0;
    @Unique
    public transient float renderedSnowYOffset = 0.0f;
    @Unique
    public transient ShoulderLocation shoulderLocation = ShoulderLocation.RIGHT_SHOULDER;
    @Unique
    public int suffocationGracePeriod = 0;
    @Unique
    public transient float dynamicScaleY = 1.0f;
    @Unique
    private Optional<GlobalPos> linkedBedPos = Optional.empty();
    @Unique
    private int goToBedCooldown = 0;
    @Unique
    private int lureToBedTimer = 0;
    @Unique
    public int goToBedDelayTicks = 0;
    @Unique
    private int wakeUpFromBedDelay = 0;
    @Unique
    public int bedLeafParticleTicks = 0;
    @Unique
    private boolean bypassNextSleepDelay = false;
    @Unique
    private int napInBedDurationTimer = 0;
    @Unique
    private int thumpSoundDelayTicks = 0;
    @Unique
    private float thumpSoundVolume = 0.2f;
    @Unique
    public int pathingFailures = 0;
    @Unique
    @Nullable
    public BlockPos lastFailedTarget = null;
    @Unique
    private boolean hasPlayedIncomingSound = false;
    private final NonNullList<ItemStack> items = ImplementedInventory.create(6);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int refuseTimer = 0;
    private ItemStack lastFoodItem = ItemStack.f_41583_;
    public int customLoveTimer;
    private int tamingCooldown = 0;
    public long throwCooldownEndTick = 0L;
    private long greenBeanBuffEndTick = 0L;
    private boolean isAutoEating = false;
    private int autoEatProgressTicks = 0;
    private int autoEatCooldownTicks = 0;
    public int cleaningTimer = 0;
    private int cleaningCooldownTimer = 0;
    private final List<ScheduledTask> scheduledTasks = new ArrayList<ScheduledTask>();
    private static final Map<String, Integer> TRIGGERABLE_ANIM_DURATIONS = new HashMap<String, Integer>();

    public EntityGetter m_9236_() {
        return this.m_9236_();
    }

    private static HamsterVariant determineVariantForBiome(Holder<Biome> biomeEntry, RandomSource random) {
        String biomeName = biomeEntry.m_203543_().map(k -> k.m_135782_().toString()).orElse("unknown");
        AdorableHamsterPets.LOGGER.debug("[AHP Spawn Debug] determineVariantForBiome called for biome: {}", (Object)biomeName);
        HamsterVariant result = HamsterEntity.canSpawnBlue(biomeEntry) ? (random.m_188503_(10) < 7 ? HamsterEntity.getRandomVariant(BLUE_VARIANTS, random) : HamsterVariant.WHITE) : (HamsterEntity.canSpawnLavender(biomeEntry) ? HamsterEntity.getRandomVariant(LAVENDER_VARIANTS, random) : (HamsterEntity.canSpawnWhite(biomeEntry) ? HamsterVariant.WHITE : (HamsterEntity.canSpawnGray(biomeEntry) ? (random.m_188499_() ? HamsterEntity.getRandomVariant(LIGHT_GRAY_VARIANTS, random) : HamsterEntity.getRandomVariant(DARK_GRAY_VARIANTS, random)) : (HamsterEntity.canSpawnBlack(biomeEntry) ? HamsterVariant.BLACK : (HamsterEntity.canSpawnCream(biomeEntry) ? HamsterEntity.getRandomVariant(CREAM_VARIANTS, random) : (HamsterEntity.canSpawnChocolate(biomeEntry) ? HamsterEntity.getRandomVariant(CHOCOLATE_VARIANTS, random) : HamsterEntity.getRandomVariant(ORANGE_VARIANTS, random)))))));
        AdorableHamsterPets.LOGGER.debug("[AHP Spawn Debug] Determined variant for {} is {}", (Object)biomeName, (Object)result.name());
        return result;
    }

    private static boolean canSpawnBlue(Holder<Biome> biomeEntry) {
        return ConfigDataCache.isBlueBiome(biomeEntry);
    }

    private static boolean canSpawnLavender(Holder<Biome> biomeEntry) {
        return ConfigDataCache.isLavenderBiome(biomeEntry);
    }

    private static boolean canSpawnWhite(Holder<Biome> biomeEntry) {
        return ConfigDataCache.isWhiteBiome(biomeEntry);
    }

    private static boolean canSpawnGray(Holder<Biome> biomeEntry) {
        return ConfigDataCache.isGrayBiome(biomeEntry);
    }

    private static boolean canSpawnBlack(Holder<Biome> biomeEntry) {
        return ConfigDataCache.isBlackBiome(biomeEntry);
    }

    private static boolean canSpawnCream(Holder<Biome> biomeEntry) {
        return ConfigDataCache.isCreamBiome(biomeEntry);
    }

    private static boolean canSpawnChocolate(Holder<Biome> biomeEntry) {
        return ConfigDataCache.isChocolateBiome(biomeEntry);
    }

    private static HamsterVariant getRandomVariant(List<HamsterVariant> variantPool, RandomSource random) {
        if (variantPool == null || variantPool.isEmpty()) {
            return HamsterVariant.ORANGE;
        }
        return variantPool.get(random.m_188503_(variantPool.size()));
    }

    public static AttributeSupplier.Builder createHamsterAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)Configs.AHP.wildMaxHealth.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22281_, ((Double)Configs.AHP.meleeDamage.get()).doubleValue()).m_22268_(Attributes.f_22277_, 40.0);
    }

    @Nullable
    public static HamsterEntity createFromNbt(ServerLevel world, Player player, CompoundTag nbt) {
        Optional<HamsterShoulderData> dataOpt = HamsterShoulderData.fromNbt(nbt);
        if (dataOpt.isEmpty()) {
            AdorableHamsterPets.LOGGER.error("Failed to deserialize HamsterShoulderData from NBT: {}", (Object)nbt);
            return null;
        }
        HamsterShoulderData data = dataOpt.get();
        AdorableHamsterPets.LOGGER.debug("[HamsterEntity] createFromNbt called for player {} with data: {}", (Object)player.m_7755_().getString(), (Object)data);
        HamsterEntity hamster = (HamsterEntity)((EntityType)ModEntities.HAMSTER.get()).m_20615_((Level)world);
        if (hamster != null) {
            hamster.m_20084_(data.entityUuid());
            hamster.setVariant(data.variantId());
            hamster.m_21153_(data.health());
            hamster.m_21816_(player.m_20148_());
            hamster.setTamed(true, true);
            hamster.m_146762_(data.breedingAge());
            hamster.throwCooldownEndTick = data.throwCooldownEndTick();
            hamster.autoEatCooldownTicks = data.autoEatCooldownTicks();
            hamster.m_20088_().m_135381_(PINK_PETAL_TYPE, (Object)data.pinkPetalType());
            hamster.m_20088_().m_135381_(ANIMATION_PERSONALITY_ID, (Object)data.animationPersonalityId());
            hamster.m_20088_().m_135381_(HAMSTER_FLAGS, (Object)data.hamsterFlags());
            hamster.setHamsterFlag(2, false);
            data.customName().ifPresent(name -> {
                if (!name.isEmpty()) {
                    hamster.m_6593_((Component)Component.m_237113_((String)name));
                }
            });
            if (!data.inventoryNbt().m_128456_()) {
                ContainerHelper.m_18980_((CompoundTag)data.inventoryNbt(), hamster.items);
                hamster.updateCheekTrackers();
            }
            HamsterShoulderData.GreenBeanBuffData buffData = data.greenBeanBuffData();
            hamster.greenBeanBuffEndTick = buffData.greenBeanBuffEndTick();
            hamster.m_20088_().m_135381_(GREEN_BEAN_BUFF_DURATION, (Object)buffData.greenBeanBuffDuration());
            ListTag effectsList = buffData.activeEffectsNbt();
            for (int i = 0; i < effectsList.size(); ++i) {
                CompoundTag effectNbt = effectsList.m_128728_(i);
                MobEffectInstance effectInstance = MobEffectInstance.m_19560_((CompoundTag)effectNbt);
                if (effectInstance == null) continue;
                hamster.m_7292_(effectInstance);
            }
            HamsterShoulderData.SeekingBehaviorData seekingData = data.seekingBehaviorData();
            hamster.isPrimedToSeekDiamonds = seekingData.isPrimedToSeekDiamonds();
            hamster.foundOreCooldownEndTick = seekingData.foundOreCooldownEndTick();
            hamster.currentOreTarget = seekingData.currentOreTarget().orElse(null);
            HamsterShoulderData.WanderModeData wanderData = data.wanderModeData();
            hamster.linkedBedPos = wanderData.linkedBedPos();
            hamster.bypassNextSleepDelay = wanderData.bypassNextSleepDelay();
            hamster.isAutoEating = false;
            hamster.autoEatProgressTicks = 0;
            hamster.setHamsterFlag(8192, false);
            hamster.setDozingPhase(DozingPhase.NONE);
        }
        return hamster;
    }

    public static void spawnFromNbt(ServerLevel world, Player player, CompoundTag nbt, boolean wasDiamondAlertActive, @Nullable HamsterEntity preconfiguredHamster) {
        HamsterEntity hamster;
        HamsterEntity hamsterEntity = hamster = preconfiguredHamster != null ? preconfiguredHamster : HamsterEntity.createFromNbt(world, player, nbt);
        if (hamster == null) {
            return;
        }
        hamster.suffocationGracePeriod = 200;
        if (wasDiamondAlertActive && Configs.AHP.enableIndependentDiamondSeeking) {
            hamster.isPrimedToSeekDiamonds = true;
            AdorableHamsterPets.LOGGER.debug("[HamsterEntity {}] Primed for diamond seeking upon dismount.", (Object)hamster.m_19879_());
        }
        if (hamster.isThrown()) {
            world.m_7967_((Entity)hamster);
            AdorableHamsterPets.LOGGER.debug("[HamsterEntity] Spawned THROWN Hamster ID {} from NBT data near Player {}.", (Object)hamster.m_19879_(), (Object)player.m_7755_().getString());
        } else {
            BlockPos ultimateFallbackPos = player.m_20183_();
            HitResult hitResult = player.m_19907_(4.5, 0.0f, false);
            BlockPos initialSearchPos = hitResult.m_6662_() == HitResult.Type.BLOCK ? ((BlockHitResult)hitResult).m_82425_() : ultimateFallbackPos;
            Optional<BlockPos> safePosOpt = hamster.findSafeSpawnPosition(initialSearchPos, (Level)world, 5);
            safePosOpt.ifPresentOrElse(safePos -> {
                hamster.m_7678_((double)safePos.m_123341_() + 0.5, safePos.m_123342_(), (double)safePos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
                AdorableHamsterPets.LOGGER.debug("[HamsterDismount] Found safe spawn at {} for player {}.", safePos, (Object)player.m_7755_().getString());
            }, () -> {
                AdorableHamsterPets.LOGGER.warn("[HamsterDismount] Could not find a safe spawn position for player {}. Spawning at player's feet as a fallback.", (Object)player.m_7755_().getString());
                hamster.m_7678_((double)ultimateFallbackPos.m_123341_() + 0.5, ultimateFallbackPos.m_123342_(), (double)ultimateFallbackPos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
            });
            world.m_47205_((Entity)hamster);
            AdorableHamsterPets.LOGGER.debug("[HamsterEntity] Spawned Hamster ID {} from NBT data near Player {}.", (Object)hamster.m_19879_(), (Object)player.m_7755_().getString());
        }
    }

    public static void tryThrowFromShoulder(ServerPlayer player) {
        PlayerEntityAccessor playerAccessor = (PlayerEntityAccessor)player;
        AhpConfig config = AdorableHamsterPets.CONFIG;
        if (!config.enableHamsterThrowing) {
            player.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.throwing_disabled"), true);
            return;
        }
        if (!playerAccessor.hasAnyShoulderHamster()) {
            AdorableHamsterPets.LOGGER.warn("[HamsterThrow] Player {} tried to throw, but has no shoulder hamster.", (Object)player.m_7755_().getString());
            return;
        }
        playerAccessor.adorablehamsterpets$dismountShoulderHamster(true);
    }

    public HamsterEntity(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
        this.f_21364_ = 3;
        this.m_21441_(BlockPathTypes.WATER, 16.0f);
        this.m_21441_(BlockPathTypes.LAVA, 16.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 16.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variantId) {
        this.f_19804_.m_135381_(VARIANT, (Object)variantId);
    }

    public boolean m_5803_() {
        return this.getHamsterFlag(1);
    }

    public void setSleeping(boolean sleeping) {
        this.setHamsterFlag(1, sleeping);
    }

    public boolean m_21827_() {
        return this.getHamsterFlag(2) || this.getHamsterFlag(1) || this.getHamsterFlag(256) || this.getHamsterFlag(2048);
    }

    public boolean isCleaning() {
        return this.getHamsterFlag(8192);
    }

    public boolean isBegging() {
        return this.getHamsterFlag(4);
    }

    public void setBegging(boolean value) {
        this.setHamsterFlag(4, value);
    }

    public boolean m_27593_() {
        return this.getHamsterFlag(8);
    }

    public void setInLove(boolean value) {
        this.setHamsterFlag(8, value);
    }

    public boolean isRefusingFood() {
        return this.getHamsterFlag(16);
    }

    public void setRefusingFood(boolean value) {
        this.setHamsterFlag(16, value);
    }

    public boolean isThrown() {
        return this.getHamsterFlag(32);
    }

    public void setThrown(boolean thrown) {
        this.setHamsterFlag(32, thrown);
        if (thrown) {
            this.hasPlayedIncomingSound = false;
        }
    }

    public boolean isLeftCheekFull() {
        return this.getHamsterFlag(64);
    }

    public void setLeftCheekFull(boolean full) {
        this.setHamsterFlag(64, full);
    }

    public boolean isRightCheekFull() {
        return this.getHamsterFlag(128);
    }

    public void setRightCheekFull(boolean full) {
        this.setHamsterFlag(128, full);
    }

    public boolean isKnockedOut() {
        return this.getHamsterFlag(256);
    }

    public void setKnockedOut(boolean knocked_out) {
        this.setHamsterFlag(256, knocked_out);
    }

    public String getCurrentDeepSleepAnimationIdFromTracker() {
        return (String)this.f_19804_.m_135370_(CURRENT_DEEP_SLEEP_ANIM_ID);
    }

    public boolean isAutoEating() {
        return this.isAutoEating;
    }

    public boolean isConsideringAutoEat() {
        return this.getHamsterFlag(1024);
    }

    public DozingPhase getDozingPhase() {
        return DozingPhase.values()[(Integer)this.f_19804_.m_135370_(DOZING_PHASE)];
    }

    public void setDozingPhase(DozingPhase phase) {
        this.f_19804_.m_135381_(DOZING_PHASE, (Object)phase.ordinal());
    }

    public void setActiveCustomGoalDebugName(String name) {
        this.f_19804_.m_135381_(ACTIVE_CUSTOM_GOAL_NAME_DEBUG, (Object)name);
    }

    public String getActiveCustomGoalDebugName() {
        String goalName = (String)this.f_19804_.m_135370_(ACTIVE_CUSTOM_GOAL_NAME_DEBUG);
        return goalName;
    }

    public boolean isSulking() {
        return this.getHamsterFlag(2048);
    }

    public boolean isCelebratingDiamond() {
        return this.getHamsterFlag(4096);
    }

    public void setCelebratingDiamond(boolean celebrating) {
        this.setHamsterFlag(4096, celebrating);
        if (celebrating) {
            this.setBegging(false);
            if (!this.m_9236_().m_5776_()) {
                this.celebrationParticleTicks = 600;
                this.diamondSparkleSoundDelayTicks = 10;
            }
        } else {
            this.celebrationParticleTicks = 0;
            this.diamondSparkleSoundDelayTicks = 0;
            this.diamondCelebrationSoundTicks = 0;
        }
    }

    public void setSulking(boolean sulking) {
        this.setHamsterFlag(2048, sulking);
        if (sulking) {
            if (!this.m_9236_().m_5776_()) {
                this.sulkOrchestraHitDelayTicks = 10;
                this.sulkShockedSoundDelayTicks = 44;
                this.sulkFailParticleTicks = 600;
                this.sulkEntityEffectTicks = 600;
            }
        } else {
            this.sulkOrchestraHitDelayTicks = 0;
            this.sulkFailParticleTicks = 0;
            this.sulkEntityEffectTicks = 0;
        }
    }

    public boolean isStealingDiamond() {
        return this.getHamsterFlag(16384);
    }

    public void setStealingDiamond(boolean stealing) {
        this.setHamsterFlag(16384, stealing);
    }

    public int getStealDurationTimer() {
        return (Integer)this.f_19804_.m_135370_(STEAL_DURATION_TIMER);
    }

    public void setStealDurationTimer(int ticks) {
        this.f_19804_.m_135381_(STEAL_DURATION_TIMER, (Object)ticks);
    }

    public boolean isTaunting() {
        return this.getHamsterFlag(32768);
    }

    public void setTaunting(boolean taunting) {
        this.setHamsterFlag(32768, taunting);
    }

    public ItemStack getStolenItemStack() {
        return (ItemStack)this.f_19804_.m_135370_(STOLEN_ITEM_STACK);
    }

    public void setStolenItemStack(ItemStack stack) {
        this.f_19804_.m_135381_(STOLEN_ITEM_STACK, (Object)stack);
    }

    public boolean isCelebratingChase() {
        return this.getHamsterFlag(65536);
    }

    public void setCelebratingChase(boolean celebrating) {
        this.setHamsterFlag(65536, celebrating);
    }

    public boolean hasGreenBeanBuff() {
        return (Long)this.m_20088_().m_135370_(GREEN_BEAN_BUFF_DURATION) > this.m_9236_().m_46467_();
    }

    public boolean getZoomiesIsClockwise() {
        return this.zoomiesIsClockwise;
    }

    public double getLastZoomiesAngle() {
        return this.lastZoomiesAngle;
    }

    public void setLastZoomiesAngle(double angle) {
        this.lastZoomiesAngle = angle;
    }

    public int getZoomiesRadiusModifier() {
        return this.zoomiesRadiusModifier;
    }

    public boolean isShoulderPet() {
        return this.getHamsterFlag(131072);
    }

    public void setShoulderPet(boolean isShoulderPet) {
        this.setHamsterFlag(131072, isShoulderPet);
    }

    public boolean isWanderModeActive() {
        return this.getHamsterFlag(262144);
    }

    public void setWanderModeActive(boolean active) {
        this.setHamsterFlag(262144, active);
    }

    public Optional<GlobalPos> getLinkedBedPos() {
        return this.linkedBedPos;
    }

    public void setLinkedBedPos(Optional<GlobalPos> pos) {
        this.linkedBedPos = pos;
    }

    public int getGoToBedCooldown() {
        return this.goToBedCooldown;
    }

    public void wakeUpFromBed(boolean isManualWakeUp) {
        if (!this.m_5803_()) {
            return;
        }
        this.triggerWakeUpFromSleepAnimation(isManualWakeUp);
        this.setSleeping(false);
        this.m_21837_(false);
        if (isManualWakeUp) {
            this.goToBedCooldown = (Integer)Configs.AHP.bedWakeUpCooldown.get();
            this.setBypassNextSleepDelay(true);
        }
        this.getLinkedBedPos().ifPresent(globalPos -> {
            if (this.m_9236_().m_46472_() == globalPos.m_122640_()) {
                BlockEntity be;
                SoundEvent rustleSound;
                BlockPos bedPos = globalPos.m_122646_();
                BlockState bedState = this.m_9236_().m_8055_(bedPos);
                if (!this.m_9236_().m_5776_()) {
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ModParticles.getForVariant((WoodVariant)((Object)((Object)bedState.m_61143_(HamsterBedBlock.WOOD_VARIANT)))), (double)bedPos.m_123341_() + 0.5, (double)bedPos.m_123342_() + 0.3, (double)bedPos.m_123343_() + 0.5, 50, 0.2, 0.5, 0.2, 0.0);
                }
                if ((rustleSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BED_LEAVES_RUSTLE_SOUNDS, this.f_19796_)) != null) {
                    this.m_9236_().m_5594_(null, this.m_20183_(), rustleSound, SoundSource.NEUTRAL, 0.2f, 1.8f);
                }
                if (bedState.m_60713_((Block)ModBlocks.HAMSTER_BED.get()) && ((Boolean)bedState.m_61143_((Property)HamsterBedBlock.OCCUPIED)).booleanValue()) {
                    this.m_9236_().m_7731_(bedPos, (BlockState)bedState.m_61124_((Property)HamsterBedBlock.OCCUPIED, (Comparable)Boolean.valueOf(false)), 3);
                }
                if ((be = this.m_9236_().m_7702_(bedPos)) instanceof GeoBlockEntity) {
                    GeoBlockEntity geoBlockEntity = (GeoBlockEntity)be;
                    geoBlockEntity.triggerAnim("hamster_bed_controller", "anim_bed_becoming_unoccupied");
                }
                for (BlockPos checkPos : BlockPos.m_121940_((BlockPos)bedPos.m_7918_(-1, 0, -1), (BlockPos)bedPos.m_7918_(1, 0, 1))) {
                    if (checkPos.equals((Object)bedPos) || !this.isSafeSpawnLocation(checkPos, this.m_9236_())) continue;
                    this.m_21573_().m_26519_((double)checkPos.m_123341_() + 0.5, (double)checkPos.m_123342_(), (double)checkPos.m_123343_() + 0.5, 1.2);
                    return;
                }
            }
        });
    }

    public int getGoToBedDelayTicks() {
        return this.goToBedDelayTicks;
    }

    public void setGoToBedDelayTicks(int ticks) {
        this.goToBedDelayTicks = ticks;
    }

    public int getLureToBedTimer() {
        return this.lureToBedTimer;
    }

    public void setLureToBedTimer(int ticks) {
        this.lureToBedTimer = ticks;
    }

    public void lureToBed() {
        this.lureToBedTimer = 20;
    }

    public boolean isOnTheWayToBed() {
        return this.getHamsterFlag(524288);
    }

    public void setOnTheWayToBed(boolean onTheWay) {
        this.setHamsterFlag(524288, onTheWay);
    }

    public boolean shouldBypassNextSleepDelay() {
        return this.bypassNextSleepDelay;
    }

    public void setBypassNextSleepDelay(boolean bypass) {
        this.bypassNextSleepDelay = bypass;
    }

    public void startNapTimer() {
        if (((Boolean)Configs.AHP.circadianChaos.get()).booleanValue()) {
            int min = (Integer)Configs.AHP.minNapInBedIntervalSeconds.get() * 20;
            int max = (Integer)Configs.AHP.maxNapInBedIntervalSeconds.get() * 20;
            this.napInBedDurationTimer = this.f_19796_.m_216332_(min, max);
        }
    }

    public void triggerSettleEffects(float swishVolume, int thumpDelay, float thumpVolume) {
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)ModSounds.HAMSTER_SWISH.get(), SoundSource.NEUTRAL, swishVolume, 1.0f + this.f_19796_.m_188501_() * 0.5f);
        }
        this.thumpSoundDelayTicks = thumpDelay;
        this.thumpSoundVolume = thumpVolume;
    }

    public void triggerWakeUpFromSleepAnimation(boolean isManualWakeUp) {
        SoundEvent affectionSound;
        String currentSleepAnim;
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.triggerAnimOnServer("mainController", switch (currentSleepAnim = (String)this.m_20088_().m_135370_(CURRENT_DEEP_SLEEP_ANIM_ID)) {
            case "anim_hamster_sleep_pose2" -> "wakeup2";
            case "anim_hamster_sleep_pose3" -> "wakeup3";
            default -> "wakeup1";
        });
        this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)ModSounds.HAMSTER_SWISH.get(), SoundSource.NEUTRAL, 0.1f, 1.0f + this.f_19796_.m_188501_() * 0.5f);
        if (isManualWakeUp && (affectionSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_AFFECTION_SOUNDS, this.f_19796_)) != null) {
            this.m_9236_().m_5594_(null, this.m_20183_(), affectionSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    public boolean isPathThroughUnlinkedBed(@Nullable Path path) {
        if (path == null) {
            return false;
        }
        BlockPos linkedBed = this.getLinkedBedPos().map(GlobalPos::m_122646_).orElse(null);
        for (int i = 0; i < path.m_77398_(); ++i) {
            Node node = path.m_77375_(i);
            BlockPos pos = node.m_77288_();
            if (!this.isUnlinkedBed(pos, linkedBed) && !this.isUnlinkedBed(pos.m_7495_(), linkedBed)) continue;
            AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] Path intersects unlinked bed at {}, linkedBed={} for hamster {}", new Object[]{pos, linkedBed, this.m_20148_()});
            return true;
        }
        return false;
    }

    public boolean isUnlinkedBed(BlockPos pos, BlockPos linkedBed) {
        if (this.m_9236_().m_8055_(pos).m_60734_() instanceof HamsterBedBlock) {
            return linkedBed == null || !pos.equals((Object)linkedBed);
        }
        return false;
    }

    public void updateNavigation() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        boolean useCustomNav = Configs.AHP.avoidUnlinkedBeds;
        boolean isCurrentlyCustom = this.f_21344_ instanceof HamsterNavigation;
        if (useCustomNav && !isCurrentlyCustom) {
            this.f_21344_ = this.m_6037_(this.m_9236_());
        } else if (!useCustomNav && isCurrentlyCustom) {
            this.f_21344_ = this.m_6037_(this.m_9236_());
        }
    }

    public boolean tryShoulderMount(Player player, ItemStack stack) {
        PlayerEntityAccessor playerAccessor = (PlayerEntityAccessor)player;
        ShoulderLocation availableSlot = null;
        if (playerAccessor.getShoulderHamster(ShoulderLocation.RIGHT_SHOULDER).m_128456_()) {
            availableSlot = ShoulderLocation.RIGHT_SHOULDER;
        } else if (playerAccessor.getShoulderHamster(ShoulderLocation.LEFT_SHOULDER).m_128456_()) {
            availableSlot = ShoulderLocation.LEFT_SHOULDER;
        } else if (playerAccessor.getShoulderHamster(ShoulderLocation.HEAD).m_128456_()) {
            availableSlot = ShoulderLocation.HEAD;
        }
        if (availableSlot != null) {
            this.setWanderModeActive(false);
            HamsterShoulderData data = this.saveToShoulderData();
            playerAccessor.setShoulderHamster(availableSlot, data.toNbt());
            playerAccessor.adorablehamsterpets$getMountOrderQueue().addLast(availableSlot);
            BlockPos hamsterPosForMountSound = this.m_20183_();
            this.m_146870_();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ModCriteria.HAMSTER_ON_SHOULDER.trigger(serverPlayer);
            }
            player.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.shoulder_mount_success"), true);
            SoundEvent mountSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_SHOULDER_MOUNT_SOUNDS, this.f_19796_);
            if (mountSound != null) {
                this.m_9236_().m_5594_(null, player.m_20183_(), mountSound, SoundSource.PLAYERS, 1.0f, this.m_6100_());
            }
            if (ConfigDataCache.isLureItem(stack)) {
                SoundEvent mountLureSound = ModSounds.getDynamicItemSound(stack);
                this.m_9236_().m_5594_(null, hamsterPosForMountSound, mountLureSound, SoundSource.PLAYERS, 1.0f, 1.0f);
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack.m_41777_()), (double)hamsterPosForMountSound.m_123341_() + 0.5, (double)hamsterPosForMountSound.m_123342_() + 0.5, (double)hamsterPosForMountSound.m_123343_() + 0.5, 8, 0.25, 0.25, 0.25, 0.05);
                if (!player.m_150110_().f_35937_ && Configs.AHP.consumeLureItem) {
                    stack.m_41774_(1);
                }
            }
            return true;
        }
        player.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.shoulder_occupied"), true);
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268612_) && this.suffocationGracePeriod > 0) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_21515_() {
        return super.m_21515_() && !this.isThrown();
    }

    public boolean m_6094_() {
        if (this.isThrown() || this.m_5803_() && this.getLinkedBedPos().isPresent()) {
            return false;
        }
        return super.m_6094_();
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public void m_6596_() {
        if (!this.m_9236_().m_5776_()) {
            this.updateCheekTrackers();
        }
    }

    public Component m_5446_() {
        if (this.m_8077_()) {
            return super.m_5446_();
        }
        if (Configs.AHP.useHampterName) {
            return Component.m_237115_((String)"entity.adorablehamsterpets.hampter");
        }
        return super.m_5446_();
    }

    @Override
    public boolean m_7013_(int slot, ItemStack stack) {
        if (slot < 0 || slot >= 6) {
            return false;
        }
        return !this.isItemDisallowed(stack);
    }

    public void updateCheekTrackers() {
        LivingEntity livingEntity;
        boolean leftFull = false;
        for (int i = 0; i < 3; ++i) {
            if (((ItemStack)this.items.get(i)).m_41619_()) continue;
            leftFull = true;
            break;
        }
        boolean rightFull = false;
        for (int i = 3; i < 6; ++i) {
            if (((ItemStack)this.items.get(i)).m_41619_()) continue;
            rightFull = true;
            break;
        }
        if (this.isLeftCheekFull() != leftFull) {
            this.setLeftCheekFull(leftFull);
        }
        if (this.isRightCheekFull() != rightFull) {
            this.setRightCheekFull(rightFull);
        }
        if (!this.m_9236_().m_5776_() && (livingEntity = this.m_269323_()) instanceof ServerPlayer) {
            ServerPlayer serverPlayerOwner = (ServerPlayer)livingEntity;
            boolean allSlotsFilled = true;
            for (int i = 0; i < 6; ++i) {
                if (!((ItemStack)this.items.get(i)).m_41619_()) continue;
                allSlotsFilled = false;
                break;
            }
            if (allSlotsFilled) {
                ModCriteria.HAMSTER_POUCH_FILLED.trigger(serverPlayerOwner, this);
            }
        }
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("HamsterVariant", this.getVariant());
        if (this.m_21824_()) {
            nbt.m_128379_("Sitting", this.getHamsterFlag(2));
        }
        nbt.m_128379_("KnockedOut", this.getHamsterFlag(256));
        nbt.m_128379_("CheekPouchUnlocked", this.getHamsterFlag(512));
        nbt.m_128356_("ThrowCooldownEnd", this.throwCooldownEndTick);
        nbt.m_128356_("GreenBeanBuffDuration", ((Long)this.m_20088_().m_135370_(GREEN_BEAN_BUFF_DURATION)).longValue());
        nbt.m_128405_("AutoEatCooldown", this.autoEatCooldownTicks);
        nbt.m_128405_("EjectionCheckCooldown", this.ejectionCheckCooldown);
        nbt.m_128405_("PinkPetalType", ((Integer)this.f_19804_.m_135370_(PINK_PETAL_TYPE)).intValue());
        nbt.m_128405_("AnimationPersonalityId", ((Integer)this.f_19804_.m_135370_(ANIMATION_PERSONALITY_ID)).intValue());
        nbt.m_128405_("DozingPhase", this.getDozingPhase().ordinal());
        nbt.m_128359_("CurrentDeepSleepAnimId", (String)this.f_19804_.m_135370_(CURRENT_DEEP_SLEEP_ANIM_ID));
        nbt.m_128405_("QuiescentSitTimer", this.quiescentSitDurationTimer);
        nbt.m_128405_("DriftingOffTimer", this.driftingOffTimer);
        nbt.m_128405_("SettleSleepCooldown", this.settleSleepAnimationCooldown);
        CompoundTag inventoryWrapperNbt = new CompoundTag();
        ContainerHelper.m_18973_((CompoundTag)inventoryWrapperNbt, this.items);
        nbt.m_128365_("Inventory", (Tag)inventoryWrapperNbt);
        nbt.m_128379_("IsPrimedToSeekDiamonds", this.isPrimedToSeekDiamonds);
        nbt.m_128356_("FoundOreCooldownEndTick", this.foundOreCooldownEndTick);
        if (this.currentOreTarget != null) {
            nbt.m_128405_("OreTargetX", this.currentOreTarget.m_123341_());
            nbt.m_128405_("OreTargetY", this.currentOreTarget.m_123342_());
            nbt.m_128405_("OreTargetZ", this.currentOreTarget.m_123343_());
        }
        nbt.m_128379_("IsSulking", this.getHamsterFlag(2048));
        nbt.m_128379_("IsCelebratingDiamond", this.getHamsterFlag(4096));
        if (this.isStealingDiamond()) {
            nbt.m_128379_("IsStealingDiamond", true);
            nbt.m_128405_("StealDurationTimer", this.getStealDurationTimer());
            if (!this.getStolenItemStack().m_41619_()) {
                nbt.m_128365_("StolenItemStack", (Tag)this.getStolenItemStack().m_41739_(new CompoundTag()));
            }
        }
        nbt.m_128379_("IsWanderModeActive", this.isWanderModeActive());
        this.linkedBedPos.ifPresent(globalPos -> {
            DataResult result = GlobalPos.f_122633_.encodeStart((DynamicOps)RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)this.m_9236_().m_9598_()), globalPos);
            result.result().ifPresent(tag -> nbt.m_128365_("LinkedBedPos", tag));
        });
        nbt.m_128379_("BypassNextSleepDelay", this.bypassNextSleepDelay);
        nbt.m_128379_("HasPlayedIncomingSound", this.hasPlayedIncomingSound);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setVariant(nbt.m_128451_("HamsterVariant"));
        boolean wasSittingNbt = this.m_21824_() && nbt.m_128471_("Sitting");
        this.setSitting(wasSittingNbt, true);
        this.setHamsterFlag(256, nbt.m_128471_("KnockedOut"));
        this.setHamsterFlag(512, nbt.m_128471_("CheekPouchUnlocked"));
        this.setHamsterFlag(2048, nbt.m_128471_("IsSulking"));
        this.setHamsterFlag(4096, nbt.m_128471_("IsCelebratingDiamond"));
        this.throwCooldownEndTick = nbt.m_128454_("ThrowCooldownEnd");
        this.m_20088_().m_135381_(GREEN_BEAN_BUFF_DURATION, (Object)nbt.m_128454_("GreenBeanBuffDuration"));
        this.autoEatCooldownTicks = nbt.m_128451_("AutoEatCooldown");
        this.ejectionCheckCooldown = nbt.m_128425_("EjectionCheckCooldown", 3) ? nbt.m_128451_("EjectionCheckCooldown") : 20;
        this.f_19804_.m_135381_(PINK_PETAL_TYPE, (Object)nbt.m_128451_("PinkPetalType"));
        if (!nbt.m_128425_("AnimationPersonalityId", 3)) {
            int personalityId = this.f_19796_.m_216332_(1, 3);
            this.f_19804_.m_135381_(ANIMATION_PERSONALITY_ID, (Object)personalityId);
            AdorableHamsterPets.LOGGER.debug("[NBT READ] Hamster ID {}: NBT had no personality, assigned new ID {}", (Object)this.m_19879_(), (Object)personalityId);
        } else {
            this.f_19804_.m_135381_(ANIMATION_PERSONALITY_ID, (Object)nbt.m_128451_("AnimationPersonalityId"));
        }
        if (nbt.m_128425_("DozingPhase", 3)) {
            int phaseOrdinal = nbt.m_128451_("DozingPhase");
            if (phaseOrdinal >= 0 && phaseOrdinal < DozingPhase.values().length) {
                this.setDozingPhase(DozingPhase.values()[phaseOrdinal]);
            } else {
                this.setDozingPhase(DozingPhase.NONE);
            }
        } else {
            this.setDozingPhase(DozingPhase.NONE);
        }
        this.f_19804_.m_135381_(CURRENT_DEEP_SLEEP_ANIM_ID, (Object)nbt.m_128461_("CurrentDeepSleepAnimId"));
        this.quiescentSitDurationTimer = nbt.m_128451_("QuiescentSitTimer");
        this.driftingOffTimer = nbt.m_128451_("DriftingOffTimer");
        this.settleSleepAnimationCooldown = nbt.m_128451_("SettleSleepCooldown");
        this.items.clear();
        if (nbt.m_128425_("Inventory", 10)) {
            ContainerHelper.m_18980_((CompoundTag)nbt.m_128469_("Inventory"), this.items);
        }
        this.updateCheekTrackers();
        this.isPrimedToSeekDiamonds = nbt.m_128471_("IsPrimedToSeekDiamonds");
        this.foundOreCooldownEndTick = nbt.m_128454_("FoundOreCooldownEndTick");
        this.currentOreTarget = nbt.m_128441_("OreTargetX") && nbt.m_128441_("OreTargetY") && nbt.m_128441_("OreTargetZ") ? new BlockPos(nbt.m_128451_("OreTargetX"), nbt.m_128451_("OreTargetY"), nbt.m_128451_("OreTargetZ")) : null;
        this.setStealingDiamond(nbt.m_128471_("IsStealingDiamond"));
        if (this.isStealingDiamond()) {
            this.setStealDurationTimer(nbt.m_128451_("StealDurationTimer"));
            if (nbt.m_128425_("StolenItemStack", 10)) {
                this.setStolenItemStack(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("StolenItemStack")));
            }
        } else {
            this.setStealDurationTimer(0);
            this.setStolenItemStack(ItemStack.f_41583_);
        }
        this.setWanderModeActive(nbt.m_128471_("IsWanderModeActive"));
        this.linkedBedPos = nbt.m_128441_("LinkedBedPos") ? GlobalPos.f_122633_.parse((DynamicOps)RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)this.m_9236_().m_9598_()), (Object)nbt.m_128423_("LinkedBedPos")).result() : Optional.empty();
        this.bypassNextSleepDelay = nbt.m_128471_("BypassNextSleepDelay");
        this.hasPlayedIncomingSound = nbt.m_128471_("HasPlayedIncomingSound");
    }

    public HamsterShoulderData saveToShoulderData() {
        this.updateCheekTrackers();
        CompoundTag inventoryNbt = new CompoundTag();
        ContainerHelper.m_18973_((CompoundTag)inventoryNbt, this.items);
        ListTag effectsList = new ListTag();
        for (MobEffectInstance effectInstance : this.m_21220_()) {
            effectsList.add((Object)effectInstance.m_19555_(new CompoundTag()));
        }
        Optional<String> nameOptional = Optional.ofNullable(this.m_7770_()).map(Component::getString);
        HamsterShoulderData.SeekingBehaviorData seekingData = new HamsterShoulderData.SeekingBehaviorData(this.isPrimedToSeekDiamonds, this.foundOreCooldownEndTick, Optional.ofNullable(this.currentOreTarget));
        HamsterShoulderData.GreenBeanBuffData buffData = new HamsterShoulderData.GreenBeanBuffData(this.greenBeanBuffEndTick, (Long)this.m_20088_().m_135370_(GREEN_BEAN_BUFF_DURATION), effectsList);
        HamsterShoulderData.WanderModeData wanderData = new HamsterShoulderData.WanderModeData(this.linkedBedPos, this.bypassNextSleepDelay);
        return new HamsterShoulderData(this.m_20148_(), this.getVariant(), this.m_21223_(), inventoryNbt, this.m_146764_(), this.throwCooldownEndTick, buffData, this.autoEatCooldownTicks, nameOptional, (Integer)this.f_19804_.m_135370_(PINK_PETAL_TYPE), (Integer)this.f_19804_.m_135370_(ANIMATION_PERSONALITY_ID), seekingData, wanderData, (Integer)this.f_19804_.m_135370_(HAMSTER_FLAGS));
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public void m_19884_(double cursorX, double cursorY) {
        if (this.m_5803_()) {
            return;
        }
        super.m_19884_(cursorX, cursorY);
    }

    public Optional<BlockPos> findSafeSpawnPosition(BlockPos initialTarget, Level world, int searchRadius) {
        return this.findSafeSpawnPosition(initialTarget, world, searchRadius, Collections.emptySet());
    }

    public Optional<BlockPos> findSafeSpawnPosition(BlockPos initialTarget, Level world, int searchRadius, Set<BlockPos> occupiedPositions) {
        if (this.isSafeSpawnLocation(initialTarget, world) && !occupiedPositions.contains(initialTarget)) {
            return Optional.of(initialTarget);
        }
        for (int i = 1; i <= 3; ++i) {
            BlockPos abovePos = initialTarget.m_6630_(i);
            if (!this.isSafeSpawnLocation(abovePos, world) || occupiedPositions.contains(abovePos)) continue;
            return Optional.of(abovePos);
        }
        for (int r = 1; r <= searchRadius; ++r) {
            for (int i = -r; i <= r; ++i) {
                for (int j = -r; j <= r; ++j) {
                    BlockPos checkPos;
                    if (Math.abs(i) != r && Math.abs(j) != r || !this.isSafeSpawnLocation(checkPos = initialTarget.m_7918_(i, 0, j), world) || occupiedPositions.contains(checkPos)) continue;
                    return Optional.of(checkPos);
                }
            }
        }
        return Optional.empty();
    }

    public void m_21839_(boolean sitting) {
        this.setSitting(sitting, true);
    }

    public void setSitting(boolean sitting, boolean suppressSound) {
        boolean wasSitting = this.m_21827_();
        if (sitting && !wasSitting) {
            int personalityId = (Integer)this.f_19804_.m_135370_(ANIMATION_PERSONALITY_ID);
            String animToTrigger = switch (personalityId) {
                case 2 -> "sit2";
                case 3 -> "sit3";
                default -> "sit1";
            };
            this.triggerAnimOnServer("mainController", animToTrigger);
            this.triggerSettleEffects(0.12f, 7, 0.2f);
        } else if (!sitting && wasSitting) {
            if (!this.m_9236_().m_5776_()) {
                this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)ModSounds.HAMSTER_SWISH.get(), SoundSource.NEUTRAL, 0.1f, 1.0f + this.f_19796_.m_188501_() * 0.5f);
            }
            int personalityId = (Integer)this.f_19804_.m_135370_(ANIMATION_PERSONALITY_ID);
            String animToTrigger = switch (personalityId) {
                case 2 -> "standup2";
                case 3 -> "standup3";
                default -> "standup1";
            };
            this.triggerAnimOnServer("mainController", animToTrigger);
        }
        if (!sitting && this.m_21824_() && this.getDozingPhase() != DozingPhase.NONE) {
            this.resetSleepSequence("Player commanded hamster to stand up.");
        }
        this.setHamsterFlag(2, sitting);
        this.m_21837_(sitting);
        if (sitting) {
            this.cleaningTimer = 0;
        } else {
            this.quiescentSitDurationTimer = 0;
            this.cleaningTimer = 0;
            if (this.getHamsterFlag(8192)) {
                this.setHamsterFlag(8192, false);
            }
        }
    }

    public boolean m_217066_(LivingEntity entity) {
        AABB hamsterBox = this.m_20191_();
        AABB attackBox = hamsterBox.m_82377_(0.7, 0.0, 0.7);
        boolean intersects = attackBox.m_82381_(entity.m_20191_());
        return intersects;
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        TraceableEntity ownableFallback;
        Entity fallbackOwnerEntity;
        UUID ownerUuid = owner.m_20148_();
        AdorableHamsterPets.LOGGER.trace("[canAttackWithOwner] Hamster: {}, Target: {}, Owner: {}", new Object[]{this.m_7755_().getString(), target.m_7755_().getString(), owner.m_7755_().getString()});
        if (target == this || target == owner) {
            return false;
        }
        if (target instanceof Player && target.m_20148_().equals(ownerUuid)) {
            return false;
        }
        if (target instanceof Creeper || target instanceof ArmorStand) {
            return false;
        }
        if (target instanceof TamableAnimal) {
            TamableAnimal tameablePet = (TamableAnimal)target;
            UUID petOwnerUuid = tameablePet.m_21805_();
            if (petOwnerUuid != null && petOwnerUuid.equals(ownerUuid)) {
                AdorableHamsterPets.LOGGER.trace("[canAttackWithOwner] Target is a TameableEntity owned by the same player. Preventing attack.");
                return false;
            }
        } else if (target instanceof AbstractHorse) {
            AbstractHorse horsePet = (AbstractHorse)target;
            LivingEntity horseOwnerEntity = horsePet.m_269323_();
            if (horseOwnerEntity != null && horseOwnerEntity.m_20148_().equals(ownerUuid)) {
                AdorableHamsterPets.LOGGER.trace("[canAttackWithOwner] Target is an AbstractHorseEntity owned by the same player. Preventing attack.");
                return false;
            }
        } else if (target instanceof TraceableEntity && (fallbackOwnerEntity = (ownableFallback = (TraceableEntity)target).m_19749_()) != null && fallbackOwnerEntity.m_20148_().equals(ownerUuid)) {
            AdorableHamsterPets.LOGGER.trace("[canAttackWithOwner] Target is an Ownable (fallback) owned by the same player. Preventing attack.");
            return false;
        }
        return true;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Level world = this.m_9236_();
        AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Interaction start. Player: {}, Hand: {}, Item: {}", new Object[]{this.m_19879_(), world.m_46467_(), player.m_7755_().getString(), hand, stack.m_41720_()});
        if (this.interactionCooldown > 0) {
            AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Interaction cooldown active ({} ticks left). Passing.", new Object[]{this.m_19879_(), world.m_46467_(), this.interactionCooldown});
            return InteractionResult.PASS;
        }
        if (player.m_6144_() && stack.m_150930_((Item)ModItems.HAMSTER_GUIDE_BOOK.get())) {
            if (!world.f_46443_) {
                boolean newSetting;
                AhpConfig currentConfig = AdorableHamsterPets.CONFIG;
                boolean currentSetting = currentConfig.enableJadeHamsterDebugInfo;
                currentConfig.enableJadeHamsterDebugInfo = newSetting = !currentSetting;
                currentConfig.save();
                MutableComponent message = Component.m_237115_((String)(newSetting ? "message.adorablehamsterpets.debug_overlay_enabled" : "message.adorablehamsterpets.debug_overlay_disabled")).m_130940_(newSetting ? ChatFormatting.GREEN : ChatFormatting.RED);
                player.m_5661_((Component)message, true);
                AdorableHamsterPets.LOGGER.info("Player {} toggled Jade Hamster Debug Info via Guide Book to: {} for hamster {}", new Object[]{player.m_7755_().getString(), newSetting, this.m_19879_()});
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        if (this.m_21824_() && this.m_21830_((LivingEntity)player) && stack.m_41720_() instanceof HamsterBedItem) {
            if (!world.f_46443_) {
                UUID linkedUuid = null;
                if (stack.m_41782_() && stack.m_41783_().m_128441_("LinkedHamsterUuid")) {
                    linkedUuid = stack.m_41783_().m_128342_("LinkedHamsterUuid");
                }
                Object nameToSet = this.m_8077_() ? this.m_7755_() : this.m_5446_().m_6881_().m_130946_(" " + this.m_19879_());
                String nameJson = Component.Serializer.m_130703_((Component)nameToSet);
                if (linkedUuid == null) {
                    ItemStack newStack = stack.m_41777_();
                    CompoundTag nbt = newStack.m_41784_();
                    nbt.m_128362_("LinkedHamsterUuid", this.m_20148_());
                    nbt.m_128359_("LinkedHamsterName", nameJson);
                    nbt.m_128359_("WanderDistance", ((WanderDistance)((Object)Configs.AHP.defaultWanderDistance.get())).m_7912_());
                    player.m_21008_(hand, newStack);
                    world.m_5594_(null, this.m_20183_(), SoundEvents.f_244240_, SoundSource.PLAYERS, 1.0f, 1.2f);
                    ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123748_, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 10, 0.5, 0.5, 0.5, 0.0);
                    player.m_5661_((Component)Component.m_237110_((String)"message.adorablehamsterpets.bed_linked", (Object[])new Object[]{this.m_7755_()}), true);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        ModCriteria.HAMSTER_BED_LINKED.trigger(serverPlayer);
                    }
                } else if (linkedUuid.equals(this.m_20148_())) {
                    WanderDistance currentDistance = (WanderDistance)((Object)Configs.AHP.defaultWanderDistance.get());
                    CompoundTag stackNbt = stack.m_41784_();
                    if (stackNbt.m_128441_("WanderDistance")) {
                        try {
                            currentDistance = WanderDistance.valueOf(stackNbt.m_128461_("WanderDistance"));
                        }
                        catch (IllegalArgumentException serverPlayer) {
                            // empty catch block
                        }
                    }
                    WanderDistance[] values = WanderDistance.values();
                    WanderDistance nextDistance = values[(currentDistance.ordinal() + 1) % values.length];
                    stackNbt.m_128359_("WanderDistance", nextDistance.m_7912_());
                    player.m_5661_((Component)Component.m_237110_((String)"message.adorablehamsterpets.wander_distance_set", (Object[])new Object[]{this.m_7755_(), nextDistance.m_7912_()}), true);
                    world.m_5594_(null, this.m_20183_(), (SoundEvent)SoundEvents.f_12490_.m_203334_(), SoundSource.PLAYERS, 0.5f, 1.0f);
                } else {
                    ItemStack newStack = stack.m_41777_();
                    CompoundTag nbt = newStack.m_41784_();
                    nbt.m_128362_("LinkedHamsterUuid", this.m_20148_());
                    nbt.m_128359_("LinkedHamsterName", nameJson);
                    nbt.m_128359_("WanderDistance", ((WanderDistance)((Object)Configs.AHP.defaultWanderDistance.get())).m_7912_());
                    player.m_21008_(hand, newStack);
                    world.m_5594_(null, this.m_20183_(), SoundEvents.f_244240_, SoundSource.PLAYERS, 1.0f, 1.2f);
                    ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123748_, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 10, 0.5, 0.5, 0.5, 0.0);
                    player.m_5661_((Component)Component.m_237110_((String)"message.adorablehamsterpets.bed_linked", (Object[])new Object[]{this.m_7755_()}), true);
                }
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        if (!this.m_21824_()) {
            AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Hamster not tamed. Checking for taming attempt.", (Object)this.m_19879_(), (Object)world.m_46467_());
            if (player.m_6144_() && ConfigDataCache.isTamingFood(stack)) {
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Taming attempt detected.", (Object)this.m_19879_(), (Object)world.m_46467_());
                if (!world.f_46443_) {
                    this.tryTame(player, stack);
                }
                return InteractionResult.m_19078_((boolean)world.m_5776_());
            }
            AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Not a taming attempt. Calling super.interactMob for untamed.", (Object)this.m_19879_(), (Object)world.m_46467_());
            return super.m_6071_(player, hand);
        }
        if (this.m_21830_((LivingEntity)player)) {
            boolean isPotentialFood;
            AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Player is owner. Processing owner interactions.", (Object)this.m_19879_(), (Object)world.m_46467_());
            boolean isSneaking = player.m_6144_();
            PlayerEntityAccessor playerAccessor = (PlayerEntityAccessor)player;
            if (this.m_5803_()) {
                if (!world.m_5776_()) {
                    this.wakeUpFromBed(true);
                }
                return InteractionResult.m_19078_((boolean)world.m_5776_());
            }
            if (this.getDozingPhase() != DozingPhase.NONE) {
                this.resetSleepSequence("Player interacted with hamster.");
            }
            if (this.isStealingDiamond() && this.m_21830_((LivingEntity)player)) {
                AdorableHamsterPets.LOGGER.trace("[InteractMob-{}] Passed 'isStealingDiamond' check.", (Object)this.m_19879_());
                if (!world.f_46443_) {
                    ItemStack retrievedStack = this.getStolenItemStack().m_41777_();
                    player.m_150109_().m_150079_(this.getStolenItemStack().m_41777_());
                    this.setStolenItemStack(ItemStack.f_41583_);
                    this.setStealDurationTimer(0);
                    this.setStealingDiamond(false);
                    this.setCelebratingChase(true);
                    this.celebrationChaseTicks = 30;
                    this.triggerAnimOnServer("mainController", "anim_hamster_celebrate_chase");
                    world.m_5594_(null, this.m_20183_(), ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_AFFECTION_SOUNDS, this.f_19796_), SoundSource.NEUTRAL, 1.0f, this.m_6100_());
                    if (!retrievedStack.m_41619_()) {
                        SoundEvent pounceSound = ModSounds.getDynamicItemSound(retrievedStack);
                        float volume = pounceSound == SoundEvents.f_11912_ ? 0.35f : 1.0f;
                        world.m_5594_(null, this.m_20183_(), pounceSound, SoundSource.NEUTRAL, volume, 1.7f);
                    }
                    AdorableHamsterPets.LOGGER.trace("[InteractMob-{}] Diamond returned to player and goal stopped.", (Object)this.m_19879_());
                }
                return InteractionResult.m_19078_((boolean)world.m_5776_());
            }
            if (this.isKnockedOut()) {
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Hamster is knocked out. Waking up.", (Object)this.m_19879_(), (Object)world.m_46467_());
                if (!world.m_5776_()) {
                    SoundEvent wakeUpSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_WAKE_UP_SOUNDS, this.f_19796_);
                    if (wakeUpSound != null) {
                        world.m_5594_(null, this.m_20183_(), wakeUpSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                    this.setKnockedOut(false);
                    this.setSitting(false, true);
                    this.triggerAnimOnServer("mainController", "wakeup_from_ko");
                }
                return InteractionResult.m_19078_((boolean)world.m_5776_());
            }
            if (this.isCelebratingDiamond()) {
                if (!world.m_5776_()) {
                    this.setCelebratingDiamond(false);
                    this.setSitting(false, true);
                    SoundEvent affectionSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_AFFECTION_SOUNDS, this.f_19796_);
                    if (affectionSound != null) {
                        world.m_5594_(null, this.m_20183_(), affectionSound, SoundSource.NEUTRAL, 1.0f, this.m_6100_());
                    } else {
                        world.m_5594_(null, this.m_20183_(), SoundEvents.f_12019_, SoundSource.NEUTRAL, 0.5f, 1.5f);
                    }
                }
                return InteractionResult.m_19078_((boolean)world.m_5776_());
            }
            if (this.isSulking()) {
                if (!world.m_5776_()) {
                    this.setSulking(false);
                    this.setSitting(false, true);
                    SoundEvent affectionSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_AFFECTION_SOUNDS, this.f_19796_);
                    if (affectionSound != null) {
                        world.m_5594_(null, this.m_20183_(), affectionSound, SoundSource.NEUTRAL, 1.0f, this.m_6100_());
                    } else {
                        world.m_5594_(null, this.m_20183_(), SoundEvents.f_11754_, SoundSource.NEUTRAL, 0.5f, 1.5f);
                    }
                }
                return InteractionResult.m_19078_((boolean)world.m_5776_());
            }
            if (stack.m_150930_(Items.f_271209_) && !player.m_6144_()) {
                if (!world.f_46443_) {
                    int currentPetalType = (Integer)this.f_19804_.m_135370_(PINK_PETAL_TYPE);
                    int nextPetalType = currentPetalType % 3 + 1;
                    this.f_19804_.m_135381_(PINK_PETAL_TYPE, (Object)nextPetalType);
                    world.m_5594_(null, this.m_20183_(), SoundEvents.f_271130_, SoundSource.PLAYERS, 0.7f, 1.0f + this.f_19796_.m_188501_() * 0.2f);
                    if (world instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)world;
                        serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_175832_, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * 0.75, this.m_20189_(), 7, (double)(this.m_20205_() / 2.0f), (double)(this.m_20206_() / 2.0f), (double)(this.m_20205_() / 2.0f), 0.0);
                    }
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                    AdorableHamsterPets.LOGGER.trace("[InteractMob {}] Cycled/Applied pink petal to type {}.", (Object)this.m_19879_(), (Object)nextPetalType);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        ModCriteria.APPLIED_PINK_PETAL.trigger(serverPlayer, this);
                    }
                }
                return InteractionResult.m_19078_((boolean)world.m_5776_());
            }
            if (stack.m_150930_(Items.f_42574_) && !player.m_6144_() && (Integer)this.f_19804_.m_135370_(PINK_PETAL_TYPE) > 0) {
                if (!world.f_46443_) {
                    this.f_19804_.m_135381_(PINK_PETAL_TYPE, (Object)0);
                    world.m_5594_(null, this.m_20183_(), SoundEvents.f_12344_, SoundSource.PLAYERS, 0.9f, 1.0f + this.f_19796_.m_188501_() * 0.1f);
                    if (world instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)world;
                        serverWorld.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_271209_)), this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * 0.5, this.m_20189_(), 5, (double)(this.m_20205_() / 2.0f), (double)(this.m_20206_() / 2.0f), (double)(this.m_20205_() / 2.0f), 0.05);
                    }
                    Containers.m_18992_((Level)world, (double)this.m_20185_(), (double)(this.m_20186_() + 0.5), (double)this.m_20189_(), (ItemStack)new ItemStack((ItemLike)Items.f_271209_, 1));
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41622_(1, (LivingEntity)player, p -> p.m_21166_(hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND));
                    }
                    AdorableHamsterPets.LOGGER.trace("[InteractMob {}] Removed pink petals with shears.", (Object)this.m_19879_());
                }
                return InteractionResult.m_19078_((boolean)world.m_5776_());
            }
            boolean isUsingItem = ConfigDataCache.isLureItem(stack);
            if (ConfigDataCache.isLureItem(stack)) {
                if (!world.f_46443_) {
                    this.tryShoulderMount(player, stack);
                } else {
                    player.m_6674_(hand);
                }
                return InteractionResult.CONSUME;
            }
            if (!world.m_5776_() && isSneaking) {
                if (this.getHamsterFlag(512) || !AdorableHamsterPets.CONFIG.requireFoodMixToUnlockCheeks) {
                    MenuRegistry.openExtendedMenu((ServerPlayer)((ServerPlayer)player), (ExtendedMenuProvider)new HamsterScreenHandlerFactory(this));
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.cheek_pouch_locked").m_130940_(ChatFormatting.WHITE), true);
                }
                return InteractionResult.CONSUME;
            }
            boolean bl = isPotentialFood = ConfigDataCache.isStandardFood(stack) || ConfigDataCache.isBuffFood(stack) || ConfigDataCache.isPouchUnlockFood(stack);
            if (!world.m_5776_() && !isSneaking && isPotentialFood) {
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Owner not sneaking, holding potential food. Checking refusal.", (Object)this.m_19879_(), (Object)world.m_46467_());
                if (this.checkRepeatFoodRefusal(stack, player)) {
                    AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Food refused. Consuming interaction.", (Object)this.m_19879_(), (Object)world.m_46467_());
                    return InteractionResult.CONSUME;
                }
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Attempting feeding via tryFeedingAsTamed.", (Object)this.m_19879_(), (Object)world.m_46467_());
                boolean feedingOccurred = this.tryFeedingAsTamed(player, stack);
                if (feedingOccurred) {
                    AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] tryFeedingAsTamed returned true. Setting last food, decrementing stack.", (Object)this.m_19879_(), (Object)world.m_46467_());
                    this.lastFoodItem = stack.m_41777_();
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                    return InteractionResult.CONSUME;
                }
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] tryFeedingAsTamed returned false. Passing to vanilla/sitting.", (Object)this.m_19879_(), (Object)world.m_46467_());
            }
            if (!(isSneaking || isPotentialFood || ConfigDataCache.isLureItem(stack) || stack.m_150930_(Items.f_271209_))) {
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Not sneaking or holding handled food/petals. Calling super.interactMob.", (Object)this.m_19879_(), (Object)world.m_46467_());
                InteractionResult vanillaResult = super.m_6071_(player, hand);
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] super.interactMob returned: {}", new Object[]{this.m_19879_(), world.m_46467_(), vanillaResult});
                if (vanillaResult.m_19077_()) {
                    return vanillaResult;
                }
            }
            if (!world.m_5776_() && !isSneaking) {
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Fallback: Toggling sitting state.", (Object)this.m_19879_(), (Object)world.m_46467_());
                this.m_21839_(!this.m_21827_());
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                return InteractionResult.CONSUME_PARTIAL;
            }
            AdorableHamsterPets.LOGGER.debug("[InteractMob {} Tick {}] Reached end of owner logic. Returning client-side success/pass.", (Object)this.m_19879_(), (Object)world.m_46467_());
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        AdorableHamsterPets.LOGGER.debug("[InteractMob {} Tick {}] Player is not owner. Calling super.interactMob.", (Object)this.m_19879_(), (Object)world.m_46467_());
        return super.m_6071_(player, hand);
    }

    public void m_7105_(boolean tamed) {
        this.setTamed(tamed, true);
    }

    public void setTamed(boolean tamed, boolean updateAttributes) {
        super.m_7105_(tamed);
        if (updateAttributes) {
            if (tamed) {
                this.m_21051_(Attributes.f_22276_).m_22100_(((Double)Configs.AHP.tamedMaxHealth.get()).doubleValue());
                this.m_21153_(this.m_21233_());
                this.m_21051_(Attributes.f_22281_).m_22100_(((Double)Configs.AHP.meleeDamage.get()).doubleValue());
            } else {
                this.m_21051_(Attributes.f_22276_).m_22100_(((Double)Configs.AHP.wildMaxHealth.get()).doubleValue());
                this.m_21051_(Attributes.f_22281_).m_22100_(((Double)Configs.AHP.meleeDamage.get()).doubleValue());
            }
        }
    }

    public boolean isInCustomLove() {
        return this.customLoveTimer > 0;
    }

    public void setCustomInLove(Player player) {
        this.customLoveTimer = 600;
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_7605_((Entity)this, (byte)18);
        }
    }

    public void m_6863_(boolean baby) {
        this.m_146762_(baby ? -24000 : 0);
    }

    public void m_21837_(boolean inSittingPose) {
        super.m_21837_(inSittingPose);
        if (this.getHamsterFlag(2) != inSittingPose) {
            this.setHamsterFlag(2, inSittingPose);
        }
        if (!inSittingPose) {
            if (this.m_5803_()) {
                this.setSleeping(false);
            }
            if (this.isKnockedOut()) {
                this.setKnockedOut(false);
            }
        }
    }

    public HamsterVariant getVariantEnum() {
        return HamsterVariant.byId(this.getVariant());
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob mate) {
        HamsterVariant babyFinalVariant;
        boolean motherHasOverlay;
        HamsterEntity baby = (HamsterEntity)((EntityType)ModEntities.HAMSTER.get()).m_20615_((Level)world);
        if (baby == null) {
            return null;
        }
        if (!(mate instanceof HamsterEntity)) {
            int randomVariantId = this.f_19796_.m_188503_(HamsterVariant.values().length);
            baby.setVariant(randomVariantId);
            baby.m_6863_(true);
            AdorableHamsterPets.LOGGER.warn("Hamster breeding attempted with non-hamster mate. Assigning random variant to baby.");
            return baby;
        }
        HamsterEntity mother = (HamsterEntity)mate;
        HamsterEntity father = this;
        HamsterVariant parentProvidingBaseColor = this.f_19796_.m_188499_() ? father.getVariantEnum() : mother.getVariantEnum();
        HamsterVariant babyBaseColorEnum = parentProvidingBaseColor.getBaseVariant();
        @Nullable String fatherOverlayName = father.getVariantEnum().getOverlayTextureName();
        @Nullable String motherOverlayName = mother.getVariantEnum().getOverlayTextureName();
        List<HamsterVariant> allVariantsForBabyBase = HamsterVariant.getVariantsForBase(babyBaseColorEnum);
        ArrayList<@Nullable String> eligibleOverlayNames = new ArrayList<String>();
        for (HamsterVariant variant : allVariantsForBabyBase) {
            boolean matchesMother;
            @Nullable String candidateOverlay = variant.getOverlayTextureName();
            boolean matchesFather = fatherOverlayName != null && fatherOverlayName.equals(candidateOverlay);
            boolean bl = matchesMother = motherOverlayName != null && motherOverlayName.equals(candidateOverlay);
            if (matchesFather || matchesMother) continue;
            eligibleOverlayNames.add(candidateOverlay);
        }
        ArrayList<@Nullable String> finalSelectableOverlayNames = new ArrayList<String>();
        boolean fatherHasOverlay = fatherOverlayName != null;
        boolean bl = motherHasOverlay = motherOverlayName != null;
        if (fatherHasOverlay && motherHasOverlay) {
            for (String overlayName : eligibleOverlayNames) {
                if (overlayName == null) continue;
                finalSelectableOverlayNames.add(overlayName);
            }
            if (finalSelectableOverlayNames.isEmpty() && babyBaseColorEnum != HamsterVariant.WHITE) {
                for (HamsterVariant variant : allVariantsForBabyBase) {
                    if (variant.getOverlayTextureName() == null) continue;
                    finalSelectableOverlayNames.add(variant.getOverlayTextureName());
                }
            }
        } else {
            finalSelectableOverlayNames.addAll(eligibleOverlayNames);
        }
        if (!finalSelectableOverlayNames.isEmpty()) {
            @Nullable String chosenOverlayName = (String)finalSelectableOverlayNames.get(this.f_19796_.m_188503_(finalSelectableOverlayNames.size()));
            babyFinalVariant = HamsterVariant.getVariantByBaseAndOverlay(babyBaseColorEnum, chosenOverlayName);
        } else {
            babyFinalVariant = babyBaseColorEnum;
        }
        baby.setVariant(babyFinalVariant.getId());
        UUID ownerUUID = father.m_21805_();
        if (ownerUUID != null) {
            baby.m_21816_(ownerUUID);
            baby.setTamed(true, true);
        }
        baby.m_6863_(true);
        return baby;
    }

    public boolean m_6898_(ItemStack stack) {
        return ConfigDataCache.isStandardFood(stack);
    }

    public void m_8119_() {
        Level world;
        int chanceDenominator;
        if (!this.m_9236_().m_5776_()) {
            long currentTime = this.m_9236_().m_46467_();
            this.scheduledTasks.removeIf(task -> {
                if (currentTime >= task.executionTick()) {
                    task.action().run();
                    return true;
                }
                return false;
            });
        }
        if (this.interactionCooldown > 0) {
            --this.interactionCooldown;
        }
        if (this.suffocationGracePeriod > 0) {
            --this.suffocationGracePeriod;
        }
        if (this.wakingUpTicks > 0) {
            --this.wakingUpTicks;
        }
        if (this.autoEatCooldownTicks > 0) {
            --this.autoEatCooldownTicks;
        }
        if (this.autoEatProgressTicks > 0) {
            --this.autoEatProgressTicks;
        }
        if (this.ejectionCheckCooldown > 0) {
            --this.ejectionCheckCooldown;
        }
        if (this.preAutoEatDelayTicks > 0) {
            --this.preAutoEatDelayTicks;
        }
        if (this.celebrationParticleTicks > 0) {
            --this.celebrationParticleTicks;
        }
        if (this.celebrationParticleTicks > 0) {
            --this.celebrationParticleTicks;
        }
        if (this.diamondCelebrationSoundTicks > 0) {
            --this.diamondCelebrationSoundTicks;
        }
        if (this.sulkOrchestraHitDelayTicks > 0) {
            --this.sulkOrchestraHitDelayTicks;
        }
        if (this.sulkFailParticleTicks > 0) {
            --this.sulkFailParticleTicks;
        }
        if (this.sulkEntityEffectTicks > 0) {
            --this.sulkEntityEffectTicks;
        }
        if (this.sulkShockedSoundDelayTicks > 0) {
            --this.sulkShockedSoundDelayTicks;
        }
        if (this.diamondSparkleSoundDelayTicks > 0) {
            --this.diamondSparkleSoundDelayTicks;
        }
        if (this.goToBedCooldown > 0) {
            --this.goToBedCooldown;
        }
        if (this.lureToBedTimer > 0) {
            --this.lureToBedTimer;
        }
        if (this.wakeUpFromBedDelay > 0) {
            --this.wakeUpFromBedDelay;
        }
        if (this.napInBedDurationTimer > 0) {
            --this.napInBedDurationTimer;
        }
        if (this.thumpSoundDelayTicks > 0) {
            --this.thumpSoundDelayTicks;
            if (this.thumpSoundDelayTicks == 0 && !this.m_9236_().m_5776_()) {
                this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)ModSounds.HAMSTER_THUMP.get(), SoundSource.NEUTRAL, this.thumpSoundVolume, 1.5f);
            }
        }
        if (this.bedLeafParticleTicks > 0) {
            if (!this.m_9236_().m_5776_()) {
                int particleCount = 0;
                if (this.bedLeafParticleTicks == 3) {
                    particleCount = 15;
                } else if (this.bedLeafParticleTicks == 2) {
                    particleCount = 10;
                } else if (this.bedLeafParticleTicks == 1) {
                    particleCount = 5;
                }
                if (particleCount > 0 && this.getLinkedBedPos().isPresent()) {
                    BlockPos bedPos = this.getLinkedBedPos().get().m_122646_();
                    BlockState bedState = this.m_9236_().m_8055_(bedPos);
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ModParticles.getForVariant((WoodVariant)((Object)bedState.m_61143_(HamsterBedBlock.WOOD_VARIANT))), (double)bedPos.m_123341_() + 0.5, (double)bedPos.m_123342_() + 0.3, (double)bedPos.m_123343_() + 0.5, particleCount, 0.2, 0.3, 0.2, 1.0);
                }
            }
            --this.bedLeafParticleTicks;
        }
        if (this.cleaningCooldownTimer > 0) {
            --this.cleaningCooldownTimer;
        }
        if (this.cleaningTimer > 0) {
            --this.cleaningTimer;
            if (this.cleaningTimer == 0) {
                if (!this.m_9236_().f_46443_) {
                    this.setHamsterFlag(8192, false);
                }
                this.cleaningCooldownTimer = 200;
            }
        }
        if (this.isKnockedOut() && this.getHamsterFlag(8192)) {
            this.setHamsterFlag(8192, false);
            this.cleaningTimer = 0;
        }
        DozingPhase currentPhase = this.getDozingPhase();
        if (!this.m_9236_().m_5776_() && this.m_21824_() && this.m_21827_() && !this.getHamsterFlag(8192) && this.cleaningCooldownTimer <= 0 && (currentPhase == DozingPhase.NONE || currentPhase == DozingPhase.QUIESCENT_SITTING) && (chanceDenominator = ((Integer)Configs.AHP.cleaningChanceDenominator.get()).intValue()) > 0 && this.f_19796_.m_188503_(chanceDenominator) == 0) {
            this.cleaningTimer = this.f_19796_.m_216332_(30, 60);
            this.setHamsterFlag(8192, true);
        }
        if (this.isCelebratingChase()) {
            if (this.celebrationChaseTicks > 0) {
                if (this.m_269323_() != null) {
                    this.m_21563_().m_24960_((Entity)this.m_269323_(), 25.0f, 25.0f);
                }
                --this.celebrationChaseTicks;
            } else {
                this.setCelebratingChase(false);
            }
        }
        if (this.isThrown()) {
            ++this.throwTicks;
            Vec3 currentPos = this.m_20182_();
            Vec3 currentVel = this.m_20184_();
            Vec3 nextPos = currentPos.m_82549_(currentVel);
            Level world2 = this.m_9236_();
            BlockHitResult blockHit = world2.m_45547_(new ClipContext(currentPos, nextPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            boolean stopped = false;
            if (blockHit.m_6662_() == HitResult.Type.BLOCK) {
                BlockHitResult blockHitResult = blockHit;
                BlockPos adjacentPos = blockHitResult.m_82425_().m_121945_(blockHitResult.m_82434_());
                this.m_6034_((double)adjacentPos.m_123341_() + 0.5, adjacentPos.m_123342_(), (double)adjacentPos.m_123343_() + 0.5);
                this.m_20256_(currentVel.m_82542_(0.6, 0.0, 0.6));
                this.setThrown(false);
                this.m_5496_(SoundEvents.f_11916_, 1.0f, 1.2f);
                this.broadcastDistantImpact(SoundEvents.f_11916_, 1.2f);
                this.setKnockedOut(true);
                this.m_21837_(true);
                if (!world2.m_5776_()) {
                    this.triggerAnimOnServer("mainController", "crash");
                }
                stopped = true;
            } else {
                EntityHitResult entityHit = ProjectileUtil.m_37304_((Level)world2, (Entity)this, (Vec3)currentPos, (Vec3)nextPos, (AABB)this.m_20191_().m_82369_(currentVel).m_82400_(1.0), this::canHitEntity);
                if (entityHit != null && entityHit.m_82443_() != null) {
                    Entity hitEntity = entityHit.m_82443_();
                    BlockPos impactPos = hitEntity.m_20183_();
                    boolean playEffects = false;
                    if (hitEntity instanceof ArmorStand) {
                        playEffects = true;
                    } else if (hitEntity instanceof LivingEntity) {
                        float damageAmount;
                        LivingEntity livingHit = (LivingEntity)hitEntity;
                        DamageSource damageSource = this.m_269291_().m_269333_((LivingEntity)this);
                        boolean damaged = livingHit.m_6469_(damageSource, damageAmount = ((Double)Configs.AHP.hamsterThrowDamage.get()).floatValue());
                        if (damaged) {
                            livingHit.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 20, 0, false, false, false));
                            playEffects = true;
                        }
                    } else {
                        playEffects = true;
                    }
                    if (playEffects) {
                        world2.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.HAMSTER_IMPACT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                        this.broadcastDistantImpact((SoundEvent)ModSounds.HAMSTER_IMPACT.get(), 1.0f);
                        if (!world2.m_5776_()) {
                            ((ServerLevel)world2).m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() / 2.0, this.m_20189_(), 50, 0.4, 0.4, 0.4, 0.1);
                        }
                    }
                    Optional<BlockPos> safePosOpt = this.findSafeSpawnPosition(impactPos, world2, 2);
                    safePosOpt.ifPresentOrElse(safePos -> this.m_6034_((double)safePos.m_123341_() + 0.5, safePos.m_123342_(), (double)safePos.m_123343_() + 0.5), () -> {
                        AdorableHamsterPets.LOGGER.warn("[HamsterThrow] Could not find safe landing spot after hitting entity. Using entity's position {} as fallback.", (Object)impactPos);
                        this.m_6034_((double)impactPos.m_123341_() + 0.5, impactPos.m_123342_(), (double)impactPos.m_123343_() + 0.5);
                    });
                    this.m_20256_(currentVel.m_82542_(0.1, 0.1, 0.1));
                    this.setThrown(false);
                    this.setKnockedOut(true);
                    this.m_21837_(true);
                    if (!world2.m_5776_()) {
                        this.triggerAnimOnServer("mainController", "crash");
                    }
                    stopped = true;
                }
            }
            if (this.isThrown() && !stopped) {
                if (!this.m_9236_().m_5776_() && !this.hasPlayedIncomingSound) {
                    this.simulateTrajectoryAndCheckSound();
                }
                if (!this.m_20068_()) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.05, 0.0));
                }
                Vec3 currentVelocity = this.m_20184_();
                if (Double.isNaN(currentVelocity.f_82479_) || Double.isNaN(currentVelocity.f_82480_) || Double.isNaN(currentVelocity.f_82481_)) {
                    this.m_20256_(Vec3.f_82478_);
                    this.setThrown(false);
                    AdorableHamsterPets.LOGGER.warn("Hamster velocity became NaN, resetting and stopping throw.");
                } else {
                    int particleDelay;
                    this.m_6034_(this.m_20185_() + currentVelocity.f_82479_, this.m_20186_() + currentVelocity.f_82480_, this.m_20189_() + currentVelocity.f_82481_);
                    this.f_19812_ = true;
                    int n = particleDelay = this.hasGreenBeanBuff() ? 3 : 5;
                    if (!world2.m_5776_() && this.throwTicks > particleDelay) {
                        double offsetMultiplier = 1.5;
                        double spawnX = this.f_19854_ - currentVelocity.f_82479_ * offsetMultiplier;
                        double spawnY = this.f_19855_ + (double)this.m_20206_() / 2.0 - currentVelocity.f_82480_ * offsetMultiplier;
                        double spawnZ = this.f_19856_ - currentVelocity.f_82481_ * offsetMultiplier;
                        ((ServerLevel)world2).m_8767_((ParticleOptions)ParticleTypes.f_123796_, spawnX, spawnY, spawnZ, 1, 0.1, 0.1, 0.1, 0.0);
                    }
                }
            } else if (this.throwTicks != 0) {
                this.throwTicks = 0;
            }
        }
        if (!this.m_9236_().m_5776_() && this.m_21824_() && !this.isKnockedOut()) {
            boolean canInitiateDrowsiness = this.checkConditionsForInitiatingDrowsiness();
            boolean canSustainSlumber = this.checkConditionsForSustainingSlumber();
            switch (currentPhase) {
                case NONE: {
                    int durationTicks;
                    if (!this.m_21827_() || !canInitiateDrowsiness || this.quiescentSitDurationTimer != 0) break;
                    this.setDozingPhase(DozingPhase.QUIESCENT_SITTING);
                    int minSeconds = (Integer)Configs.AHP.tamedQuiescentSitMinSeconds.get();
                    int maxSeconds = (Integer)Configs.AHP.tamedQuiescentSitMaxSeconds.get();
                    if (minSeconds > maxSeconds) {
                        AdorableHamsterPets.LOGGER.info("Config issue: tamedQuiescentSitMinSeconds ({}) > tamedQuiescentSitMaxSeconds ({}). Swapping.", (Object)minSeconds, (Object)maxSeconds);
                        int temp = minSeconds;
                        minSeconds = maxSeconds;
                        maxSeconds = temp;
                    }
                    if (maxSeconds < minSeconds) {
                        maxSeconds = minSeconds;
                    }
                    this.quiescentSitDurationTimer = durationTicks = this.f_19796_.m_216332_(minSeconds * 20, maxSeconds * 20 + 1);
                    AdorableHamsterPets.LOGGER.debug("Hamster {} entering QUIESCENT_SITTING for {} ticks.", (Object)this.m_19879_(), (Object)durationTicks);
                    break;
                }
                case QUIESCENT_SITTING: {
                    if (!this.m_21827_() || !canInitiateDrowsiness) {
                        this.resetSleepSequence("Quiescent sitting interrupted: no longer sitting or conditions unfavorable.");
                        break;
                    }
                    if (this.quiescentSitDurationTimer > 0) {
                        --this.quiescentSitDurationTimer;
                        break;
                    }
                    this.setDozingPhase(DozingPhase.DRIFTING_OFF);
                    this.driftingOffTimer = 1800;
                    AdorableHamsterPets.LOGGER.debug("Hamster {} entering DRIFTING_OFF for {} ticks.", (Object)this.m_19879_(), (Object)this.driftingOffTimer);
                    break;
                }
                case DRIFTING_OFF: {
                    String settleAnimId;
                    if (!canSustainSlumber) {
                        this.resetSleepSequence("Drifting off interrupted: conditions for slumber no longer met.");
                        break;
                    }
                    if (this.driftingOffTimer > 0) {
                        --this.driftingOffTimer;
                        break;
                    }
                    this.setDozingPhase(DozingPhase.SETTLING_INTO_SLUMBER);
                    int choice = this.f_19796_.m_188503_(3);
                    String deepSleepAnimIdForTracker = switch (choice) {
                        case 0 -> {
                            settleAnimId = "anim_hamster_settle_sleep1";
                            yield "anim_hamster_sleep_pose1";
                        }
                        case 1 -> {
                            settleAnimId = "anim_hamster_settle_sleep2";
                            yield "anim_hamster_sleep_pose2";
                        }
                        default -> {
                            settleAnimId = "anim_hamster_settle_sleep3";
                            yield "anim_hamster_sleep_pose3";
                        }
                    };
                    this.f_19804_.m_135381_(CURRENT_DEEP_SLEEP_ANIM_ID, (Object)deepSleepAnimIdForTracker);
                    this.triggerAnimOnServer("mainController", settleAnimId);
                    this.settleSleepAnimationCooldown = 20;
                    this.triggerSettleEffects(0.22f, 5, 0.24f);
                    AdorableHamsterPets.LOGGER.debug("Hamster {} entering SETTLING_INTO_SLUMBER, triggering {}, target deep sleep anim ID: {}.", new Object[]{this.m_19879_(), settleAnimId, deepSleepAnimIdForTracker});
                    break;
                }
                case SETTLING_INTO_SLUMBER: {
                    if (!canSustainSlumber) {
                        this.resetSleepSequence("Settling into slumber interrupted: conditions for slumber no longer met.");
                        break;
                    }
                    if (this.settleSleepAnimationCooldown > 0) {
                        --this.settleSleepAnimationCooldown;
                        break;
                    }
                    this.setDozingPhase(DozingPhase.DEEP_SLEEP);
                    AdorableHamsterPets.LOGGER.debug("Hamster {} entering DEEP_SLEEP, playing {}.", (Object)this.m_19879_(), this.f_19804_.m_135370_(CURRENT_DEEP_SLEEP_ANIM_ID));
                    break;
                }
                case DEEP_SLEEP: {
                    if (canSustainSlumber) break;
                    this.triggerWakeUpFromSleepAnimation(false);
                    this.resetSleepSequence("Deep sleep interrupted: conditions for slumber no longer met.");
                }
            }
        }
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.f_19797_ % 20 == 0) {
            this.updateNavigation();
        }
        if (!this.m_9236_().m_5776_() && this.isSulking() && !this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -1.0, 0.0));
            this.f_19812_ = true;
        }
        if (!(world = this.m_9236_()).m_5776_()) {
            if (((Boolean)Configs.AHP.circadianChaos.get()).booleanValue() && this.m_5803_() && this.getLinkedBedPos().isPresent() && this.napInBedDurationTimer == 0) {
                this.wakeUpFromBed(false);
            }
            if (!((Boolean)Configs.AHP.circadianChaos.get()).booleanValue() && this.m_5803_() && this.getLinkedBedPos().isPresent()) {
                boolean isSleepTime;
                boolean bl = isSleepTime = (Boolean)Configs.AHP.sleepDuringDay.get() != false ? world.m_46461_() : world.m_46462_();
                if (!isSleepTime) {
                    if (this.wakeUpFromBedDelay == 0 && this.goToBedCooldown == 0) {
                        this.wakeUpFromBedDelay = this.f_19796_.m_216332_(5, 60);
                    }
                } else {
                    this.wakeUpFromBedDelay = 0;
                }
            }
            if (this.wakeUpFromBedDelay == 1) {
                this.wakeUpFromBed(false);
            }
            if (this.suffocationGracePeriod > 0 && this.m_5830_()) {
                for (int i = 1; i <= 5; ++i) {
                    BlockPos checkPos = this.m_20183_().m_6630_(i);
                    if (!this.isSafeSpawnLocation(checkPos, world)) continue;
                    this.m_20984_((double)checkPos.m_123341_() + 0.5, checkPos.m_123342_(), (double)checkPos.m_123343_() + 0.5, false);
                    AdorableHamsterPets.LOGGER.debug("[HamsterSelfRescue] Hamster {} teleported from {} to safe location {}.", new Object[]{this.m_19879_(), this.m_20183_().m_6625_(i), checkPos});
                    this.suffocationGracePeriod = 0;
                    break;
                }
            }
            if (this.ejectionCheckCooldown <= 0) {
                this.ejectionCheckCooldown = 100;
                boolean ejectedItem = false;
                for (int i = 0; i < this.items.size(); ++i) {
                    ItemStack stack = (ItemStack)this.items.get(i);
                    if (stack.m_41619_() || !this.isItemDisallowed(stack)) continue;
                    AdorableHamsterPets.LOGGER.warn("[HamsterTick {}] Ejecting disallowed item {} from slot {}.", new Object[]{this.m_19879_(), stack.m_41720_(), i});
                    Containers.m_18992_((Level)world, (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (ItemStack)stack.m_41777_());
                    this.items.set(i, (Object)ItemStack.f_41583_);
                    this.m_6596_();
                    ejectedItem = true;
                    break;
                }
            }
            if (this.m_21824_() && this.m_21223_() < this.m_21233_() && !this.isAutoEating() && !this.isConsideringAutoEat() && this.autoEatCooldownTicks == 0 && !this.isThrown() && !this.isKnockedOut()) {
                for (int i = 0; i < this.items.size(); ++i) {
                    ItemStack stack = (ItemStack)this.items.get(i);
                    if (stack.m_41619_() || !ConfigDataCache.isAutoHealFood(stack)) continue;
                    this.setHamsterFlag(1024, true);
                    this.preAutoEatDelayTicks = 40;
                    AdorableHamsterPets.LOGGER.trace("[HamsterTick {}] Eligible to auto-eat. Starting 2s pre-eat delay.", (Object)this.m_19879_());
                    break;
                }
            }
            if (this.isConsideringAutoEat() && this.preAutoEatDelayTicks == 0) {
                this.setHamsterFlag(1024, false);
                boolean foodStillAvailable = false;
                ItemStack foodToEat = ItemStack.f_41583_;
                int foodSlot = -1;
                for (int i = 0; i < this.items.size(); ++i) {
                    ItemStack stack = (ItemStack)this.items.get(i);
                    if (stack.m_41619_() || !ConfigDataCache.isAutoHealFood(stack)) continue;
                    foodStillAvailable = true;
                    foodToEat = stack;
                    foodSlot = i;
                    break;
                }
                if (foodStillAvailable) {
                    AdorableHamsterPets.LOGGER.trace("[HamsterTick {}] Pre-eat delay finished. Starting auto-eat on {} from slot {}", new Object[]{this.m_19879_(), foodToEat.m_41720_(), foodSlot});
                    this.isAutoEating = true;
                    this.autoEatProgressTicks = 60;
                    this.m_5496_(SoundEvents.f_11912_, 0.7f, 1.3f);
                    if (world instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)world;
                        serverWorld.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, foodToEat.m_41620_(1)), this.m_20185_() + this.f_19796_.m_188583_() * 0.1, this.m_20186_() + (double)this.m_20206_() / 2.0 + this.f_19796_.m_188583_() * 0.1, this.m_20189_() + this.f_19796_.m_188583_() * 0.1, 5, 0.1, 0.1, 0.1, 0.02);
                    }
                    if (foodToEat.m_41619_()) {
                        this.items.set(foodSlot, (Object)ItemStack.f_41583_);
                    }
                    this.updateCheekTrackers();
                } else {
                    AdorableHamsterPets.LOGGER.trace("[HamsterTick {}] Pre-eat delay finished, but food no longer available.", (Object)this.m_19879_());
                }
            }
            if (this.isAutoEating() && this.autoEatProgressTicks == 0) {
                this.m_5634_(((Float)Configs.AHP.hamsterFoodMixHealing.get()).floatValue());
                this.autoEatCooldownTicks = 60;
                this.isAutoEating = false;
                AdorableHamsterPets.LOGGER.trace("[HamsterTick {}] Auto-eat finished. Healed. Cooldown set to 60.", (Object)this.m_19879_());
                LivingEntity livingEntity = this.m_269323_();
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer serverPlayerOwner = (ServerPlayer)livingEntity;
                    ModCriteria.HAMSTER_AUTO_FED.trigger(serverPlayerOwner, this);
                }
            }
            if (!this.m_9236_().m_5776_() && this.isCelebratingDiamond()) {
                SoundEvent sparkleSound;
                if (this.diamondSparkleSoundDelayTicks == 1 && (sparkleSound = ModSounds.getRandomSoundFrom(ModSounds.DIAMOND_SPARKLE_SOUNDS, this.f_19796_)) != null) {
                    if (this.currentOreTarget != null) {
                        this.m_9236_().m_5594_(null, this.currentOreTarget, sparkleSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    } else {
                        this.m_9236_().m_5594_(null, this.m_20183_(), sparkleSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                }
                if (this.celebrationParticleTicks > 0) {
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123749_, this.m_20185_(), this.m_20186_() + 1.8, this.m_20189_(), 2, 0.12, 0.25, 0.12, 0.15);
                    if (this.currentOreTarget != null && this.f_19796_.m_188503_(4) == 0) {
                        BlockPos particlePos = this.currentOreTarget.m_7494_();
                        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123815_, (double)particlePos.m_123341_() + 0.5, (double)particlePos.m_123342_() + 0.5, (double)particlePos.m_123343_() + 0.5, 1, 0.2, 0.35, 0.2, 0.003);
                    }
                }
                if (this.diamondCelebrationSoundTicks <= 0) {
                    SoundEvent celebrationSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BEG_SOUNDS, this.f_19796_);
                    if (celebrationSound != null) {
                        this.m_9236_().m_5594_(null, this.m_20183_(), celebrationSound, SoundSource.NEUTRAL, 0.8f, this.m_6100_());
                    }
                    this.diamondCelebrationSoundTicks = 30;
                }
            }
            if (this.isSulking()) {
                if (this.sulkOrchestraHitDelayTicks == 1) {
                    this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)ModSounds.ALARM_ORCHESTRA_HIT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
                if (this.sulkShockedSoundDelayTicks == 1) {
                    this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)ModSounds.HAMSTER_SHOCKED.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
                if (this.sulkFailParticleTicks > 0 && this.currentOreTarget != null && this.f_19796_.m_188503_(3) == 0) {
                    BlockPos particlePos = this.currentOreTarget.m_7494_();
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)particlePos.m_123341_() + 0.5, (double)particlePos.m_123342_() + 0.5, (double)particlePos.m_123343_() + 0.5, 2, 0.3, 0.3, 0.3, 0.005);
                }
                if (this.sulkEntityEffectTicks > 0 && this.f_19796_.m_188503_(5) == 0) {
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123811_, this.m_20208_(0.3), this.m_20187_(), this.m_20262_(0.3), 0, 0.3, 0.3, 0.3, 1.0);
                }
            }
        }
        if (world.f_46443_ && this.hasGreenBeanBuff() && this.m_20184_().m_165925_() > 1.0E-6) {
            double backwardsSpeed = 1.7;
            double scatterStrength = 0.025;
            double downwardVelocity = 0.17;
            double positionOffsetMultiplier = 1.4;
            if (this.f_19796_.m_188503_(2) == 0) {
                for (int i = 0; i < 3; ++i) {
                    Vec3 currentVelocity = this.m_20184_();
                    double baseX = this.f_19854_ - currentVelocity.f_82479_ * 1.4;
                    double baseY = this.f_19855_ + (double)this.m_20206_() / 2.0 - currentVelocity.f_82480_ * 1.4;
                    double baseZ = this.f_19856_ - currentVelocity.f_82481_ * 1.4;
                    double spawnX = baseX + (this.f_19796_.m_188500_() - 0.5) * ((double)this.m_20205_() * 0.8);
                    double spawnY = baseY + (this.f_19796_.m_188500_() - 0.5) * ((double)this.m_20206_() * 0.05);
                    double spawnZ = baseZ + (this.f_19796_.m_188500_() - 0.5) * ((double)this.m_20205_() * 0.8);
                    Vec3 hamsterMovementVec = this.m_20184_();
                    Vec3 backwardsBaseVel = hamsterMovementVec.m_82490_(-1.7);
                    double finalVelX = backwardsBaseVel.f_82479_ + this.f_19796_.m_188583_() * 0.025;
                    double finalVelY = backwardsBaseVel.f_82480_ + this.f_19796_.m_188583_() * 0.025 - 0.17;
                    double finalVelZ = backwardsBaseVel.f_82481_ + this.f_19796_.m_188583_() * 0.025;
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123796_, spawnX, spawnY, spawnZ, finalVelX, finalVelY, finalVelZ);
                }
            }
        }
        if (this.isTaunting() && this.f_19796_.m_188503_(7) == 0) {
            for (int i = 0; i < 2; ++i) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123751_, this.m_20208_(0.6), this.m_20187_(), this.m_20262_(0.6), (this.f_19796_.m_188500_() - 0.5) * 0.5, (this.f_19796_.m_188500_() - 0.5) * 0.5, (this.f_19796_.m_188500_() - 0.5) * 0.5);
            }
        }
        if (this.isRefusingFood() && this.refuseTimer > 0 && --this.refuseTimer <= 0) {
            this.setRefusingFood(false);
        }
        if (this.tamingCooldown > 0) {
            --this.tamingCooldown;
        }
        if (this.customLoveTimer > 0) {
            --this.customLoveTimer;
        }
        if (this.customLoveTimer <= 0 && this.m_27593_()) {
            this.setInLove(false);
        }
    }

    public void m_6667_(DamageSource source) {
        Level world = this.m_9236_();
        if (!world.m_5776_()) {
            for (ItemStack stack : this.items) {
                if (stack.m_41619_()) continue;
                Containers.m_18992_((Level)world, (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (ItemStack)stack);
            }
            this.items.clear();
            this.updateCheekTrackers();
        }
        super.m_6667_(source);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "mainController", 2, event -> {
            DozingPhase currentDozingPhase = this.getDozingPhase();
            int personality = (Integer)this.f_19804_.m_135370_(ANIMATION_PERSONALITY_ID);
            if (this.isShoulderPet()) {
                ShoulderAnimationState shoulderState = ShoulderAnimationState.values()[(Integer)this.f_19804_.m_135370_(SHOULDER_ANIMATION_STATE)];
                return switch (shoulderState) {
                    case ShoulderAnimationState.SITTING -> {
                        if (this.getHamsterFlag(8192)) {
                            yield event.setAndContinue(CLEANING_ANIM);
                        }
                        RawAnimation v1 = switch (personality) {
                            case 2 -> SITTING_POSE2_ANIM;
                            case 3 -> SITTING_POSE3_ANIM;
                            default -> SITTING_POSE1_ANIM;
                        };
                        yield event.setAndContinue(v1);
                    }
                    case ShoulderAnimationState.LAYING_DOWN -> {
                        switch (this.shoulderLocation) {
                            case LEFT_SHOULDER: {
                                yield event.setAndContinue(LAYING_DOWN_LEFT_SHOULDER_ANIM);
                            }
                            case HEAD: {
                                yield event.setAndContinue(LAYING_DOWN_HEAD_ANIM);
                            }
                        }
                        yield event.setAndContinue(LAYING_DOWN_RIGHT_SHOULDER_ANIM);
                    }
                    default -> {
                        RawAnimation current = event.getController().getCurrentRawAnimation();
                        if (current != null && (current.equals((Object)IDLE1_ANIM) || current.equals((Object)IDLE2_ANIM))) {
                            yield event.setAndContinue(current);
                        }
                        yield event.setAndContinue(this.f_19796_.m_188499_() ? IDLE1_ANIM : IDLE2_ANIM);
                    }
                };
            }
            if (this.isKnockedOut()) {
                return event.setAndContinue(KNOCKED_OUT_ANIM);
            }
            if (this.isSulking()) {
                return event.setAndContinue(SULKING_ANIM);
            }
            if (this.isThrown()) {
                return event.setAndContinue(FLYING_ANIM);
            }
            if (this.isTaunting()) {
                return event.setAndContinue(DIAMOND_TAUNT_ANIM);
            }
            boolean isSeekingGoalActive = false;
            String activeGoalName = this.getActiveCustomGoalDebugName();
            if (activeGoalName.startsWith(HamsterSeekDiamondGoal.class.getSimpleName())) {
                isSeekingGoalActive = true;
            }
            if (isSeekingGoalActive) {
                double horizontalSpeedSquared = this.m_20184_().m_165925_();
                if (horizontalSpeedSquared > 1.0E-6) {
                    return event.setAndContinue(SEEKING_DIAMOND_ANIM);
                }
                return event.setAndContinue(WANTS_TO_SEEK_DIAMOND_ANIM);
            }
            if (this.isCelebratingDiamond()) {
                return event.setAndContinue(BEGGING_ANIM);
            }
            if (this.m_21824_()) {
                switch (currentDozingPhase) {
                    case DRIFTING_OFF: {
                        return event.setAndContinue(switch (personality) {
                            case 2 -> DRIFTING_OFF_POSE2_ANIM;
                            case 3 -> DRIFTING_OFF_POSE3_ANIM;
                            default -> DRIFTING_OFF_POSE1_ANIM;
                        });
                    }
                    case SETTLING_INTO_SLUMBER: {
                        String targetDeepSleepId = (String)this.f_19804_.m_135370_(CURRENT_DEEP_SLEEP_ANIM_ID);
                        if (!targetDeepSleepId.isEmpty()) {
                            RawAnimation targetDeepSleepAnim = switch (targetDeepSleepId) {
                                case "anim_hamster_sleep_pose1" -> SLEEP_POSE1_ANIM;
                                case "anim_hamster_sleep_pose2" -> SLEEP_POSE2_ANIM;
                                case "anim_hamster_sleep_pose3" -> SLEEP_POSE3_ANIM;
                                default -> SITTING_POSE1_ANIM;
                            };
                            return event.setAndContinue(targetDeepSleepAnim);
                        }
                        if (!this.m_21827_()) break;
                        return event.setAndContinue(switch (personality) {
                            case 2 -> SITTING_POSE2_ANIM;
                            case 3 -> SITTING_POSE3_ANIM;
                            default -> SITTING_POSE1_ANIM;
                        });
                    }
                    case DEEP_SLEEP: {
                        String deepSleepId;
                        RawAnimation deepSleepAnimToPlay = switch (deepSleepId = (String)this.f_19804_.m_135370_(CURRENT_DEEP_SLEEP_ANIM_ID)) {
                            case "anim_hamster_sleep_pose1" -> SLEEP_POSE1_ANIM;
                            case "anim_hamster_sleep_pose2" -> SLEEP_POSE2_ANIM;
                            case "anim_hamster_sleep_pose3" -> SLEEP_POSE3_ANIM;
                            default -> {
                                switch (personality) {
                                    case 2: {
                                        yield SITTING_POSE2_ANIM;
                                    }
                                    case 3: {
                                        yield SITTING_POSE3_ANIM;
                                    }
                                }
                                yield SITTING_POSE1_ANIM;
                            }
                        };
                        return event.setAndContinue(deepSleepAnimToPlay);
                    }
                }
            }
            if (!this.m_21824_() && this.m_5803_()) {
                String deepSleepId;
                RawAnimation deepSleepAnimToPlay = switch (deepSleepId = (String)this.f_19804_.m_135370_(CURRENT_DEEP_SLEEP_ANIM_ID)) {
                    case "anim_hamster_sleep_pose2" -> SLEEP_POSE2_ANIM;
                    case "anim_hamster_sleep_pose3" -> SLEEP_POSE3_ANIM;
                    default -> SLEEP_POSE1_ANIM;
                };
                return event.setAndContinue(deepSleepAnimToPlay);
            }
            if (this.m_21827_() && !this.isKnockedOut()) {
                if (this.getHamsterFlag(8192)) {
                    return event.setAndContinue(CLEANING_ANIM);
                }
                return event.setAndContinue(switch (personality) {
                    case 2 -> SITTING_POSE2_ANIM;
                    case 3 -> SITTING_POSE3_ANIM;
                    default -> SITTING_POSE1_ANIM;
                });
            }
            double horizontalSpeedSquared = this.m_20184_().m_165925_();
            if (horizontalSpeedSquared > 1.0E-6) {
                if (horizontalSpeedSquared > 0.008) {
                    return event.setAndContinue(SPRINTING_ANIM);
                }
                if (horizontalSpeedSquared > 0.002) {
                    return event.setAndContinue(RUNNING_ANIM);
                }
                return event.setAndContinue(WALKING_ANIM);
            }
            if (this.isBegging()) {
                return event.setAndContinue(BEGGING_ANIM);
            }
            if (activeGoalName.equals(HamsterLookAtEntityGoal.class.getSimpleName())) {
                return switch ((Integer)this.f_19804_.m_135370_(CURRENT_LOOK_UP_ANIM_ID)) {
                    case 2 -> event.setAndContinue(IDLE_LOOKING_UP2_ANIM);
                    case 3 -> event.setAndContinue(IDLE_LOOKING_UP3_ANIM);
                    default -> event.setAndContinue(IDLE_LOOKING_UP1_ANIM);
                };
            }
            RawAnimation current = event.getController().getCurrentRawAnimation();
            if (current != null && (current.equals((Object)IDLE1_ANIM) || current.equals((Object)IDLE2_ANIM))) {
                return event.setAndContinue(current);
            }
            return event.setAndContinue(this.f_19796_.m_188499_() ? IDLE1_ANIM : IDLE2_ANIM);
        }).triggerableAnim("crash", CRASH_ANIM).triggerableAnim("wakeup_from_ko", WAKE_UP_FROM_KO_ANIM).triggerableAnim("stationary_headshake", STATIONARY_HEADSHAKE_ANIM).triggerableAnim("moving_headshake", MOVING_HEADSHAKE_ANIM).triggerableAnim("attack", ATTACK_ANIM).triggerableAnim("sit1", SIT1_ANIM).triggerableAnim("sit2", SIT2_ANIM).triggerableAnim("sit3", SIT3_ANIM).triggerableAnim("standup1", STANDUP1_ANIM).triggerableAnim("standup2", STANDUP2_ANIM).triggerableAnim("standup3", STANDUP3_ANIM).triggerableAnim("wakeup1", WAKE_UP_1_ANIM).triggerableAnim("wakeup2", WAKE_UP_2_ANIM).triggerableAnim("wakeup3", WAKE_UP_3_ANIM).triggerableAnim("anim_hamster_sit_settle_sleep1", SIT_SETTLE_SLEEP1_ANIM).triggerableAnim("anim_hamster_sit_settle_sleep2", SIT_SETTLE_SLEEP2_ANIM).triggerableAnim("anim_hamster_sit_settle_sleep3", SIT_SETTLE_SLEEP3_ANIM).triggerableAnim("anim_hamster_stand_settle_sleep1", STAND_SETTLE_SLEEP1_ANIM).triggerableAnim("anim_hamster_stand_settle_sleep2", STAND_SETTLE_SLEEP2_ANIM).triggerableAnim("anim_hamster_stand_settle_sleep3", STAND_SETTLE_SLEEP3_ANIM).triggerableAnim("anim_hamster_sulk", SULK_ANIM).triggerableAnim("anim_hamster_diamond_pounce", DIAMOND_POUNCE_ANIM).triggerableAnim("anim_hamster_celebrate_chase", CELEBRATE_CHASE_ANIM).setParticleKeyframeHandler(event -> {
            this.particleEffectId = event.getKeyframeData().getEffect();
        }).setSoundKeyframeHandler(event -> {
            this.soundEffectId = event.getKeyframeData().getSound();
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void triggerAnimOnServer(String controllerName, String animName) {
        if (!this.m_9236_().m_5776_()) {
            this.triggerAnim(controllerName, animName);
            AdorableHamsterPets.LOGGER.trace("[HamsterEntity {}] Triggered server-side animation: Controller='{}', Anim='{}'", new Object[]{this.m_19879_(), controllerName, animName});
            Integer duration = TRIGGERABLE_ANIM_DURATIONS.get(animName);
            if (duration != null) {
                long executionTick = this.m_9236_().m_46467_() + (long)duration.intValue();
                Runnable cancellationAction = () -> {
                    this.stopTriggeredAnimation(controllerName, animName);
                    AdorableHamsterPets.LOGGER.trace("[HamsterEntity {}] Executed scheduled stop for animation: '{}'", (Object)this.m_19879_(), (Object)animName);
                };
                this.scheduledTasks.add(new ScheduledTask(executionTick, animName, cancellationAction));
                AdorableHamsterPets.LOGGER.trace("[HamsterEntity {}] Scheduled stop for animation '{}' in {} ticks (at tick {}).", new Object[]{this.m_19879_(), animName, duration, executionTick});
            } else {
                AdorableHamsterPets.LOGGER.warn("[HamsterEntity {}] No duration found for triggerable animation '{}'. Cancellation not scheduled.", (Object)this.m_19879_(), (Object)animName);
            }
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAMSTER_FLAGS, (Object)0);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(PINK_PETAL_TYPE, (Object)0);
        this.f_19804_.m_135372_(DOZING_PHASE, (Object)DozingPhase.NONE.ordinal());
        this.f_19804_.m_135372_(CURRENT_DEEP_SLEEP_ANIM_ID, (Object)"");
        this.f_19804_.m_135372_(ACTIVE_CUSTOM_GOAL_NAME_DEBUG, (Object)"None");
        this.f_19804_.m_135372_(ANIMATION_PERSONALITY_ID, (Object)1);
        this.f_19804_.m_135372_(STEAL_DURATION_TIMER, (Object)0);
        this.f_19804_.m_135372_(STOLEN_ITEM_STACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(GREEN_BEAN_BUFF_DURATION, (Object)0L);
        this.f_19804_.m_135372_(CURRENT_LOOK_UP_ANIM_ID, (Object)1);
        this.f_19804_.m_135372_(SHOULDER_ANIMATION_STATE, (Object)ShoulderAnimationState.STANDING.ordinal());
    }

    protected void m_8099_() {
        AdorableHamsterPets.LOGGER.trace("[AI Init {} Tick {}] Initializing goals. Current State: isSleeping={}, isSittingPose={}", new Object[]{this.m_19879_(), this.m_9236_().f_46443_ ? "ClientTick?" : Long.valueOf(this.m_9236_().m_46467_()), this.m_5803_(), this.m_21825_()});
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new HamsterSeekDiamondGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new HamsterStealDiamondGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new HamsterGoToBedAndSleepGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new HamsterMeleeAttackGoal(this, 1.5, true));
        this.f_21345_.m_25352_(3, (Goal)new HamsterMateGoal(this, 0.75));
        this.f_21345_.m_25352_(4, (Goal)new HamsterFollowOwnerGoal(this, 1.0, 4.0f, 16.0f));
        this.f_21345_.m_25352_(5, new HamsterFleeGoal<LivingEntity>(this, LivingEntity.class, 8.0f, 0.75, 1.5));
        this.f_21345_.m_25352_(6, (Goal)new HamsterTemptGoal(this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new HamsterSitGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new HamsterSleepGoal(this));
        this.f_21345_.m_25352_(9, (Goal)new HamsterWanderAroundFarGoal(this, 0.75));
        this.f_21345_.m_25352_(10, (Goal)new HamsterLookAtEntityGoal((Mob)this, Player.class, 2.0f, 0.15f));
        this.f_21345_.m_25352_(11, (Goal)new HamsterLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        AdorableHamsterPets.LOGGER.trace("[AI Init {} Tick {}] Finished initializing goals.", (Object)this.m_19879_(), this.m_9236_().f_46443_ ? "ClientTick?" : Long.valueOf(this.m_9236_().m_46467_()));
    }

    protected PathNavigation m_6037_(Level world) {
        if (Configs.AHP.avoidUnlinkedBeds) {
            return new HamsterNavigation(this, world);
        }
        return new GroundPathNavigation((Mob)this, world);
    }

    public void m_6710_(@Nullable LivingEntity target) {
        if (target == null) {
            super.m_6710_(null);
            return;
        }
        if (this.m_21824_() && this.m_269323_() != null) {
            TraceableEntity ownableFallback;
            Entity fallbackOwnerEntity;
            LivingEntity owner = this.m_269323_();
            UUID ownerUuid = owner.m_20148_();
            boolean preventTargeting = false;
            if (target instanceof TamableAnimal) {
                TamableAnimal tameablePet = (TamableAnimal)target;
                UUID petOwnerUuid = tameablePet.m_21805_();
                if (petOwnerUuid != null && petOwnerUuid.equals(ownerUuid) && tameablePet != this) {
                    preventTargeting = true;
                }
            } else if (target instanceof AbstractHorse) {
                AbstractHorse horsePet = (AbstractHorse)target;
                LivingEntity horseOwnerEntity = horsePet.m_269323_();
                if (horseOwnerEntity != null && horseOwnerEntity.m_20148_().equals(ownerUuid)) {
                    preventTargeting = true;
                }
            } else if (target instanceof TraceableEntity && (fallbackOwnerEntity = (ownableFallback = (TraceableEntity)target).m_19749_()) != null && fallbackOwnerEntity.m_20148_().equals(ownerUuid) && ownableFallback != this) {
                preventTargeting = true;
            }
            if (preventTargeting) {
                super.m_6710_(null);
                return;
            }
        }
        super.m_6710_(target);
    }

    public void startBedSleepEffects() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.getLinkedBedPos().ifPresent(globalPos -> {
            if (this.m_9236_().m_46472_() == globalPos.m_122640_()) {
                BlockPos bedPos = globalPos.m_122646_();
                BlockState bedState = this.m_9236_().m_8055_(bedPos);
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ModParticles.getForVariant((WoodVariant)((Object)((Object)bedState.m_61143_(HamsterBedBlock.WOOD_VARIANT)))), (double)bedPos.m_123341_() + 0.5, (double)bedPos.m_123342_() + 0.3, (double)bedPos.m_123343_() + 0.5, 70, 0.2, 0.5, 0.2, 1.0);
            }
        });
        this.bedLeafParticleTicks = 4;
        SoundEvent rustleSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BED_LEAVES_RUSTLE_SOUNDS, this.f_19796_);
        if (rustleSound != null) {
            this.m_9236_().m_5594_(null, this.m_20183_(), rustleSound, SoundSource.NEUTRAL, 0.5f, 1.0f);
        }
        this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)ModSounds.HAMSTER_THUMP.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        LivingEntity livingEntity = this.m_269323_();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayerOwner = (ServerPlayer)livingEntity;
            ModCriteria.HAMSTER_SLEPT_IN_BED.trigger(serverPlayerOwner);
        }
    }

    protected SoundEvent m_7515_() {
        if (this.isKnockedOut()) {
            return null;
        }
        if (this.isBegging() || this.isTaunting()) {
            return ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BEG_SOUNDS, this.f_19796_);
        }
        boolean playSleepSounds = false;
        if (this.m_21824_()) {
            DozingPhase phase = this.getDozingPhase();
            if (phase == DozingPhase.DRIFTING_OFF || phase == DozingPhase.SETTLING_INTO_SLUMBER || phase == DozingPhase.DEEP_SLEEP) {
                playSleepSounds = true;
            }
        } else if (this.m_5803_()) {
            playSleepSounds = true;
        }
        if (playSleepSounds) {
            return ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_SLEEP_SOUNDS, this.f_19796_);
        }
        return ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_IDLE_SOUNDS, this.f_19796_);
    }

    public void m_8032_() {
        SoundEvent soundEvent = this.m_7515_();
        if (soundEvent != null && Arrays.asList(ModSounds.HAMSTER_BEG_SOUNDS).contains(soundEvent)) {
            this.m_5496_(soundEvent, 0.8f, this.m_6100_());
        } else {
            super.m_8032_();
        }
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_HURT_SOUNDS, this.f_19796_);
    }

    protected SoundEvent m_5592_() {
        return ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_DEATH_SOUNDS, this.f_19796_);
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (!HamsterRenderTracker.isBeingRendered(this.m_19879_())) {
            try {
                SoundType group = state.m_60827_();
                float volume = state.m_60713_(Blocks.f_49994_) ? 0.060000002f : 0.1f;
                this.m_5496_(group.m_56776_(), volume, group.m_56774_() * 1.5f);
            }
            catch (Exception ex) {
                AdorableHamsterPets.LOGGER.warn("Error playing fallback step sound", (Throwable)ex);
            }
        }
    }

    protected boolean canHitEntity(Entity entity) {
        if (entity instanceof ArmorStand) {
            return !entity.m_5833_();
        }
        if (!entity.m_5833_() && entity.m_6084_() && entity.m_6087_()) {
            LivingEntity owner = this.m_269323_();
            return entity != this && (owner == null || !owner.m_20365_(entity));
        }
        return false;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag nbt) {
        AdorableHamsterPets.LOGGER.debug("[AHP Spawn Debug] HamsterEntity.initialize called. SpawnReason: {}", (Object)spawnReason);
        if (!world.m_5776_()) {
            int personalityId = this.f_19796_.m_216332_(1, 3);
            this.f_19804_.m_135381_(ANIMATION_PERSONALITY_ID, (Object)personalityId);
            AdorableHamsterPets.LOGGER.trace("[INITIALIZE] Hamster ID {}: Assigned Personality ID {}", (Object)this.m_19879_(), (Object)personalityId);
        }
        if (spawnReason == MobSpawnType.NATURAL || spawnReason == MobSpawnType.SPAWN_EGG || spawnReason == MobSpawnType.CHUNK_GENERATION) {
            Holder biomeEntry = world.m_204166_(this.m_20183_());
            String biomeKeyStr = biomeEntry.m_203543_().map(key -> key.m_135782_().toString()).orElse("UNKNOWN");
            AdorableHamsterPets.LOGGER.trace("[HamsterInit] SpawnReason: {}, BiomeKey: {}", (Object)spawnReason, (Object)biomeKeyStr);
            HamsterVariant chosenVariant = HamsterEntity.determineVariantForBiome((Holder<Biome>)biomeEntry, this.f_19796_);
            this.setVariant(chosenVariant.getId());
            AdorableHamsterPets.LOGGER.trace("[HamsterInit] Assigned variant: {}", (Object)chosenVariant.name());
        } else {
            int randomVariantId = this.f_19796_.m_188503_(HamsterVariant.values().length);
            this.setVariant(randomVariantId);
            AdorableHamsterPets.LOGGER.trace("[HamsterInit] SpawnReason: {}, Assigned random variant: {}", (Object)spawnReason, (Object)HamsterVariant.byId(randomVariantId).name());
        }
        if (!this.m_21824_()) {
            this.m_21051_(Attributes.f_22276_).m_22100_(((Double)Configs.AHP.wildMaxHealth.get()).doubleValue());
            this.m_21153_(this.m_21233_());
        }
        this.updateCheekTrackers();
        return super.m_6518_(world, difficulty, spawnReason, entityData, nbt);
    }

    protected BodyRotationControl m_7560_() {
        return new HamsterBodyControl((Mob)this);
    }

    private void broadcastDistantImpact(SoundEvent sound, float pitch) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        double impactX = this.m_20185_();
        double impactY = this.m_20186_();
        double impactZ = this.m_20189_();
        for (ServerPlayer player : ((ServerLevel)this.m_9236_()).m_6907_()) {
            double distSq = player.m_20275_(impactX, impactY, impactZ);
            if (!(distSq > 256.0) || !(distSq <= 2500.0)) continue;
            double distance = Math.sqrt(distSq);
            float volume = 0.18f - 0.1f * ((float)(distance - 16.0) / 34.0f);
            ModPackets.CHANNEL.sendToPlayer(player, (Object)new ModPackets.PlayDistantSoundS2CPacket(sound.m_11660_(), volume, pitch));
        }
    }

    private void simulateTrajectoryAndCheckSound() {
        Vec3 simPos = this.m_20182_();
        Vec3 simVel = this.m_20184_();
        for (int i = 1; i <= 20; ++i) {
            if (!this.m_20068_()) {
                simVel = simVel.m_82520_(0.0, -0.05, 0.0);
            }
            Vec3 nextPos = simPos.m_82549_(simVel);
            BlockHitResult blockHit = this.m_9236_().m_45547_(new ClipContext(simPos, nextPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            EntityHitResult entityHit = ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)simPos, (Vec3)nextPos, (AABB)this.m_20191_().m_82369_(simVel).m_82400_(1.0), this::canHitEntity);
            Vec3 impactPos = null;
            if (entityHit != null) {
                impactPos = entityHit.m_82450_();
            } else if (blockHit.m_6662_() != HitResult.Type.MISS) {
                impactPos = blockHit.m_82450_();
            }
            if (impactPos != null) {
                if (this.throwTicks + i >= 20) {
                    this.m_9236_().m_6263_(null, impactPos.f_82479_, impactPos.f_82480_, impactPos.f_82481_, (SoundEvent)ModSounds.HAMSTER_INCOMING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    AdorableHamsterPets.LOGGER.debug("Played Incoming sound at target: {}", (Object)impactPos);
                }
                this.hasPlayedIncomingSound = true;
                return;
            }
            simPos = nextPos;
        }
    }

    private boolean getHamsterFlag(int flag) {
        return ((Integer)this.f_19804_.m_135370_(HAMSTER_FLAGS) & flag) != 0;
    }

    private void setHamsterFlag(int flag, boolean value) {
        int currentFlags = (Integer)this.f_19804_.m_135370_(HAMSTER_FLAGS);
        if (value) {
            this.f_19804_.m_135381_(HAMSTER_FLAGS, (Object)(currentFlags | flag));
        } else {
            this.f_19804_.m_135381_(HAMSTER_FLAGS, (Object)(currentFlags & ~flag));
        }
    }

    private boolean isSafeSpawnLocation(BlockPos pos, Level world) {
        BlockPos floorPos = pos.m_7495_();
        BlockState floorState = world.m_8055_(floorPos);
        BlockPathTypes floorType = LandPathNodeMakerInvoker.callGetCommonNodeType((BlockGetter)world, floorPos);
        if (HAZARDOUS_FLOOR_TYPES.contains(floorType)) {
            return false;
        }
        if (floorState.m_60812_((BlockGetter)world, floorPos).m_83281_()) {
            return false;
        }
        CollisionContext entityContext = CollisionContext.m_82750_((Entity)this);
        return world.m_8055_(pos).m_60742_((BlockGetter)world, pos, entityContext).m_83281_() && world.m_8055_(pos.m_7494_()).m_60742_((BlockGetter)world, pos.m_7494_(), entityContext).m_83281_();
    }

    public boolean isItemDisallowed(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (ConfigDataCache.isPouchAllowed(stack)) {
            return false;
        }
        if (ConfigDataCache.isPouchDisallowed(stack)) {
            return true;
        }
        if (stack.m_41720_().m_41472_()) {
            return false;
        }
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            return true;
        }
        return item instanceof SpawnEggItem;
    }

    private HolderLookup.Provider getRegistryLookup() {
        return this.m_9236_().m_9598_();
    }

    private boolean tryTame(Player player, ItemStack itemStack) {
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        AhpConfig config = AdorableHamsterPets.CONFIG;
        int denominator = Math.max(1, (Integer)config.tamingChanceDenominator.get());
        if (this.f_19796_.m_188503_(denominator) == 0) {
            this.m_21816_(player.m_20148_());
            this.setTamed(true, true);
            this.f_21344_.m_26573_();
            this.m_21839_(false);
            this.setSleeping(false);
            this.m_6710_(null);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
            SoundEvent celebrateSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CELEBRATE_SOUNDS, this.f_19796_);
            this.m_9236_().m_5594_(null, this.m_20183_(), celebrateSound, SoundSource.NEUTRAL, 0.7f, 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10590_.m_68829_(serverPlayer, (Animal)this);
            }
            return true;
        }
        this.m_9236_().m_7605_((Entity)this, (byte)6);
        return false;
    }

    private boolean checkRepeatFoodRefusal(ItemStack currentStack, Player player) {
        if (ConfigDataCache.isRepeatableFood(currentStack)) {
            return false;
        }
        if (!this.lastFoodItem.m_41619_() && ItemStack.m_41656_((ItemStack)this.lastFoodItem, (ItemStack)currentStack)) {
            this.setRefusingFood(true);
            this.refuseTimer = 40;
            player.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.food_refusal"), true);
            if (!this.m_9236_().m_5776_()) {
                boolean isMoving;
                boolean bl = isMoving = this.m_20184_().m_165925_() > 1.0E-6;
                if (isMoving) {
                    this.triggerAnimOnServer("mainController", "moving_headshake");
                } else {
                    this.triggerAnimOnServer("mainController", "stationary_headshake");
                }
            }
            return true;
        }
        return false;
    }

    private boolean tryFeedingAsTamed(Player player, ItemStack stack) {
        boolean isFood = ConfigDataCache.isStandardFood(stack);
        boolean isBuffItem = ConfigDataCache.isBuffFood(stack);
        boolean isPouchUnlockFood = ConfigDataCache.isPouchUnlockFood(stack);
        boolean canHeal = this.m_21223_() < this.m_21233_();
        boolean readyToBreed = this.m_146764_() == 0 && !this.isInCustomLove();
        Level world = this.m_9236_();
        AhpConfig config = AdorableHamsterPets.CONFIG;
        boolean actionTaken = false;
        AdorableHamsterPets.LOGGER.debug("[FeedAttempt {} Tick {}] Entering tryFeedingAsTamed. Item: {}, isFood={}, isBuff={}, canHeal={}, breedingAge={}, isInCustomLove={}, readyToBreed={}", new Object[]{this.m_19879_(), world.m_46467_(), stack.m_41720_(), isFood, isBuffItem, canHeal, this.m_146764_(), this.isInCustomLove(), readyToBreed});
        if (isPouchUnlockFood && !this.getHamsterFlag(512)) {
            this.setHamsterFlag(512, true);
            AdorableHamsterPets.LOGGER.debug("Hamster {} cheek pouch unlocked by {}.", (Object)this.m_19879_(), (Object)stack.m_41720_());
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ModCriteria.CHEEK_POUCH_UNLOCKED.trigger(serverPlayer, this);
            }
            world.m_5594_(null, this.m_20183_(), SoundEvents.f_12275_, SoundSource.NEUTRAL, 0.5f, 1.5f);
            if (!world.f_46443_) {
                ((ServerLevel)world).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack.m_41777_()), this.m_20185_(), this.m_20227_(0.2), this.m_20189_(), 25, 0.25, 0.15, 0.25, 0.0);
            }
            return true;
        }
        if (isBuffItem) {
            long currentTime = world.m_46467_();
            if (this.greenBeanBuffEndTick > currentTime) {
                long remainingTicks = this.greenBeanBuffEndTick - currentTime;
                long totalSecondsRemaining = remainingTicks / 20L;
                long minutes = totalSecondsRemaining / 60L;
                long seconds = totalSecondsRemaining % 60L;
                player.m_5661_((Component)Component.m_237110_((String)"message.adorablehamsterpets.beans_cooldown", (Object[])new Object[]{minutes, seconds}).m_130940_(ChatFormatting.RED), true);
                AdorableHamsterPets.LOGGER.debug("[FeedAttempt {} Tick {}] Buff item used, but on cooldown ({} ticks remaining). Returning false.", new Object[]{this.m_19879_(), world.m_46467_(), remainingTicks});
                return false;
            }
            int duration = (Integer)config.greenBeanBuffDuration.get();
            int speedAmplifier = (Integer)config.greenBeanBuffAmplifierSpeed.get();
            int strengthAmplifier = (Integer)config.greenBeanBuffAmplifierStrength.get();
            int absorptionAmplifier = (Integer)config.greenBeanBuffAmplifierAbsorption.get();
            int regenAmplifier = (Integer)config.greenBeanBuffAmplifierRegen.get();
            this.zoomiesIsClockwise = this.f_19796_.m_188499_();
            this.lastZoomiesAngle = 0.0;
            this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, duration, speedAmplifier));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, duration, strengthAmplifier));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19617_, duration, absorptionAmplifier));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, duration, regenAmplifier));
            this.zoomiesIsClockwise = this.f_19796_.m_188499_();
            this.zoomiesRadiusModifier = this.f_19796_.m_216332_(-2, 4);
            double dx = this.m_20185_() - player.m_20185_();
            double dz = this.m_20189_() - player.m_20189_();
            this.lastZoomiesAngle = Math.atan2(dz, dx);
            SoundEvent buffSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CELEBRATE_SOUNDS, this.f_19796_);
            world.m_5594_(null, this.m_20183_(), buffSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
            long buffDurationEnd = currentTime + (long)((Integer)config.greenBeanBuffDuration.get()).intValue();
            this.m_20088_().m_135381_(GREEN_BEAN_BUFF_DURATION, (Object)buffDurationEnd);
            this.greenBeanBuffEndTick = currentTime + (long)((Integer)config.steamedGreenBeansBuffCooldown.get()).intValue();
            actionTaken = true;
            AdorableHamsterPets.LOGGER.trace("[FeedAttempt {} Tick {}] Applied buffs. Duration ends at tick {}. Cooldown ends at tick {}.", new Object[]{this.m_19879_(), world.m_46467_(), buffDurationEnd, this.greenBeanBuffEndTick});
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ModCriteria.FED_HAMSTER_STEAMED_BEANS.trigger(serverPlayer, this);
            }
        } else if (ConfigDataCache.isStandardFood(stack)) {
            if (canHeal) {
                this.m_5634_(((Float)config.standardFoodHealing.get()).floatValue());
                actionTaken = true;
                AdorableHamsterPets.LOGGER.debug("[FeedAttempt {}] Healed with standard food.", (Object)this.m_19879_());
            } else if (readyToBreed) {
                this.setSitting(false, true);
                this.setCustomInLove(player);
                this.setInLove(true);
                actionTaken = true;
                AdorableHamsterPets.LOGGER.debug("[FeedAttempt {}] Entered love mode with standard food.", (Object)this.m_19879_());
            }
        }
        if (!actionTaken) {
            AdorableHamsterPets.LOGGER.debug("[FeedAttempt {} Tick {}] Item {} was not a valid food for any action.", new Object[]{this.m_19879_(), world.m_46467_(), stack.m_41720_()});
        }
        return actionTaken;
    }

    @Unique
    private boolean checkConditionsForInitiatingDrowsiness() {
        if (!this.m_21827_()) {
            return false;
        }
        Level world = this.m_9236_();
        if (Configs.AHP.requireDaytimeForTamedSleep && !world.m_46461_()) {
            return false;
        }
        if (this.m_27593_()) {
            return false;
        }
        double threatRadius = ((Integer)Configs.AHP.tamedSleepThreatDetectionRadiusBlocks.get()).intValue();
        List nearbyHostiles = world.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(threatRadius), entity -> entity instanceof Monster && entity.m_6084_() && !entity.m_5833_());
        return nearbyHostiles.isEmpty();
    }

    @Unique
    private boolean checkConditionsForSustainingSlumber() {
        return this.m_21827_() && this.checkConditionsForInitiatingDrowsiness();
    }

    @Unique
    private void resetSleepSequence(String reason) {
        AdorableHamsterPets.LOGGER.debug("Hamster {} resetting sleep sequence: {}. Current phase was: {}", new Object[]{this.m_19879_(), reason, this.getDozingPhase()});
        this.setDozingPhase(DozingPhase.NONE);
        this.quiescentSitDurationTimer = 0;
        this.driftingOffTimer = 0;
        this.settleSleepAnimationCooldown = 0;
    }

    public void m_142036_() {
        super.m_142036_();
        if (!this.m_9236_().m_5776_()) {
            HamsterRenderTracker.onEntityUnload(this.m_19879_());
        }
    }

    static {
        TRIGGERABLE_ANIM_DURATIONS.put("crash", 18);
        TRIGGERABLE_ANIM_DURATIONS.put("wakeup_from_ko", 15);
        TRIGGERABLE_ANIM_DURATIONS.put("stationary_headshake", 25);
        TRIGGERABLE_ANIM_DURATIONS.put("moving_headshake", 25);
        TRIGGERABLE_ANIM_DURATIONS.put("attack", 23);
        TRIGGERABLE_ANIM_DURATIONS.put("sit1", 13);
        TRIGGERABLE_ANIM_DURATIONS.put("sit2", 13);
        TRIGGERABLE_ANIM_DURATIONS.put("sit3", 13);
        TRIGGERABLE_ANIM_DURATIONS.put("standup1", 13);
        TRIGGERABLE_ANIM_DURATIONS.put("standup2", 13);
        TRIGGERABLE_ANIM_DURATIONS.put("standup3", 13);
        TRIGGERABLE_ANIM_DURATIONS.put("wakeup1", 13);
        TRIGGERABLE_ANIM_DURATIONS.put("wakeup2", 13);
        TRIGGERABLE_ANIM_DURATIONS.put("wakeup3", 13);
        TRIGGERABLE_ANIM_DURATIONS.put("anim_hamster_sit_settle_sleep1", 23);
        TRIGGERABLE_ANIM_DURATIONS.put("anim_hamster_sit_settle_sleep2", 23);
        TRIGGERABLE_ANIM_DURATIONS.put("anim_hamster_sit_settle_sleep3", 23);
        TRIGGERABLE_ANIM_DURATIONS.put("anim_hamster_stand_settle_sleep1", 35);
        TRIGGERABLE_ANIM_DURATIONS.put("anim_hamster_stand_settle_sleep2", 35);
        TRIGGERABLE_ANIM_DURATIONS.put("anim_hamster_stand_settle_sleep3", 35);
        TRIGGERABLE_ANIM_DURATIONS.put("anim_hamster_sulk", 63);
        TRIGGERABLE_ANIM_DURATIONS.put("anim_hamster_diamond_pounce", 23);
        TRIGGERABLE_ANIM_DURATIONS.put("anim_hamster_celebrate_chase", 33);
    }

    public static enum DozingPhase {
        NONE,
        QUIESCENT_SITTING,
        DRIFTING_OFF,
        SETTLING_INTO_SLUMBER,
        DEEP_SLEEP;

    }

    private record ScheduledTask(long executionTick, String animName, Runnable action) {
    }
}

