/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.client.particle;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.IndoorOutdoorDetector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;

public class HamsterBeddingParticle
extends TextureSheetParticle {
    public static final double BEDDING_ITEM_FLAG = -1.23E-4;
    private static final float UNIVERSAL_DRIFT_ACCEL = 0.002f;
    private static final float DRIFT_PERIOD_TICKS = 3600.0f;
    private static final float SWAY_ROTATION_AMPLITUDE = 0.5f;
    private static final float SWAY_ROTATION_SPEED_MOD = 2.8f;
    private static final float UPWARD_BOOST_AT_APEX = 0.004f;
    private static final float HORIZ_SPEED_CAP = 0.08f;
    private static final int GUST_WINDOW_TICKS = 100;
    private static final float GUST_PROB_PER_WIN = 0.35f;
    private static final int GUST_MIN_LEN = 20;
    private static final int GUST_MAX_LEN = 40;
    private static final int GUST_CELL_BLOCKS = 12;
    private static final float GUST_UP_ACCEL = 0.025f;
    private static final float GUST_HORIZ_ACCEL = 0.06f;
    private static final float GUST_SPIN_IMPULSE = 2.0f;
    private static final float GUST_SPIN_DAMP = 0.85f;
    private static final float COUPLING_MIN = 0.12f;
    private static final float COUPLING_SPAN = 0.78f;
    private static final int PER_PARTICLE_DELAY_MAX = 8;
    private static final float WIND_DRAG = 0.1f;
    private static final float WIND_TARGET_SPEED = 0.09f;
    private static final float GUST_RISE_FRAC = 0.3f;
    private static final float EXTRA_HCAP = 0.075f;
    private static final Set<Long> playedGustSoundsThisTick = new HashSet<Long>();
    private static final Deque<Long> soundStartTimes = new ArrayDeque<Long>();
    private static final int MAX_CONCURRENT_SOUNDS = 3;
    private static final int SOUND_DURATION_TICKS = 65;
    private static long lastTick = -1L;
    private final boolean useFloatyPhysics;
    private long lastAppliedGustKey = Long.MIN_VALUE;
    private final float swayFrequency;
    private final float swayAcceleration;
    private final float swayPhaseOffset;
    private final float swayDirectionX;
    private final float swayDirectionZ;
    private final float constantRollVelocity;
    private float gustSpinVel = 0.0f;
    private float gustCoupling = 0.0f;
    private int gustDelayTicks = 0;

    public HamsterBeddingParticle(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, SpriteSet sprites) {
        super(world, x, y, z, vx, vy, vz);
        boolean bl = this.useFloatyPhysics = vy == -1.23E-4;
        if (this.useFloatyPhysics) {
            this.f_107216_ = 0.0;
            this.f_107226_ = 0.07f;
            this.f_172258_ = 0.92f;
            this.f_107225_ = 140 + world.f_46441_.m_188503_(200);
            float theta = world.f_46441_.m_188501_() * ((float)Math.PI * 2);
            this.swayDirectionX = Mth.m_14089_((float)theta);
            this.swayDirectionZ = Mth.m_14031_((float)theta);
            this.swayFrequency = 0.09f + world.f_46441_.m_188501_() * 0.05f;
            this.swayAcceleration = 0.002f + world.f_46441_.m_188501_() * 0.0025f;
            this.swayPhaseOffset = world.f_46441_.m_188501_() * ((float)Math.PI * 2);
            this.constantRollVelocity = (world.f_46441_.m_188501_() - 0.5f) * 0.12f;
        } else {
            this.f_107226_ = 0.6f;
            this.f_172258_ = 0.9f;
            this.f_107225_ = 20 + world.f_46441_.m_188503_(39);
            this.swayDirectionX = 0.0f;
            this.swayDirectionZ = 0.0f;
            this.swayFrequency = 0.0f;
            this.swayAcceleration = 0.0f;
            this.swayPhaseOffset = 0.0f;
            this.constantRollVelocity = 0.0f;
        }
        this.m_108337_(sprites.m_213979_(this.f_107223_));
        this.m_107250_(1.0f, 1.0f);
    }

    public void m_5989_() {
        long worldTime = this.f_107208_.m_46467_();
        if (worldTime != lastTick) {
            playedGustSoundsThisTick.clear();
            while (!soundStartTimes.isEmpty() && worldTime - soundStartTimes.peekFirst() > 65L) {
                soundStartTimes.pollFirst();
            }
            lastTick = worldTime;
        }
        if (this.useFloatyPhysics) {
            float dynamicHorizontalCap;
            float horizontalSpeedSquared;
            float universalDriftAngle;
            if (((Boolean)Configs.AHP.enableDynamicDriftAngle.get()).booleanValue()) {
                float timeWithPartial = (float)worldTime + Minecraft.m_91087_().m_91296_();
                universalDriftAngle = timeWithPartial / 3600.0f * ((float)Math.PI * 2);
            } else {
                universalDriftAngle = (float)Math.toRadians(((Integer)Configs.AHP.staticDriftAngle.get()).intValue());
            }
            float driftDirX = Mth.m_14089_((float)universalDriftAngle);
            float driftDirZ = Mth.m_14031_((float)universalDriftAngle);
            boolean isOutdoor = IndoorOutdoorDetector.isOutdoor(this.f_107208_, this.f_107212_, this.f_107213_, this.f_107214_);
            if (isOutdoor) {
                this.f_107215_ += (double)(driftDirX * 0.002f);
                this.f_107217_ += (double)(driftDirZ * 0.002f);
            }
            float phase = ((float)this.f_107224_ + this.swayPhaseOffset) * this.swayFrequency;
            float sinPhase = Mth.m_14031_((float)phase);
            float cosPhase = Mth.m_14089_((float)phase);
            float positionInSwing = Math.abs(cosPhase);
            float speedMultiplier = 0.5f + 1.5f * positionInSwing;
            float modifiedAcceleration = sinPhase * this.swayAcceleration * speedMultiplier;
            this.f_107215_ += (double)(this.swayDirectionX * modifiedAcceleration);
            this.f_107217_ += (double)(this.swayDirectionZ * modifiedAcceleration);
            this.f_107216_ += (double)(0.004f * (float)Math.pow(positionInSwing, 4.0));
            float gustStrengthLocal = 0.0f;
            if (isOutdoor) {
                Gust gust = HamsterBeddingParticle.sampleGust(this.f_107208_, this.f_107212_, this.f_107214_);
                if (gust.active) {
                    if (gust.key != this.lastAppliedGustKey) {
                        if (soundStartTimes.size() < 3 && playedGustSoundsThisTick.add(gust.key)) {
                            this.f_107208_.m_7785_(this.f_107212_, this.f_107213_, this.f_107214_, (SoundEvent)ModSounds.GENTLE_BREEZE.get(), SoundSource.AMBIENT, 1.0f, 1.0f, false);
                            soundStartTimes.addLast(worldTime);
                        }
                        Random pr = new Random(HamsterBeddingParticle.mix64(gust.key, System.identityHashCode((Object)this)));
                        this.gustCoupling = 0.12f + pr.nextFloat() * 0.78f;
                        this.gustCoupling = (float)Math.sqrt(this.gustCoupling);
                        this.gustDelayTicks = pr.nextInt(9);
                        this.lastAppliedGustKey = gust.key;
                    }
                    int delayedTicksSinceGustStart = Math.max(0, gust.ticksSinceGustStart - this.gustDelayTicks);
                    float gustProgress = (float)delayedTicksSinceGustStart / (float)gust.gustDurationTicks;
                    float rise = HamsterBeddingParticle.smooth01(Math.min(1.0f, gustProgress / 0.3f));
                    float decay = (float)Math.exp(-3.0f * gustProgress);
                    gustStrengthLocal = rise * decay * this.gustCoupling;
                    if (delayedTicksSinceGustStart == 0 && gust.ticksSinceGustStart >= this.gustDelayTicks) {
                        this.gustSpinVel += 2.0f * this.gustCoupling;
                    }
                    float easeOutFactor = 1.0f - (float)Math.pow(1.0f - gustProgress, 3.0);
                    float finalGustDirX = Mth.m_14179_((float)easeOutFactor, (float)driftDirX, (float)gust.gustDirX);
                    float finalGustDirZ = Mth.m_14179_((float)easeOutFactor, (float)driftDirZ, (float)gust.gustDirZ);
                    float along = (float)(this.f_107215_ * (double)finalGustDirX + this.f_107217_ * (double)finalGustDirZ);
                    float target = 0.09f * gustStrengthLocal;
                    float corr = (target - along) * 0.1f;
                    this.f_107215_ += (double)(finalGustDirX * corr);
                    this.f_107217_ += (double)(finalGustDirZ * corr);
                    this.f_107216_ += (double)(gustStrengthLocal * 0.025f);
                    this.f_107215_ += (double)(finalGustDirX * gustStrengthLocal * 0.06f);
                    this.f_107217_ += (double)(finalGustDirZ * gustStrengthLocal * 0.06f);
                }
            }
            if ((horizontalSpeedSquared = (float)(this.f_107215_ * this.f_107215_ + this.f_107217_ * this.f_107217_)) > (dynamicHorizontalCap = 0.08f + gustStrengthLocal * 0.075f) * dynamicHorizontalCap) {
                float scale = dynamicHorizontalCap / Mth.m_14116_((float)horizontalSpeedSquared);
                this.f_107215_ *= (double)scale;
                this.f_107217_ *= (double)scale;
            }
            this.f_107204_ = this.f_107231_;
            this.gustSpinVel *= 0.85f;
            float swayAngularVelocity = cosPhase * this.swayFrequency * 0.5f * 2.8f;
            this.f_107231_ += this.constantRollVelocity + swayAngularVelocity + this.gustSpinVel;
        }
        super.m_5989_();
        if (this.f_107218_) {
            this.f_107225_ = Math.min(this.f_107225_, this.f_107224_ + 10);
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    private static Gust sampleGust(ClientLevel world, double x, double z) {
        int cellZ;
        long worldTime = world.m_46467_();
        long gustWindowIndex = Math.floorDiv(worldTime, 100);
        int cellX = Mth.m_14143_((float)((float)x)) / 12;
        long baseSeed = HamsterBeddingParticle.mix64(cellX, cellZ = Mth.m_14143_((float)((float)z)) / 12, gustWindowIndex);
        Random r = new Random(baseSeed);
        if (r.nextFloat() >= 0.35f) {
            return new Gust(false, baseSeed, 0, 0, 0.0f, 0.0f);
        }
        int tickInCurrentWindow = (int)(worldTime % 100L);
        int maxStartTickInWindow = Math.max(1, 59);
        int gustStartTick = 1 + r.nextInt(maxStartTickInWindow);
        int gustDurationTicks = 20 + r.nextInt(21);
        if (tickInCurrentWindow < gustStartTick || tickInCurrentWindow > gustStartTick + gustDurationTicks) {
            long key = baseSeed ^ (long)gustStartTick;
            return new Gust(false, key, 0, gustDurationTicks, 0.0f, 0.0f);
        }
        float theta = r.nextFloat() * ((float)Math.PI * 2);
        float gustDirX = Mth.m_14089_((float)theta);
        float gustDirZ = Mth.m_14031_((float)theta);
        long key = baseSeed ^ (long)gustStartTick;
        int ticksSinceGustStart = tickInCurrentWindow - gustStartTick;
        return new Gust(true, key, ticksSinceGustStart, gustDurationTicks, gustDirX, gustDirZ);
    }

    private static long mix64(long seedA, long seedB) {
        long x = seedA * -7046029254386353131L + seedB + -4658895280553007687L;
        x ^= x >>> 30;
        x *= -4658895280553007687L;
        x ^= x >>> 27;
        x *= -7723592293110705685L;
        x ^= x >>> 31;
        return x;
    }

    private static long mix64(long currentSwayAcceleration, long b, long c) {
        return HamsterBeddingParticle.mix64(HamsterBeddingParticle.mix64(currentSwayAcceleration, b), c);
    }

    private static float smooth01(float x) {
        x = Mth.m_14036_((float)x, (float)0.0f, (float)1.0f);
        return x * x * (3.0f - 2.0f * x);
    }

    private record Gust(boolean active, long key, int ticksSinceGustStart, int gustDurationTicks, float gustDirX, float gustDirZ) {
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Factory(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double vx, double vy, double vz) {
            return new HamsterBeddingParticle(world, x, y, z, vx, vy, vz, this.sprites);
        }
    }
}

