/*
 * Decompiled with CFR 0.152.
 */
package org.thinkingstudio.obsidianui.widget.container;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import org.thinkingstudio.obsidianui.Position;
import org.thinkingstudio.obsidianui.navigation.NavigationDirection;
import org.thinkingstudio.obsidianui.navigation.NavigationUtils;
import org.thinkingstudio.obsidianui.option.SpruceOption;
import org.thinkingstudio.obsidianui.widget.AbstractSpruceWidget;
import org.thinkingstudio.obsidianui.widget.SpruceWidget;
import org.thinkingstudio.obsidianui.widget.container.SpruceEntryListWidget;
import org.thinkingstudio.obsidianui.widget.container.SpruceParentWidget;

public class SpruceOptionListWidget
extends SpruceEntryListWidget<OptionEntry> {
    private int lastIndex = 0;

    public SpruceOptionListWidget(Position position, int width, int height) {
        super(position, width, height, 4, OptionEntry.class);
    }

    public int addSingleOptionEntry(SpruceOption option) {
        return this.addEntry(OptionEntry.create(this, option, false));
    }

    public int addSmallSingleOptionEntry(SpruceOption option) {
        return this.addEntry(OptionEntry.create(this, option, true));
    }

    public void addOptionEntry(SpruceOption firstOption, @Nullable SpruceOption secondOption) {
        this.addEntry(OptionEntry.create(this, firstOption, secondOption));
    }

    public void addAll(SpruceOption[] options) {
        for (int i = 0; i < options.length; i += 2) {
            this.addOptionEntry(options[i], i < options.length - 1 ? options[i + 1] : null);
        }
    }

    @Override
    public void m_142291_(NarrationElementOutput builder) {
        this.children().stream().filter(AbstractSpruceWidget::isMouseHovered).findFirst().ifPresentOrElse(hoveredEntry -> {
            hoveredEntry.m_142291_(builder.m_142047_());
            this.appendPositionNarrations(builder, hoveredEntry);
        }, () -> {
            OptionEntry focusedEntry = (OptionEntry)this.getFocused();
            if (focusedEntry != null) {
                focusedEntry.m_142291_(builder.m_142047_());
                this.appendPositionNarrations(builder, focusedEntry);
            }
        });
        builder.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.component_list.usage"));
    }

    public static class OptionEntry
    extends SpruceEntryListWidget.Entry
    implements SpruceParentWidget<SpruceWidget> {
        private final List<SpruceWidget> children = new ArrayList<SpruceWidget>();
        private final SpruceOptionListWidget parent;
        @Nullable
        private SpruceWidget focused;
        private boolean dragging;

        private OptionEntry(SpruceOptionListWidget parent) {
            this.parent = parent;
        }

        public static OptionEntry create(SpruceOptionListWidget parent, SpruceOption option, boolean small) {
            OptionEntry entry = new OptionEntry(parent);
            entry.children.add(option.createWidget(Position.of(entry, entry.getWidth() / 2 - (small ? 75 : 155), 2), small ? 150 : 310));
            return entry;
        }

        public static OptionEntry create(SpruceOptionListWidget parent, SpruceOption firstOption, @Nullable SpruceOption secondOption) {
            OptionEntry entry = new OptionEntry(parent);
            entry.children.add(firstOption.createWidget(Position.of(entry, entry.getWidth() / 2 - 155, 2), 150));
            if (secondOption != null) {
                entry.children.add(secondOption.createWidget(Position.of(entry, entry.getWidth() / 2 - 155 + 160, 2), 150));
            }
            return entry;
        }

        @Override
        public int getWidth() {
            return this.parent.getWidth() - this.parent.getBorder().getThickness() * 2;
        }

        @Override
        public int getHeight() {
            return this.children.stream().mapToInt(SpruceWidget::getHeight).reduce(Integer::max).orElse(0) + 4;
        }

        @Override
        public List<SpruceWidget> children() {
            return this.children;
        }

        @Override
        @Nullable
        public SpruceWidget getFocused() {
            return this.focused;
        }

        @Override
        public void setFocused(@Nullable SpruceWidget focused) {
            if (this.focused == focused) {
                return;
            }
            if (this.focused != null) {
                this.focused.m_93692_(false);
            }
            this.focused = focused;
        }

        @Override
        public void m_93692_(boolean focused) {
            super.m_93692_(focused);
            if (!focused) {
                this.setFocused(null);
            }
        }

        @Override
        protected boolean onMouseClick(double mouseX, double mouseY, int button) {
            SpruceWidget element;
            Iterator it = this.iterator();
            do {
                if (it.hasNext()) continue;
                return false;
            } while (!(element = (SpruceWidget)it.next()).m_6375_(mouseX, mouseY, button));
            this.setFocused(element);
            if (button == 0) {
                this.dragging = true;
            }
            return true;
        }

        @Override
        protected boolean onMouseRelease(double mouseX, double mouseY, int button) {
            this.dragging = false;
            return this.hoveredElement(mouseX, mouseY).filter(element -> element.m_6348_(mouseX, mouseY, button)).isPresent();
        }

        @Override
        protected boolean onMouseDrag(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            return this.getFocused() != null && this.dragging && button == 0 && this.getFocused().m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }

        @Override
        protected boolean onKeyPress(int keyCode, int scanCode, int modifiers) {
            return this.focused != null && this.focused.m_7933_(keyCode, scanCode, modifiers);
        }

        @Override
        protected boolean onKeyRelease(int keyCode, int scanCode, int modifiers) {
            return this.focused != null && this.focused.m_7920_(keyCode, scanCode, modifiers);
        }

        @Override
        protected boolean onCharTyped(char chr, int keyCode) {
            return this.focused != null && this.focused.m_5534_(chr, keyCode);
        }

        @Override
        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            this.forEach(widget -> widget.m_88315_(graphics, mouseX, mouseY, delta));
        }

        @Override
        public void m_142291_(NarrationElementOutput builder) {
            SpruceWidget focused = this.getFocused();
            if (focused != null) {
                focused.m_142291_(builder);
            }
        }

        @Override
        public boolean onNavigation(NavigationDirection direction, boolean tab) {
            if (this.requiresCursor()) {
                return false;
            }
            if (!tab && direction.isVertical()) {
                if (this.m_93696_()) {
                    this.setFocused(null);
                    return false;
                }
                int lastIndex = this.parent.lastIndex;
                if (lastIndex >= this.children.size()) {
                    lastIndex = this.children.size() - 1;
                }
                if (!this.children.get(lastIndex).onNavigation(direction, tab)) {
                    return false;
                }
                this.setFocused(this.children.get(lastIndex));
                return true;
            }
            boolean result = NavigationUtils.tryNavigate(direction, tab, this.children, this.focused, this::setFocused, true);
            if (result) {
                this.m_93692_(true);
                if (direction.isHorizontal() && this.getFocused() != null) {
                    this.parent.lastIndex = this.children.indexOf(this.getFocused());
                }
            }
            return result;
        }
    }
}

