/*
 * Decompiled with CFR 0.152.
 */
package org.thinkingstudio.obsidianui.option;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.thinkingstudio.obsidianui.Position;
import org.thinkingstudio.obsidianui.option.SpruceOption;
import org.thinkingstudio.obsidianui.widget.SpruceWidget;
import org.thinkingstudio.obsidianui.widget.option.SpruceOptionSliderWidget;

public class SpruceDoubleOption
extends SpruceOption {
    protected final float step;
    protected final double min;
    protected double max;
    private final Supplier<Double> getter;
    private final Consumer<Double> setter;
    private final Function<SpruceDoubleOption, Component> displayStringGetter;

    public SpruceDoubleOption(String key, double min, double max, float step, Supplier<Double> getter, Consumer<Double> setter, Function<SpruceDoubleOption, Component> displayStringGetter, @Nullable Component tooltip) {
        super(key);
        this.min = min;
        this.max = max;
        this.step = step;
        this.getter = getter;
        this.setter = setter;
        this.displayStringGetter = displayStringGetter;
        this.setTooltip(tooltip);
    }

    @Override
    public SpruceWidget createWidget(Position position, int width) {
        SpruceOptionSliderWidget slider = new SpruceOptionSliderWidget(position, width, 20, this);
        this.getOptionTooltip().ifPresent(slider::setTooltip);
        return slider;
    }

    public double getRatio(double value) {
        return Mth.m_14008_((double)((this.adjust(value) - this.min) / (this.max - this.min)), (double)0.0, (double)1.0);
    }

    public double getValue(double ratio) {
        return this.adjust(Mth.m_14139_((double)Mth.m_14008_((double)ratio, (double)0.0, (double)1.0), (double)this.min, (double)this.max));
    }

    private double adjust(double value) {
        if (this.step > 0.0f) {
            value = this.step * (float)Math.round(value / (double)this.step);
        }
        return Mth.m_14008_((double)value, (double)this.min, (double)this.max);
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(float max) {
        this.max = max;
    }

    public void set(double value) {
        this.setter.accept(value);
    }

    public double get() {
        return this.getter.get();
    }

    public Component getDisplayString() {
        return this.displayStringGetter.apply(this);
    }
}

