/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.capability;

import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.client.particle.RagingParticleOptions;
import umpaz.brewinandchewin.common.network.BnCNetworkHandler;
import umpaz.brewinandchewin.common.network.clientbound.SyncRagingStacksClientboundPacket;
import umpaz.brewinandchewin.common.registry.BnCEffects;

public class RagingCapability
implements ICapabilitySerializable<CompoundTag> {
    public static final float RESET_TICK_MULTIPLIER = 2.5f;
    public static final ResourceLocation ID = BrewinAndChewin.asResource("raging");
    public static final Capability<RagingCapability> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<RagingCapability>(){});
    private final LazyOptional<RagingCapability> thisOptional = LazyOptional.of(() -> this);
    private int stacks = 0;
    private int ticksUntilReset = 0;
    private int previousStacks = 0;
    private static final UUID RAGING_ATTRIBUTE_UUID = UUID.fromString("70661c2d-8c96-4757-971f-1ae56f1422fe");

    public int getStacks() {
        return this.stacks;
    }

    public void setStacks(int value) {
        this.stacks = value;
    }

    public int getTicksUntilReset() {
        return this.ticksUntilReset;
    }

    public void setTicksUntilReset(int value) {
        this.ticksUntilReset = value;
    }

    public static void tick(LivingEntity living) {
        living.getCapability(INSTANCE).ifPresent(cap -> {
            if (!living.m_9236_().m_5776_()) {
                if (cap.getTicksUntilReset() <= 0 && cap.getStacks() > 0) {
                    float f;
                    cap.setStacks(cap.getStacks() - 1);
                    if (living instanceof Player) {
                        Player player = (Player)living;
                        f = player.m_36333_();
                    } else {
                        f = 30.0f;
                    }
                    cap.setTicksUntilReset(Mth.m_14167_((float)(2.5f * f)));
                }
                if (cap.getStacks() <= 0 || !living.m_21023_((MobEffect)BnCEffects.RAGING.get())) {
                    if (living.m_21204_().m_22154_(Attributes.f_22283_, RAGING_ATTRIBUTE_UUID)) {
                        living.m_21051_(Attributes.f_22283_).m_22120_(RAGING_ATTRIBUTE_UUID);
                    }
                    if (cap.previousStacks != 0) {
                        cap.previousStacks = 0;
                        cap.setStacks(0);
                        cap.setTicksUntilReset(0);
                        BnCNetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> living), (Object)new SyncRagingStacksClientboundPacket(living.m_19879_(), 0));
                    }
                    return;
                }
                cap.setTicksUntilReset(cap.getTicksUntilReset() - 1);
                if (cap.previousStacks != cap.stacks) {
                    if (living.m_21204_().m_22154_(Attributes.f_22283_, RAGING_ATTRIBUTE_UUID)) {
                        living.m_21051_(Attributes.f_22283_).m_22120_(RAGING_ATTRIBUTE_UUID);
                    }
                    living.m_21051_(Attributes.f_22283_).m_22118_(new AttributeModifier(RAGING_ATTRIBUTE_UUID, "Raging attack speed increase", Math.min(0.8, 0.05 * (double)cap.getStacks() + 0.025 * (double)living.m_21124_((MobEffect)BnCEffects.RAGING.get()).m_19564_() * (double)cap.getStacks()), AttributeModifier.Operation.MULTIPLY_TOTAL));
                    BnCNetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> living), (Object)new SyncRagingStacksClientboundPacket(living.m_19879_(), cap.getStacks()));
                }
                cap.previousStacks = cap.stacks;
            }
            if (living.m_21023_((MobEffect)BnCEffects.RAGING.get()) && living.m_21124_((MobEffect)BnCEffects.RAGING.get()).m_19572_() && living.m_217043_().m_188503_(cap.getStacks() > 0 ? 3 : 20) == 0) {
                double heightAddition = living.m_20206_() - living.m_20192_();
                living.m_9236_().m_7106_(RagingCapability.getParticleType(cap.getStacks(), 0.75f), living.m_20208_(0.7), living.m_217043_().m_188500_() * heightAddition * 2.0 + living.m_20188_() - heightAddition, living.m_20262_(0.7), (0.5 - living.m_217043_().m_188500_()) * (double)0.1f, 0.0, (0.5 - living.m_217043_().m_188500_()) * (double)0.1f);
            }
        });
    }

    public static ParticleOptions getParticleType(int stacks, float size) {
        return switch (stacks) {
            case 0, 1 -> new RagingParticleOptions.StageOne(size);
            case 2 -> new RagingParticleOptions.StageTwo(size);
            case 3 -> new RagingParticleOptions.StageThree(size);
            default -> new RagingParticleOptions.StageFour(size);
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return INSTANCE.orEmpty(cap, this.thisOptional);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("stacks", this.stacks);
        tag.m_128405_("ticks_until_reset", this.ticksUntilReset);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.stacks = nbt.m_128451_("stacks");
        this.ticksUntilReset = nbt.m_128451_("ticks_until_reset");
    }
}

