/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.client.particle;

import com.github.L_Ender.cataclysm.init.ModParticle;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class Rain_Fog_Particle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private static final Vector3f ROTATION_VECTOR = (Vector3f)Util.m_137469_((Object)new Vector3f(0.5f, 0.5f, 0.5f), Vector3f::normalize);
    private static final Vector3f TRANSFORM_VECTOR = new Vector3f(-1.0f, -1.0f, 0.0f);
    private static final float DEGREES_90 = 1.5707964f;

    protected Rain_Fog_Particle(ClientLevel level, double xCoord, double yCoord, double zCoord, double xd, double yd, double zd, float size, SpriteSet spriteSet) {
        super(level, xCoord, yCoord, zCoord, xd, yd, zd);
        this.sprites = spriteSet;
        this.m_108339_(this.sprites);
        this.f_107215_ = xd;
        this.f_107216_ = yd;
        this.f_107217_ = zd;
        this.f_107230_ = 0.6f;
        this.f_107663_ = size;
        this.f_107226_ = 0.0f;
        this.f_107225_ = (int)(Math.random() * 2.0) + 60;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public float m_5902_(float p_107608_) {
        float f = 1.0f - ((float)this.f_107224_ + p_107608_) / ((float)this.f_107225_ * 1.5f);
        return this.f_107663_ * f;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.m_108339_(this.sprites);
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.f_107215_ *= (double)this.f_172258_;
            this.f_107216_ *= (double)this.f_172258_;
            this.f_107217_ *= (double)this.f_172258_;
        }
    }

    private float noise(float offset) {
        return 10.0f * Mth.m_14031_((float)(offset * 0.01f));
    }

    public void m_5744_(VertexConsumer buffer, Camera camera, float partialticks) {
        this.f_107230_ = 1.0f - Mth.m_14036_((float)(((float)this.f_107224_ + partialticks - 20.0f) / (float)this.f_107225_), (float)0.2f, (float)0.7f);
        this.renderRotatedParticle(buffer, camera, partialticks, p_234005_ -> {
            p_234005_.mul((Quaternionfc)Axis.f_252436_.m_252961_(0.0f));
            p_234005_.mul((Quaternionfc)Axis.f_252529_.m_252961_(-1.5707964f));
        });
        this.renderRotatedParticle(buffer, camera, partialticks, p_234000_ -> {
            p_234000_.mul((Quaternionfc)Axis.f_252436_.m_252961_((float)(-Math.PI)));
            p_234000_.mul((Quaternionfc)Axis.f_252529_.m_252961_(1.5707964f));
        });
    }

    private void renderRotatedParticle(VertexConsumer pConsumer, Camera camera, float partialTick, Consumer<Quaternionf> pQuaternion) {
        Vec3 vec3 = camera.m_90583_();
        float f = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        Quaternionf quaternion = new Quaternionf().setAngleAxis(0.0f, ROTATION_VECTOR.x(), ROTATION_VECTOR.y(), ROTATION_VECTOR.z());
        pQuaternion.accept(quaternion);
        quaternion.transform(TRANSFORM_VECTOR);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f3 = this.m_5902_(partialTick);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(f3);
            vector3f.add(f, f1, f2);
        }
        int j = this.m_6355_(partialTick);
        this.makeCornerVertex(pConsumer, avector3f[0], this.m_5952_(), this.m_5950_(), j);
        this.makeCornerVertex(pConsumer, avector3f[1], this.m_5952_(), this.m_5951_(), j);
        this.makeCornerVertex(pConsumer, avector3f[2], this.m_5970_(), this.m_5951_(), j);
        this.makeCornerVertex(pConsumer, avector3f[3], this.m_5970_(), this.m_5950_(), j);
    }

    private void makeCornerVertex(VertexConsumer pConsumer, Vector3f pVec3f, float p_233996_, float p_233997_, int p_233998_) {
        Vec3 wiggle = new Vec3((double)this.noise((float)((double)this.f_107224_ + this.f_107212_)), (double)this.noise((float)((double)this.f_107224_ - this.f_107212_)), (double)this.noise((float)((double)this.f_107224_ + this.f_107214_))).m_82490_((double)0.02f);
        pConsumer.m_5483_((double)pVec3f.x() + wiggle.f_82479_, (double)pVec3f.y(), (double)pVec3f.z() + wiggle.f_82481_).m_7421_(p_233996_, p_233997_).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(p_233998_).m_5752_();
    }

    public static class FogData
    implements ParticleOptions {
        public static final ParticleOptions.Deserializer<FogData> DESERIALIZER = new ParticleOptions.Deserializer<FogData>(){

            public FogData fromCommand(ParticleType<FogData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                float size = reader.readFloat();
                return new FogData(size);
            }

            public FogData fromNetwork(ParticleType<FogData> particleTypeIn, FriendlyByteBuf buffer) {
                return new FogData(buffer.readFloat());
            }
        };
        private final float size;

        public FogData(float size) {
            this.size = size;
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeFloat(this.size);
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %.2f", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), Float.valueOf(this.size));
        }

        public ParticleType<FogData> m_6012_() {
            return (ParticleType)ModParticle.RAIN_FOG.get();
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getSize() {
            return this.size;
        }

        public static Codec<FogData> CODEC(ParticleType<FogData> particleType) {
            return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.FLOAT.fieldOf("size").forGetter(FogData::getSize)).apply((Applicative)codecBuilder, size -> new FogData(size.floatValue())));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<FogData> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(FogData typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Rain_Fog_Particle particle = new Rain_Fog_Particle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.getSize(), this.spriteSet);
            return particle;
        }
    }
}

