/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.justagreenhouse.blockentity;

import java.util.Optional;
import net.magicvt.justagreenhouse.block.SeedMakerBlock;
import net.magicvt.justagreenhouse.blockentity.ModBlockEntities;
import net.magicvt.justagreenhouse.recipe.ModRecipes;
import net.magicvt.justagreenhouse.recipe.SeedMakerRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SeedMakerBlockEntity
extends BlockEntity {
    private ItemStack input = ItemStack.f_41583_;
    private ItemStack result = ItemStack.f_41583_;
    private int progress = 0;
    private static final int MAX_PROGRESS = 2400;

    public SeedMakerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.SEED_MAKER.get(), pos, state);
    }

    public boolean tryStartProcessing(ItemStack stack) {
        if (stack.m_41619_() || this.isProcessing() || this.f_58857_ == null) {
            return false;
        }
        Optional<SeedMakerRecipe> recipeOptional = this.f_58857_.m_7465_().m_44013_((RecipeType)ModRecipes.SEED_MAKER_RECIPE_TYPE.get()).stream().filter(recipe -> recipe.getIngredient().test(stack)).findFirst();
        if (recipeOptional.isPresent()) {
            SeedMakerRecipe recipe2 = recipeOptional.get();
            this.input = stack.m_255036_(1);
            this.result = recipe2.m_8043_(this.f_58857_.m_9598_());
            this.progress = 0;
            return true;
        }
        return false;
    }

    public boolean isProcessing() {
        return !this.input.m_41619_();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SeedMakerBlockEntity be) {
        if (be.isProcessing()) {
            ++be.progress;
            if (be.progress >= 2400) {
                be.spawnResult();
                be.input = ItemStack.f_41583_;
                be.progress = 0;
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)SeedMakerBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
    }

    private void spawnResult() {
        if (!this.result.m_41619_() && this.f_58857_ != null && !this.f_58857_.f_46443_) {
            ItemEntity itemEntity = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.0, (double)this.f_58858_.m_123343_() + 0.5, this.result.m_41777_());
            this.f_58857_.m_7967_((Entity)itemEntity);
            this.result = ItemStack.f_41583_;
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, SeedMakerBlockEntity be) {
        if (((Boolean)state.m_61143_((Property)SeedMakerBlock.LIT)).booleanValue() && level.f_46441_.m_188503_(10) == 0) {
            level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, SoundEvents.f_11764_, SoundSource.BLOCKS, 0.5f, 1.0f, false);
        }
    }
}

