/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.item;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import toughasnails.api.block.TANBlocks;
import toughasnails.api.enchantment.TANEnchantments;
import toughasnails.api.item.TANItems;
import toughasnails.block.RainCollectorBlock;
import toughasnails.init.ModConfig;
import toughasnails.init.ModTags;

public class EmptyCanteenItem
extends Item {
    int tier;

    public EmptyCanteenItem(int tier, Item.Properties properties) {
        super(properties);
        this.tier = tier;
    }

    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        return this.fillCanteen(level, player, player.m_21120_(hand));
    }

    protected InteractionResultHolder<ItemStack> fillCanteen(Level level, Player player, ItemStack stack) {
        BlockPos pos;
        BlockHitResult rayTraceResult = EmptyCanteenItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (rayTraceResult.m_6662_() == HitResult.Type.BLOCK && level.m_7966_(player, pos = rayTraceResult.m_82425_())) {
            BlockState state = level.m_8055_(pos);
            if (state.m_60734_() instanceof RainCollectorBlock) {
                int waterLevel = (Integer)state.m_61143_((Property)RainCollectorBlock.LEVEL);
                if (waterLevel > 0 && !level.m_5776_()) {
                    level.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11770_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    ((RainCollectorBlock)TANBlocks.RAIN_COLLECTOR).setWaterLevel(level, pos, state, waterLevel - 1);
                    return InteractionResultHolder.m_19090_((Object)this.replaceCanteen(stack, player, new ItemStack((ItemLike)this.getPurifiedWaterCanteen())));
                }
            } else if (state.m_60734_() == Blocks.f_152476_) {
                int waterLevel = (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_);
                if (waterLevel > 0 && !level.m_5776_()) {
                    level.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11770_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    LayeredCauldronBlock.m_153559_((BlockState)state, (Level)level, (BlockPos)pos);
                    return InteractionResultHolder.m_19090_((Object)this.replaceCanteen(stack, player, new ItemStack((ItemLike)this.getWaterCanteen())));
                }
            } else if (level.m_6425_(pos).m_205070_(FluidTags.f_13131_)) {
                level.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11770_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                if (ModConfig.thirst.removeSourceBlocks) {
                    level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
                }
                Holder biome = player.m_9236_().m_204166_(player.m_20183_());
                Item canteenItem = EnchantmentHelper.m_44843_((Enchantment)TANEnchantments.WATER_CLEANSING, (ItemStack)stack) > 0 || biome.m_203656_(ModTags.Biomes.PURIFIED_WATER_BIOMES) ? this.getPurifiedWaterCanteen() : (biome.m_203656_(ModTags.Biomes.DIRTY_WATER_BIOMES) ? this.getDirtyWaterCanteen() : this.getWaterCanteen());
                return InteractionResultHolder.m_19092_((Object)this.replaceCanteen(stack, player, new ItemStack((ItemLike)canteenItem)), (boolean)level.m_5776_());
            }
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public boolean m_41465_() {
        return true;
    }

    protected ItemStack replaceCanteen(ItemStack oldStack, Player player, ItemStack newStack) {
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        EnchantmentHelper.m_44865_((Map)EnchantmentHelper.m_44831_((ItemStack)oldStack), (ItemStack)newStack);
        return ItemUtils.m_41813_((ItemStack)oldStack, (Player)player, (ItemStack)newStack);
    }

    public Item getDirtyWaterCanteen() {
        switch (this.tier) {
            default: {
                return TANItems.LEATHER_DIRTY_WATER_CANTEEN;
            }
            case 1: {
                return TANItems.COPPER_DIRTY_WATER_CANTEEN;
            }
            case 2: {
                return TANItems.IRON_DIRTY_WATER_CANTEEN;
            }
            case 3: {
                return TANItems.GOLD_DIRTY_WATER_CANTEEN;
            }
            case 4: {
                return TANItems.DIAMOND_DIRTY_WATER_CANTEEN;
            }
            case 5: 
        }
        return TANItems.NETHERITE_DIRTY_WATER_CANTEEN;
    }

    public Item getWaterCanteen() {
        switch (this.tier) {
            default: {
                return TANItems.LEATHER_WATER_CANTEEN;
            }
            case 1: {
                return TANItems.COPPER_WATER_CANTEEN;
            }
            case 2: {
                return TANItems.IRON_WATER_CANTEEN;
            }
            case 3: {
                return TANItems.GOLD_WATER_CANTEEN;
            }
            case 4: {
                return TANItems.DIAMOND_WATER_CANTEEN;
            }
            case 5: 
        }
        return TANItems.NETHERITE_WATER_CANTEEN;
    }

    public Item getPurifiedWaterCanteen() {
        switch (this.tier) {
            default: {
                return TANItems.LEATHER_PURIFIED_WATER_CANTEEN;
            }
            case 1: {
                return TANItems.COPPER_PURIFIED_WATER_CANTEEN;
            }
            case 2: {
                return TANItems.IRON_PURIFIED_WATER_CANTEEN;
            }
            case 3: {
                return TANItems.GOLD_PURIFIED_WATER_CANTEEN;
            }
            case 4: {
                return TANItems.DIAMOND_PURIFIED_WATER_CANTEEN;
            }
            case 5: 
        }
        return TANItems.NETHERITE_PURIFIED_WATER_CANTEEN;
    }
}

