/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.init;

import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import toughasnails.api.potion.TANEffects;
import toughasnails.api.potion.TANPotions;
import toughasnails.potion.ThirstEffect;

public class ModPotions {
    public static void registerEffects(BiConsumer<ResourceLocation, MobEffect> func) {
        TANEffects.THIRST = ModPotions.registerEffect(func, "thirst", new ThirstEffect(MobEffectCategory.HARMFUL, 7789388));
        TANEffects.ICE_RESISTANCE = ModPotions.registerEffect(func, "ice_resistance", new MobEffect(MobEffectCategory.BENEFICIAL, 7842303));
        TANEffects.CLIMATE_CLEMENCY = ModPotions.registerEffect(func, "climate_clemency", new MobEffect(MobEffectCategory.BENEFICIAL, 0xB6B6B6));
        TANEffects.INTERNAL_WARMTH = ModPotions.registerEffect(func, "internal_warmth", new MobEffect(MobEffectCategory.BENEFICIAL, 16775897));
        TANEffects.INTERNAL_CHILL = ModPotions.registerEffect(func, "internal_chill", new MobEffect(MobEffectCategory.BENEFICIAL, 14810367));
    }

    public static void registerPotions(BiConsumer<ResourceLocation, Potion> func) {
        TANPotions.ICE_RESISTANCE = ModPotions.registerPotion(func, "ice_resistance", new Potion(new MobEffectInstance[]{new MobEffectInstance(TANEffects.ICE_RESISTANCE, 3600)}));
        TANPotions.LONG_ICE_RESISTANCE = ModPotions.registerPotion(func, "long_ice_resistance", new Potion(new MobEffectInstance[]{new MobEffectInstance(TANEffects.ICE_RESISTANCE, 9600)}));
        ModPotions.registerPotionRecipes();
    }

    public static void registerPotionRecipes() {
        PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)Items.f_42452_, (Potion)TANPotions.ICE_RESISTANCE);
        PotionBrewing.m_43513_((Potion)TANPotions.ICE_RESISTANCE, (Item)Items.f_42451_, (Potion)TANPotions.LONG_ICE_RESISTANCE);
    }

    private static MobEffect registerEffect(BiConsumer<ResourceLocation, MobEffect> func, String name, MobEffect effect) {
        func.accept(new ResourceLocation("toughasnails", name), effect);
        return effect;
    }

    private static Potion registerPotion(BiConsumer<ResourceLocation, Potion> func, String name, Potion potion) {
        func.accept(new ResourceLocation("toughasnails", name), potion);
        return potion;
    }
}

