/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.forge.datagen.provider;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class TANItemModelProvider
extends ItemModelProvider {
    private static final int NUM_THERMOMETER_MODELS = 21;

    public TANItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "toughasnails", existingFileHelper);
    }

    protected void registerModels() {
        this.registerThermometerModels();
    }

    private void registerThermometerModels() {
        int i;
        ItemModelBuilder thermometer = (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(TANItemModelProvider.loc("thermometer").toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"));
        ModelFile[] thermometerModels = new ModelFile[21];
        for (i = 0; i < 21; ++i) {
            String pathIndex = String.format("%02d", i);
            thermometerModels[i] = this.basicItem(TANItemModelProvider.loc("thermometer_" + pathIndex));
        }
        for (i = 0; i < 21; ++i) {
            thermometer.override().predicate(TANItemModelProvider.loc("temperature"), (float)i / 20.0f).model(thermometerModels[i]);
        }
    }

    private static ResourceLocation loc(String name) {
        return new ResourceLocation("toughasnails", name);
    }
}

