/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.client.event;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RegisterRecipeBookCategoriesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.client.gui.CookingPotTooltip;
import vectorwing.farmersdelight.client.model.SkilletModel;
import vectorwing.farmersdelight.client.particle.StarParticle;
import vectorwing.farmersdelight.client.particle.SteamParticle;
import vectorwing.farmersdelight.client.recipebook.RecipeCategories;
import vectorwing.farmersdelight.client.renderer.CanvasSignRenderer;
import vectorwing.farmersdelight.client.renderer.CuttingBoardRenderer;
import vectorwing.farmersdelight.client.renderer.HangingCanvasSignRenderer;
import vectorwing.farmersdelight.client.renderer.SkilletRenderer;
import vectorwing.farmersdelight.client.renderer.StoveRenderer;
import vectorwing.farmersdelight.common.registry.ModBlockEntityTypes;
import vectorwing.farmersdelight.common.registry.ModEntityTypes;
import vectorwing.farmersdelight.common.registry.ModParticleTypes;

@Mod.EventBusSubscriber(modid="farmersdelight", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientSetupEvents {
    @SubscribeEvent
    public static void onRegisterRecipeBookCategories(RegisterRecipeBookCategoriesEvent event) {
        RecipeCategories.init(event);
    }

    @SubscribeEvent
    public static void registerCustomTooltipRenderers(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(CookingPotTooltip.CookingPotTooltipComponent.class, CookingPotTooltip::new);
    }

    @SubscribeEvent
    public static void onModelRegister(ModelEvent.RegisterAdditional event) {
        event.register((ResourceLocation)new ModelResourceLocation(new ResourceLocation("farmersdelight", "skillet_cooking"), "inventory"));
    }

    @SubscribeEvent
    public static void onEntityRendererRegister(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)ModEntityTypes.ROTTEN_TOMATO.get(), ThrownItemRenderer::new);
    }

    @SubscribeEvent
    public static void onModelBake(ModelEvent.ModifyBakingResult event) {
        Map modelRegistry = event.getModels();
        ModelResourceLocation skilletLocation = new ModelResourceLocation(new ResourceLocation("farmersdelight", "skillet"), "inventory");
        BakedModel skilletModel = (BakedModel)modelRegistry.get(skilletLocation);
        ModelResourceLocation skilletCookingLocation = new ModelResourceLocation(new ResourceLocation("farmersdelight", "skillet_cooking"), "inventory");
        BakedModel skilletCookingModel = (BakedModel)modelRegistry.get(skilletCookingLocation);
        modelRegistry.put(skilletLocation, new SkilletModel(event.getModelBakery(), skilletModel, skilletCookingModel));
    }

    @SubscribeEvent
    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntityTypes.STOVE.get(), StoveRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntityTypes.CUTTING_BOARD.get(), CuttingBoardRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntityTypes.CANVAS_SIGN.get(), CanvasSignRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntityTypes.HANGING_CANVAS_SIGN.get(), HangingCanvasSignRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntityTypes.SKILLET.get(), SkilletRenderer::new);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ModParticleTypes.STAR.get(), StarParticle.Factory::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ModParticleTypes.STEAM.get(), SteamParticle.Factory::new);
    }
}

