/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.forge;

import com.github.exopandora.shouldersurfing.IPlatform;
import com.github.exopandora.shouldersurfing.compat.Mods;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.maven.artifact.versioning.VersionRange;
import org.jetbrains.annotations.Nullable;

public class Platform
implements IPlatform {
    @Override
    @Nullable
    public String getModVersion(Mods mod) {
        return switch (mod) {
            default -> throw new IncompatibleClassChangeError();
            case Mods.CGM -> Platform.findModVersionForId("cgm");
            case Mods.COBBLEMON -> Platform.findModVersionForId("cobblemon");
            case Mods.CREATE -> Platform.findModVersionForId("create");
            case Mods.CURIOS -> Platform.findModVersionForId("curios");
            case Mods.EMF -> Platform.findModVersionForId("entity_model_features");
            case Mods.EPIC_FIGHT -> Platform.findModVersionForId("epicfight");
            case Mods.IRIS -> null;
            case Mods.MTS -> Platform.findModVersionForId("mts");
            case Mods.OCULUS -> Platform.findModVersionForId("oculus");
            case Mods.SKIN_LAYERS -> Platform.findModVersionForId("skinlayers3d");
            case Mods.THE_ONE_PROBE -> Platform.findModVersionForId("theoneprobe");
            case Mods.TSLAT_ENTITY_STATUS -> Platform.findModVersionForId("tslatentitystatus");
            case Mods.WILDFIRE_GENDER -> Platform.findModVersionForId("wildfire_gender");
        };
    }

    private static String findModVersionForId(String modId) {
        return FMLLoader.getLoadingModList().getMods().stream().filter(info -> info.getModId().equals(modId)).findFirst().map(info -> info.getVersion().toString()).orElse(null);
    }

    public static VersionRange parseVersionRangeSilent(String predicate) {
        try {
            return VersionRange.createFromVersionSpec((String)predicate);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

