/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class WatcherSwordItem
extends UniqueSwordItem {
    private static int stepMod = 0;

    public WatcherSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            ServerLevel world = (ServerLevel)attacker.m_9236_();
            int watcherChance = (int)Config.getFloat("watcherChance", "UniqueEffects", ConfigDefaultValues.watcherChance);
            int omenChance = (int)Config.getFloat("omenChance", "UniqueEffects", ConfigDefaultValues.omenChance);
            HelperMethods.playHitSounds(attacker, target);
            if (attacker.m_217043_().m_188503_(100) <= watcherChance) {
                int hradius = (int)Config.getFloat("watcherRadius", "UniqueEffects", ConfigDefaultValues.watcherRadius);
                int vradius = (int)(Config.getFloat("watcherRadius", "UniqueEffects", ConfigDefaultValues.watcherRadius) / 2.0f);
                double x = target.m_20185_();
                double y = target.m_20186_();
                double z = target.m_20189_();
                float rAmount = Config.getFloat("watcherRestoreAmount", "UniqueEffects", ConfigDefaultValues.watcherRestoreAmount);
                AABB box = new AABB(x + (double)hradius, y + (double)vradius, z + (double)hradius, x - (double)hradius, y - (double)vradius, z - (double)hradius);
                for (Entity entity : world.m_6249_((Entity)attacker, box, EntitySelector.f_20402_)) {
                    if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire((LivingEntity)entity, attacker)) continue;
                    entity.m_6469_(attacker.m_269291_().m_269104_((Entity)attacker, (Entity)attacker), rAmount);
                    attacker.m_5634_(rAmount);
                    BlockPos position2 = entity.m_20183_();
                    world.m_5594_(null, position2, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_SCIFI_SHOOT_IMPACT_02.get(), entity.m_5720_(), 0.05f, 1.2f);
                }
            }
            if (attacker.m_217043_().m_188503_(100) <= omenChance) {
                BlockPos position = target.m_20183_();
                float overallAbsorptionCap = Config.getFloat("abilityAbsorptionCap", "UniqueEffects", ConfigDefaultValues.abilityAbsorptionCap);
                float absorptionCap = Config.getFloat("omenAbsorptionCap", "UniqueEffects", ConfigDefaultValues.omenAbsorptionCap);
                float threshold = Config.getFloat("omenInstantKillThreshold", "UniqueEffects", ConfigDefaultValues.omenInstantKillThreshold) * target.m_21233_();
                float remainingHealth = target.m_21223_();
                if (remainingHealth <= threshold) {
                    attacker.m_7911_(Math.min(overallAbsorptionCap, attacker.m_6103_() + remainingHealth));
                    world.m_5594_(null, position, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_SCIFI_SHOOT_IMPACT_03.get(), target.m_5720_(), 0.7f, 1.2f);
                    target.m_6469_(attacker.m_269291_().m_269104_((Entity)attacker, (Entity)attacker), 1000.0f);
                }
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(entity, stack, world, stepMod, ParticleTypes.f_123809_, ParticleTypes.f_123809_, ParticleTypes.f_123757_, true);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style ABILITY = HelperMethods.getStyle("ability");
        Style TEXT = HelperMethods.getStyle("text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.watchersworditem.tooltip1").m_6270_(ABILITY));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.watchersworditem.tooltip2").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237110_((String)"item.simplyswords.watchersworditem.tooltip3", (Object[])new Object[]{Float.valueOf(Config.getFloat("omenInstantKillThreshold", "UniqueEffects", ConfigDefaultValues.omenInstantKillThreshold) * 100.0f)}).m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.watchersworditem.tooltip4").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.watchersworditem.tooltip5").m_6270_(ABILITY));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.watchersworditem.tooltip6").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.watchersworditem.tooltip7").m_6270_(TEXT));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

