/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.mcf.shapes;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RotatedShapeCacheSimple {
    private final Map<Direction, VoxelShape> cache;
    private final Function<Direction, VoxelShape> compute;

    public RotatedShapeCacheSimple(Map<Direction, VoxelShape> cache, Function<Direction, VoxelShape> compute) {
        this.cache = cache;
        this.compute = compute;
    }

    public static RotatedShapeCacheSimple hashBased(Function<Direction, VoxelShape> compute) {
        return new RotatedShapeCacheSimple(new HashMap<Direction, VoxelShape>(4), compute);
    }

    public static RotatedShapeCacheSimple hashBasedSynchronized(Function<Direction, VoxelShape> compute) {
        return new RotatedShapeCacheSimple(Collections.synchronizedMap(new HashMap(4)), compute);
    }

    public void clear() {
        this.cache.clear();
    }

    public VoxelShape getShape(Direction rotation) {
        return this.cache.computeIfAbsent(rotation, this.compute);
    }
}

