/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.mcf.fluid;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.IReverseTag;
import net.minecraftforge.registries.tags.ITagManager;
import org.zeith.hammerlib.util.mcf.fluid.FluidHelper;
import org.zeith.hammerlib.util.mcf.fluid.FluidIngredientStack;

public record FluidIngredient(CompareMode mode, List<FluidStack> asFluidStack, List<TagKey<Fluid>> asTags) implements Predicate<FluidStack>
{
    public static final Codec<FluidIngredient> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("mode").xmap(CompareMode::valueOf, Enum::name).forGetter(FluidIngredient::mode), (App)FluidStack.CODEC.listOf().fieldOf("fluids").forGetter(FluidIngredient::asFluidStack), (App)TagKey.m_203877_((ResourceKey)ForgeRegistries.Keys.FLUIDS).listOf().fieldOf("tags").forGetter(FluidIngredient::asTags)).apply((Applicative)instance, FluidIngredient::new));
    public static FluidIngredient EMPTY = new FluidIngredient(CompareMode.VALUES, List.of(), List.of());

    public FluidIngredient(CompareMode mode, List<FluidStack> asFluidStack, List<TagKey<Fluid>> asTags) {
        this.mode = mode;
        this.asFluidStack = asFluidStack.stream().map(fs -> FluidHelper.withAmount(fs, 1)).toList();
        this.asTags = asTags;
    }

    public static FluidIngredient fromJson(JsonElement json) {
        return (FluidIngredient)((Pair)((DataResult)JsonOps.INSTANCE.withDecoder(CODEC).apply(json)).result().orElseThrow()).getFirst();
    }

    public static FluidIngredient ofTags(List<TagKey<Fluid>> tags) {
        return new FluidIngredient(CompareMode.TAGS, List.of(), tags).resolve();
    }

    public static FluidIngredient ofFluids(List<FluidStack> fluids) {
        return new FluidIngredient(CompareMode.VALUES, fluids, List.of()).resolve();
    }

    public static FluidIngredient join(FluidIngredient ... ingredients) {
        ArrayList<FluidStack> asFluidStack = new ArrayList<FluidStack>();
        ArrayList<TagKey<Fluid>> asTags = new ArrayList<TagKey<Fluid>>();
        for (FluidIngredient ingredient : ingredients) {
            asTags.addAll(ingredient.asTags);
            asFluidStack.addAll(ingredient.asFluidStack);
        }
        if (asFluidStack.isEmpty()) {
            if (asTags.isEmpty()) {
                return EMPTY;
            }
            return FluidIngredient.ofTags(asTags);
        }
        if (asTags.isEmpty()) {
            return FluidIngredient.ofFluids(asFluidStack);
        }
        return new FluidIngredient(CompareMode.BOTH, asFluidStack, asTags);
    }

    public JsonElement toJson() {
        return (JsonElement)((DataResult)JsonOps.INSTANCE.withEncoder(CODEC).apply(this)).result().orElseThrow();
    }

    FluidIngredient resolve() {
        return this.isEmpty() ? EMPTY : this;
    }

    public boolean isEmpty() {
        return this == EMPTY || this.asFluidStack.isEmpty() && this.asTags().isEmpty();
    }

    public FluidIngredientStack stack(int amount) {
        return new FluidIngredientStack(this, amount);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean test(FluidStack fluidStack) {
        boolean bl;
        if (this.isEmpty()) {
            return fluidStack.isEmpty();
        }
        switch (this.mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case BOTH: {
                if (this.asFluidStack.stream().anyMatch(arg_0 -> ((FluidStack)fluidStack).isFluidEqual(arg_0))) return true;
                if (!ForgeRegistries.FLUIDS.tags().getReverseTag((Object)fluidStack.getFluid()).stream().flatMap(IReverseTag::getTagKeys).anyMatch(this.asTags::contains)) return false;
                return true;
            }
            case VALUES: {
                bl = this.asFluidStack.stream().anyMatch(arg_0 -> ((FluidStack)fluidStack).isFluidEqual(arg_0));
                return bl;
            }
            case TAGS: {
                bl = ForgeRegistries.FLUIDS.tags().getReverseTag((Object)fluidStack.getFluid()).stream().flatMap(IReverseTag::getTagKeys).anyMatch(this.asTags::contains);
            }
        }
        return bl;
    }

    public FluidStack[] getValues() {
        return this.getValues(1);
    }

    public FluidStack[] getValues(int amount) {
        return switch (this.mode) {
            default -> throw new IncompatibleClassChangeError();
            case CompareMode.BOTH -> (FluidStack[])Stream.concat(Optional.ofNullable(ForgeRegistries.FLUIDS.tags()).stream().flatMap(manager -> this.asTags.stream().map(arg_0 -> ((ITagManager)manager).getTag(arg_0))).flatMap(tag -> tag.stream().map(f -> new FluidStack(f, amount))), this.asFluidStack.stream().map(fs -> FluidHelper.withAmount(fs, amount))).toArray(FluidStack[]::new);
            case CompareMode.TAGS -> (FluidStack[])Optional.ofNullable(ForgeRegistries.FLUIDS.tags()).stream().flatMap(manager -> this.asTags.stream().map(arg_0 -> ((ITagManager)manager).getTag(arg_0))).flatMap(tag -> tag.stream().map(f -> new FluidStack(f, amount))).toArray(FluidStack[]::new);
            case CompareMode.VALUES -> (FluidStack[])this.asFluidStack.stream().map(fs -> FluidHelper.withAmount(fs, amount)).toArray(FluidStack[]::new);
        };
    }

    public static enum CompareMode {
        TAGS,
        VALUES,
        BOTH;

    }
}

