/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.configured.types;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import org.zeith.hammerlib.util.configured.ConfigToken;
import org.zeith.hammerlib.util.configured.ConfiguredLib;
import org.zeith.hammerlib.util.configured.io.IoNewLiner;
import org.zeith.hammerlib.util.configured.io.StringReader;
import org.zeith.hammerlib.util.configured.types.ConfigObject;

public class ConfigCategory
extends ConfigObject<ConfigCategory> {
    public ConfigCategory(Runnable onChanged, ConfigToken<ConfigCategory> token, String name) {
        super(onChanged, token, name);
        this.terminalCharacter = (character, depth) -> character == 125;
    }

    public ConfigCategory setupSubCategory(String name) {
        return this.getElement(ConfiguredLib.CATEGORY, name);
    }

    @Override
    public boolean read(BufferedReader reader, int depth, String readerStack) throws IOException {
        if (StringReader.skipWhitespaces(reader) != 123) {
            return false;
        }
        return super.read(reader, depth, readerStack);
    }

    @Override
    public void write(BufferedWriter writer, IoNewLiner newLiner) throws IOException {
        writer.write("{");
        newLiner.newLine();
        super.write(writer, newLiner);
        newLiner.newLine(-1);
        writer.write("}");
    }

    public String toString() {
        return "ConfigCategory{elements=" + this.elements + ", name='" + this.name + "', comment='" + this.getEscapedComment() + "'}";
    }
}

