/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.configured.struct.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Optional;

public interface IField<T> {
    public int getModifiers();

    public Class<T> getType();

    public T get();

    public void set(T var1);

    public String getName();

    public <A extends Annotation> Optional<A> annotation(Class<A> var1);

    public static <A> IField<A> wrap(final Field field, final Object instance) {
        return new IField<A>(){

            @Override
            public int getModifiers() {
                return field.getModifiers();
            }

            @Override
            public Class getType() {
                return field.getType();
            }

            @Override
            public A get() {
                try {
                    field.setAccessible(true);
                    return field.get(instance);
                }
                catch (IllegalAccessException e) {
                    return null;
                }
            }

            @Override
            public void set(A value) {
                try {
                    field.setAccessible(true);
                    field.set(instance, value);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }

            @Override
            public String getName() {
                return field.getName();
            }

            @Override
            public <A1 extends Annotation> Optional<A1> annotation(Class<A1> type) {
                return Optional.ofNullable(field.getAnnotation(type));
            }
        };
    }
}

