/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.lighting;

import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.Event;
import org.zeith.hammerlib.util.colors.ColorHelper;

@OnlyIn(value=Dist.CLIENT)
public class WorldTintEvent
extends Event {
    private int baseColor = 0xFFFFFF;
    private float intensity = 0.0f;
    private IntList modifiers;

    public WorldTintEvent(IntList modifiers) {
        this.modifiers = modifiers;
    }

    public void addModifierColor(int rgb) {
        this.modifiers.add(rgb);
    }

    public int getFinalColor() {
        if (!this.modifiers.isEmpty()) {
            float rt = 0.0f;
            float gt = 0.0f;
            float bt = 0.0f;
            IntListIterator intListIterator = this.modifiers.iterator();
            while (intListIterator.hasNext()) {
                int i = (Integer)intListIterator.next();
                rt += ColorHelper.getRed(i);
                gt += ColorHelper.getGreen(i);
                bt += ColorHelper.getBlue(i);
            }
            return ColorHelper.packRGB(rt / (float)this.modifiers.size(), gt / (float)this.modifiers.size(), bt / (float)this.modifiers.size());
        }
        return this.baseColor;
    }

    public void setIntensity(float intensity) {
        this.intensity = intensity;
    }

    public void maxIntensity(float newIntensity) {
        this.intensity = Math.max(this.intensity, newIntensity);
    }

    public float getIntensity() {
        return this.intensity;
    }
}

