/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.DistExecutor;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.CapabilityStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.StackStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageContentsTooltip;

public class WoodStorageBlockItem
extends StorageBlockItem {
    public static final String WOOD_TYPE_TAG = "woodType";
    public static final String PACKED_TAG = "packed";

    public WoodStorageBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public static void setPacked(ItemStack storageStack, boolean packed) {
        storageStack.m_41784_().m_128379_(PACKED_TAG, packed);
    }

    public static boolean isPacked(ItemStack storageStack) {
        return NBTHelper.getBoolean((ItemStack)storageStack, (String)PACKED_TAG).orElse(false);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (WoodStorageBlockItem.isPacked(stack)) {
            if (flagIn == TooltipFlag.f_256730_) {
                stack.getCapability(CapabilityStorageWrapper.getCapabilityInstance()).ifPresent(w -> w.getContentsUuid().ifPresent(uuid -> tooltip.add((Component)Component.m_237113_((String)("UUID: " + String.valueOf(uuid))).m_130940_(ChatFormatting.DARK_GRAY))));
            }
            if (!Screen.m_96638_()) {
                tooltip.add((Component)Component.m_237110_((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".press_for_contents"), (Object[])new Object[]{Component.m_237115_((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".shift")).m_130940_(ChatFormatting.AQUA)}).m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        if (!WoodStorageBlockItem.isPacked(stack)) {
            return Optional.empty();
        }
        AtomicReference<Object> ret = new AtomicReference<Object>(null);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Minecraft mc = Minecraft.m_91087_();
            if (Screen.m_96638_() || mc.f_91074_ != null && !mc.f_91074_.f_36096_.m_142621_().m_41619_()) {
                ret.set(new StorageContentsTooltip(stack));
            }
        });
        return Optional.ofNullable(ret.get());
    }

    @Override
    public void setMainColor(ItemStack storageStack, int mainColor) {
        if (StorageBlockItem.getAccentColorFromStack(storageStack).isPresent()) {
            this.removeWoodType(storageStack);
        }
        super.setMainColor(storageStack, mainColor);
    }

    @Override
    public void setAccentColor(ItemStack storageStack, int accentColor) {
        if (StorageBlockItem.getMainColorFromStack(storageStack).isPresent()) {
            this.removeWoodType(storageStack);
        }
        super.setAccentColor(storageStack, accentColor);
    }

    private void removeWoodType(ItemStack storageStack) {
        storageStack.m_41784_().m_128473_(WOOD_TYPE_TAG);
    }

    public static Optional<WoodType> getWoodType(ItemStack storageStack) {
        return NBTHelper.getString((ItemStack)storageStack, (String)WOOD_TYPE_TAG).flatMap(woodType -> WoodType.m_61843_().filter(wt -> wt.f_61839_().equals(woodType)).findFirst());
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){
            private IStorageWrapper wrapper = null;

            @Nonnull
            public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
                if (stack.m_41613_() == 1 && cap == CapabilityStorageWrapper.getCapabilityInstance()) {
                    this.initWrapper();
                    return LazyOptional.of(() -> this.wrapper).cast();
                }
                return LazyOptional.empty();
            }

            private void initWrapper() {
                if (this.wrapper == null) {
                    UUID uuid = StorageBlockItem.getContentsUuid(stack).orElse(null);
                    StackStorageWrapper storageWrapper = new StackStorageWrapper(stack);
                    if (uuid != null) {
                        CompoundTag compoundtag = ItemContentsStorage.get().getOrCreateStorageContents(uuid).m_128469_("storageWrapper");
                        storageWrapper.load(compoundtag);
                        ((StorageWrapper)storageWrapper).setContentsUuid(uuid);
                    }
                    this.wrapper = storageWrapper;
                }
            }
        };
    }

    public static ItemStack setWoodType(ItemStack storageStack, WoodType woodType) {
        storageStack.m_41784_().m_128359_(WOOD_TYPE_TAG, woodType.f_61839_());
        return storageStack;
    }

    public Component m_7626_(ItemStack stack) {
        return WoodStorageBlockItem.getDisplayName(this.m_5524_(), WoodStorageBlockItem.getWoodType(stack).orElse(null));
    }

    public static Component getDisplayName(String descriptionId, @Nullable WoodType woodType) {
        if (woodType == null) {
            return Component.m_237110_((String)descriptionId, (Object[])new Object[]{"", ""});
        }
        return Component.m_237110_((String)descriptionId, (Object[])new Object[]{Component.m_237115_((String)("wood_name.sophisticatedstorage." + woodType.f_61839_().toLowerCase(Locale.ROOT))), " "});
    }
}

