/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor.vent;

import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.conductor.vent.forge.VentBlockImpl;
import com.railwayteam.railways.registry.CRShapes;
import com.simibubi.create.content.decoration.copycat.CopycatBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VentBlock
extends CopycatBlock
implements IWrenchable {
    public static final BooleanProperty CONDUCTOR_VISIBLE = BooleanProperty.m_61465_((String)"conductor_visible");
    public static final VoxelShape COLLISION_SHAPE = Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    public static final VoxelShape OUTLINE_SHAPE = CRShapes.BLOCK;

    protected VentBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)CONDUCTOR_VISIBLE, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{CONDUCTOR_VISIBLE}));
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static VentBlock create(BlockBehaviour.Properties properties) {
        return VentBlockImpl.create(properties);
    }

    public boolean canFaceBeOccluded(BlockState state, Direction face) {
        return true;
    }

    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        return true;
    }

    protected Optional<BlockPos> getTeleportTarget(Level level, BlockPos start, Direction prevDirection) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        BlockPos.MutableBlockPos end = start.m_122032_();
        int panic = (Integer)CRConfigs.server().conductors.maxVentLength.get();
        block0: while (true) {
            if (panic-- < 0) {
                return Optional.empty();
            }
            end.m_122173_(prevDirection);
            if (visited.contains(end)) {
                return Optional.empty();
            }
            if (level.m_8055_((BlockPos)end).m_60734_() == this) {
                visited.add(end.m_7949_());
                continue;
            }
            end.m_122173_(prevDirection.m_122424_());
            for (Direction direction : Direction.values()) {
                if (direction == prevDirection || direction == prevDirection.m_122424_()) continue;
                end.m_122173_(direction);
                if (visited.contains(end)) {
                    return Optional.empty();
                }
                if (level.m_8055_((BlockPos)end).m_60734_() == this) {
                    visited.add(end.m_7949_());
                    prevDirection = direction;
                    continue block0;
                }
                end.m_122173_(direction.m_122424_());
            }
            break;
        }
        end.m_122173_(prevDirection);
        if (level.m_8055_((BlockPos)end).m_60795_()) {
            return Optional.of(end.m_7949_());
        }
        end.m_122173_(prevDirection.m_122424_());
        for (Direction direction : Direction.values()) {
            if (direction == prevDirection || direction == prevDirection.m_122424_()) continue;
            end.m_122173_(direction);
            if (visited.contains(end)) {
                return Optional.empty();
            }
            if (level.m_8055_((BlockPos)end).m_60795_()) {
                return Optional.of(end.m_7949_());
            }
            end.m_122173_(direction.m_122424_());
        }
        return Optional.empty();
    }

    protected boolean teleportConductorInternal(Level level, BlockPos start, ConductorEntity conductor, @Nullable Direction prevDirection) {
        Optional<BlockPos> target;
        if (prevDirection == null) {
            BlockPos normal = conductor.m_20183_().m_121996_((Vec3i)start);
            prevDirection = Direction.m_122378_((int)normal.m_123341_(), (int)normal.m_123342_(), (int)normal.m_123343_());
            prevDirection = prevDirection == null ? Direction.NORTH : prevDirection.m_122424_();
        }
        if ((target = this.getTeleportTarget(level, start, prevDirection)).isPresent()) {
            BlockPos end = target.get();
            if (!level.m_8055_(end.m_7494_()).m_60795_()) {
                end = end.m_7495_();
            }
            conductor.teleportToForce((double)end.m_123341_() + 0.5, (double)end.m_123342_() + 0.0, (double)end.m_123343_() + 0.5);
            return true;
        }
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (level instanceof ServerLevel) {
                Direction direction;
                Optional<BlockPos> target;
                ServerLevel serverLevel = (ServerLevel)level;
                if (ConductorEntity.isPlayerDisguised(player) && (target = this.getTeleportTarget(level, pos, direction = hit.m_82434_().m_122424_())).isPresent()) {
                    BlockPos end = target.get();
                    if (!level.m_8055_(end.m_7494_()).m_60795_()) {
                        end = end.m_7495_();
                    }
                    serverPlayer.m_8999_(serverLevel, (double)end.m_123341_() + 0.5, (double)end.m_123342_() + 0.0, (double)end.m_123343_() + 0.5, serverPlayer.m_146908_(), serverPlayer.m_146909_());
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public void m_7892_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        super.m_7892_(state, level, pos, entity);
        this.teleportConductor(level, pos, entity, null);
    }

    public void teleportConductor(@NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity, @Nullable Direction direction) {
        if (level.f_46443_) {
            return;
        }
        if (entity instanceof ConductorEntity) {
            ConductorEntity conductor = (ConductorEntity)entity;
            if (direction != null || conductor.ventCooldown <= 0) {
                this.teleportConductorInternal(level, pos, conductor, direction);
            }
            conductor.ventCooldown = 20;
        }
    }

    @NotNull
    public VoxelShape m_5939_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        EntityCollisionContext ec;
        if (context instanceof EntityCollisionContext && (ec = (EntityCollisionContext)context).m_193113_() instanceof ConductorEntity) {
            return COLLISION_SHAPE;
        }
        return OUTLINE_SHAPE;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return OUTLINE_SHAPE;
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        throw new AssertionError();
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        throw new AssertionError();
    }
}

