/*
 * Decompiled with CFR 0.152.
 */
package net.jrdemiurge.difficultychaosintegration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class MajruszCompatibility {
    private static final String CONFIG_PATH = "config/majruszsdifficulty.json";

    public static void applyCompatibility() {
        try {
            JsonObject config = MajruszCompatibility.loadConfig();
            JsonObject features = config.getAsJsonObject("features");
            if (features == null) {
                features = new JsonObject();
                config.add("features", (JsonElement)features);
            }
            JsonObject mobGroups = new JsonObject();
            features.add("mob_groups", (JsonElement)mobGroups);
            mobGroups.add("piglins", (JsonElement)MajruszCompatibility.createMobGroup("expert", 0.25, true, new String[]{"minecraft:piglin"}, new String[]{"majruszsdifficulty:mob_groups/piglin_leader"}, new String[]{"minecraft:piglin"}, new String[]{"majruszsdifficulty:mob_groups/piglin_sidekick"}, 1, 3));
            mobGroups.add("skeletons", (JsonElement)MajruszCompatibility.createMobGroup("normal", 0.1, true, new String[]{"minecraft:skeleton"}, new String[]{"majruszsdifficulty:mob_groups/skeleton_leader"}, new String[]{"minecraft:skeleton"}, new String[]{"majruszsdifficulty:mob_groups/skeleton_sidekick"}, 1, 3));
            mobGroups.add("undead", (JsonElement)MajruszCompatibility.createMobGroup("normal", 0.1, true, new String[]{"minecraft:skeleton", "minecraft:stray", "minecraft:zombie", "minecraft:husk"}, new String[]{"majruszsdifficulty:undead_army/wave_3_skeleton", "majruszsdifficulty:undead_army/wave_3_skeleton", "majruszsdifficulty:undead_army/wave_3_mob", "majruszsdifficulty:undead_army/wave_3_mob"}, new String[]{"minecraft:skeleton", "minecraft:stray", "minecraft:zombie", "minecraft:husk"}, new String[]{"majruszsdifficulty:undead_army/wave_2_mob", "majruszsdifficulty:undead_army/wave_2_mob", "majruszsdifficulty:undead_army/wave_2_mob", "majruszsdifficulty:undead_army/wave_2_mob"}, 2, 4));
            mobGroups.add("zombie_miners", (JsonElement)MajruszCompatibility.createMobGroup("expert", 0.25, true, new String[]{"minecraft:zombie"}, new String[]{"majruszsdifficulty:mob_groups/zombie_leader"}, new String[]{"minecraft:zombie"}, new String[]{"majruszsdifficulty:mob_groups/zombie_sidekick"}, 1, 3));
            mobGroups.add("spiritof_chaos", (JsonElement)MajruszCompatibility.createMobGroup("master", 0.15, true, new String[]{"born_in_chaos_v1:fallen_chaos_knight", "born_in_chaos_v1:mother_spider", "born_in_chaos_v1:dire_hound_leader", "born_in_chaos_v1:glutton_fish", "born_in_chaos_v1:nightmare_stalker", "born_in_chaos_v1:missioner", "born_in_chaos_v1:krampus", "born_in_chaos_v1:sir_pumpkinhead", "born_in_chaos_v1:supreme_bonescaller", "born_in_chaos_v1:lifestealer_true_form"}, new String[]{"born_in_chaos_v1:spiritof_chaos"}, 1, 1));
            mobGroups.add("skeleton_demoman", (JsonElement)MajruszCompatibility.createMobGroup("expert", 0.15, true, new String[]{"born_in_chaos_v1:skeleton_demoman"}, new String[]{"born_in_chaos_v1:skeleton_demoman"}, 1, 3));
            mobGroups.add("supreme_bonescaller", (JsonElement)MajruszCompatibility.createMobGroup("expert", 0.15, true, new String[]{"born_in_chaos_v1:supreme_bonescaller"}, new String[]{"born_in_chaos_v1:fallen_chaos_knight", "born_in_chaos_v1:skeleton_thrasher"}, 1, 3));
            mobGroups.add("bonescaller", (JsonElement)MajruszCompatibility.createMobGroup("expert", 0.15, true, new String[]{"born_in_chaos_v1:bonescaller"}, new String[]{"born_in_chaos_v1:door_knight"}, 1, 3));
            mobGroups.add("zombie_bruiser", (JsonElement)MajruszCompatibility.createMobGroup("expert", 0.15, true, new String[]{"born_in_chaos_v1:zombie_bruiser"}, new String[]{"born_in_chaos_v1:zombie_clown", "born_in_chaos_v1:zombie_lumberjack"}, 1, 3));
            mobGroups.add("spirit_guide", (JsonElement)MajruszCompatibility.createMobGroup("expert", 0.15, true, new String[]{"born_in_chaos_v1:spirit_guide"}, new String[]{"born_in_chaos_v1:siamese_skeletons"}, 2, 3));
            mobGroups.add("swarmer", (JsonElement)MajruszCompatibility.createMobGroup("expert", 0.15, true, new String[]{"born_in_chaos_v1:swarmer"}, new String[]{"born_in_chaos_v1:bloody_gadfly"}, 1, 3));
            mobGroups.add("fallen_chaos_knight", (JsonElement)MajruszCompatibility.createMobGroup("expert", 0.15, true, new String[]{"born_in_chaos_v1:fallen_chaos_knight"}, new String[]{"born_in_chaos_v1:dark_vortex", "born_in_chaos_v1:fallen_chaos_knight"}, 1, 3));
            mobGroups.add("seared_spirit", (JsonElement)MajruszCompatibility.createMobGroup("expert", 0.15, true, new String[]{"born_in_chaos_v1:seared_spirit"}, new String[]{"born_in_chaos_v1:firelight", "born_in_chaos_v1:bone_imp"}, 2, 4));
            mobGroups.add("barrel_zombie", (JsonElement)MajruszCompatibility.createMobGroup("expert", 0.15, true, new String[]{"born_in_chaos_v1:barrel_zombie"}, new String[]{"born_in_chaos_v1:zombie_fisherman"}, 1, 3));
            mobGroups.add("mother_spider", (JsonElement)MajruszCompatibility.createMobGroup("expert", 0.15, true, new String[]{"born_in_chaos_v1:mother_spider"}, new String[]{"born_in_chaos_v1:swarmer"}, 2, 2));
            JsonObject undeadArmy = config.getAsJsonObject("undead_army");
            if (undeadArmy == null) {
                undeadArmy = new JsonObject();
                config.add("undead_army", (JsonElement)undeadArmy);
            }
            JsonArray waves = new JsonArray();
            undeadArmy.add("waves", (JsonElement)waves);
            waves.add((JsonElement)MajruszCompatibility.createWave(new String[][]{{"born_in_chaos_v1:siamese_skeletons", "3"}, {"born_in_chaos_v1:spirit_guide", "3"}}, "normal", 8, null));
            waves.add((JsonElement)MajruszCompatibility.createWave(new String[][]{{"born_in_chaos_v1:door_knight", "3"}, {"born_in_chaos_v1:bonescaller", "3"}}, "normal", 16, null));
            waves.add((JsonElement)MajruszCompatibility.createWave(new String[][]{{"born_in_chaos_v1:skeleton_thrasher", "2"}, {"born_in_chaos_v1:dark_vortex", "2"}, {"born_in_chaos_v1:fallen_chaos_knight", "1"}, {"born_in_chaos_v1:supreme_bonescaller", "1"}}, "normal", 24, new String[]{"born_in_chaos_v1:nightmare_stalker", "1"}));
            waves.add((JsonElement)MajruszCompatibility.createWave(new String[][]{{"born_in_chaos_v1:swarmer", "6"}, {"born_in_chaos_v1:mother_spider", "2"}}, "expert", 32, null));
            waves.add((JsonElement)MajruszCompatibility.createWave(new String[][]{{"born_in_chaos_v1:skeleton_thrasher", "2"}, {"born_in_chaos_v1:dark_vortex", "2"}, {"born_in_chaos_v1:nightmare_stalker", "1"}, {"born_in_chaos_v1:fallen_chaos_knight", "2"}, {"born_in_chaos_v1:supreme_bonescaller", "2"}}, "expert", 40, new String[]{"born_in_chaos_v1:lifestealer_true_form", "1"}));
            waves.add((JsonElement)MajruszCompatibility.createWave(new String[][]{{"born_in_chaos_v1:zombie_clown", "6"}, {"born_in_chaos_v1:nightmare_stalker", "1"}, {"born_in_chaos_v1:lifestealer_true_form", "1"}}, "master", 48, new String[]{"majruszsdifficulty:giant", "1", "majruszsdifficulty:undead_army/wave_6_mob"}));
            MajruszCompatibility.saveConfig(config);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static JsonObject loadConfig() throws IOException {
        Path path = Path.of(CONFIG_PATH, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(path);){
                JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                return jsonObject;
            }
        }
        return new JsonObject();
    }

    private static void saveConfig(JsonObject config) throws IOException {
        Path path = Path.of(CONFIG_PATH, new String[0]);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            gson.toJson((JsonElement)config, (Appendable)writer);
        }
    }

    private static JsonObject createMobGroup(String gameStage, double chance, boolean isScaledByCRD, String[] leaderTypes, String[] leaderEquipments, String[] sidekickTypes, String[] sidekickEquipments, int minSidekicks, int maxSidekicks) {
        JsonObject group = new JsonObject();
        group.add("required_game_stage", (JsonElement)new JsonPrimitive(gameStage));
        group.add("chance", (JsonElement)new JsonPrimitive((Number)chance));
        group.add("is_scaled_by_crd", (JsonElement)new JsonPrimitive(Boolean.valueOf(isScaledByCRD)));
        JsonArray leaders = new JsonArray();
        for (int i = 0; i < leaderTypes.length; ++i) {
            JsonObject leaderObj = new JsonObject();
            leaderObj.add("type", (JsonElement)new JsonPrimitive(leaderTypes[i]));
            leaderObj.add("equipment", (JsonElement)new JsonPrimitive(leaderEquipments[i]));
            leaders.add((JsonElement)leaderObj);
        }
        group.add("leader_types", (JsonElement)leaders);
        JsonObject sidekicksCount = new JsonObject();
        sidekicksCount.add("min", (JsonElement)new JsonPrimitive((Number)minSidekicks));
        sidekicksCount.add("max", (JsonElement)new JsonPrimitive((Number)maxSidekicks));
        group.add("sidekicks_count", (JsonElement)sidekicksCount);
        JsonArray sidekicks = new JsonArray();
        for (int i = 0; i < sidekickTypes.length; ++i) {
            JsonObject sidekickObj = new JsonObject();
            sidekickObj.add("type", (JsonElement)new JsonPrimitive(sidekickTypes[i]));
            sidekickObj.add("equipment", (JsonElement)new JsonPrimitive(sidekickEquipments[i]));
            sidekicks.add((JsonElement)sidekickObj);
        }
        group.add("sidekick_types", (JsonElement)sidekicks);
        return group;
    }

    private static JsonObject createMobGroup(String gameStage, double chance, boolean isScaledByCRD, String[] leaderTypes, String[] sidekickTypes, int minSidekicks, int maxSidekicks) {
        JsonObject group = new JsonObject();
        group.add("required_game_stage", (JsonElement)new JsonPrimitive(gameStage));
        group.add("chance", (JsonElement)new JsonPrimitive((Number)chance));
        group.add("is_scaled_by_crd", (JsonElement)new JsonPrimitive(Boolean.valueOf(isScaledByCRD)));
        JsonArray leaders = new JsonArray();
        for (String leader : leaderTypes) {
            JsonObject leaderObj = new JsonObject();
            leaderObj.add("type", (JsonElement)new JsonPrimitive(leader));
            leaderObj.add("equipment", (JsonElement)new JsonPrimitive(""));
            leaders.add((JsonElement)leaderObj);
        }
        group.add("leader_types", (JsonElement)leaders);
        JsonObject sidekicksCount = new JsonObject();
        sidekicksCount.add("min", (JsonElement)new JsonPrimitive((Number)minSidekicks));
        sidekicksCount.add("max", (JsonElement)new JsonPrimitive((Number)maxSidekicks));
        group.add("sidekicks_count", (JsonElement)sidekicksCount);
        JsonArray sidekicks = new JsonArray();
        for (String sidekick : sidekickTypes) {
            JsonObject sidekickObj = new JsonObject();
            sidekickObj.add("type", (JsonElement)new JsonPrimitive(sidekick));
            sidekickObj.add("equipment", (JsonElement)new JsonPrimitive(""));
            sidekicks.add((JsonElement)sidekickObj);
        }
        group.add("sidekick_types", (JsonElement)sidekicks);
        return group;
    }

    private static JsonObject createWave(String[][] mobs, String gameStage, int exp, String[] boss) {
        JsonObject wave = new JsonObject();
        JsonArray mobsArray = new JsonArray();
        for (String[] mob : mobs) {
            JsonObject mobObject = new JsonObject();
            mobObject.addProperty("type", mob[0]);
            mobObject.addProperty("count", (Number)Integer.parseInt(mob[1]));
            mobsArray.add((JsonElement)mobObject);
        }
        wave.add("mobs", (JsonElement)mobsArray);
        if (boss != null) {
            JsonObject bossObject = new JsonObject();
            bossObject.addProperty("type", boss[0]);
            bossObject.addProperty("count", (Number)Integer.parseInt(boss[1]));
            if (boss.length > 2) {
                bossObject.addProperty("equipment", boss[2]);
            }
            wave.add("boss", (JsonElement)bossObject);
        }
        wave.addProperty("game_stage", gameStage);
        wave.addProperty("exp", (Number)exp);
        return wave;
    }
}

